/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.resource;

import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Logger;

public class DefaultLocales
implements Locales {
    private final Resources resources;
    private Locale locale;
    private List<Locale> locales = new ArrayList<Locale>();
    private static final Logger logger = Logger.getLogger(DefaultLocales.class.getName());

    public DefaultLocales(Resources resources) {
        this.resources = resources;
        List<String> codes = this.getSupportedLocales();
        if (!codes.isEmpty()) {
            Locale defaultLocale = Locale.getDefault();
            Map<String, Locale> iso3 = this.getLocalesByISO3(defaultLocale);
            for (String code : codes) {
                Locale locale = iso3.get(code);
                if (locale == null) {
                    logger.warning("No locale for: " + code);
                    continue;
                }
                this.locales.add(locale);
            }
            if (!this.locales.isEmpty()) {
                this.locale = this.locales.contains(defaultLocale) ? defaultLocale : this.locales.get(0);
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale(String code) {
        int length = code.length();
        for (Locale locale : this.locales) {
            if (!(length == 3 ? code.equalsIgnoreCase(locale.getISO3Language()) : code.equalsIgnoreCase(locale.getLanguage()))) continue;
            return locale;
        }
        return null;
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public Messages getMessages() {
        if (this.locale == null) {
            throw new ResourceException("No locale set");
        }
        InputStream in = this.resources.getInputStream("langpacks/" + this.locale.getISO3Language() + ".xml");
        return new LocaleDatabase(in, (Locales)this);
    }

    @Override
    public Messages getMessages(String name) {
        InputStream in = this.resources.getInputStream(name);
        return new LocaleDatabase(in, (Locales)this);
    }

    public List<String> getSupportedLocales() {
        try {
            return (List)this.resources.getObject("langpacks.info");
        }
        catch (ResourceNotFoundException exception) {
            return Collections.emptyList();
        }
    }

    private Map<String, Locale> getLocalesByISO3(Locale defaultLocale) {
        String defaultCode = this.getISO3Language(defaultLocale);
        HashMap<String, Locale> iso3 = new HashMap<String, Locale>();
        if (defaultCode != null) {
            iso3.put(defaultCode, defaultLocale);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            Locale existing;
            String code = this.getISO3Language(locale);
            if (code.equals(defaultCode) || (existing = (Locale)iso3.get(code)) != null && !locale.getCountry().isEmpty()) continue;
            iso3.put(code, locale);
        }
        return iso3;
    }

    private String getISO3Language(Locale locale) {
        String result;
        try {
            result = locale.getISO3Language();
        }
        catch (MissingResourceException ignore) {
            result = null;
        }
        return result;
    }
}

