/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.logic.OrCondition;

public class XorCondition
extends OrCondition {
    private static final long serialVersionUID = 3148555083095194992L;

    public XorCondition(RulesEngine rules) {
        super(rules);
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() > 2) {
            throw new Exception("Not more than two operands allowed in XOR condition \"" + this.getId() + "\"");
        }
        super.readFromXML(xmlcondition);
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        boolean marked = false;
        for (Condition condition : this.nestedConditions) {
            boolean currentResult = condition.isTrue();
            if (!marked) {
                result = currentResult;
                marked = true;
                continue;
            }
            result ^= currentResult;
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        for (Condition condition : this.nestedConditions) {
            details.append(condition.getDependenciesDetails());
            details.append("</li> XOR <li>");
        }
        details.append("</li></ul>");
        return details.toString();
    }
}

