/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.Condition;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ExistsCondition
extends Condition {
    private static final long serialVersionUID = -7424383017678759732L;
    private static final transient Logger logger = Logger.getLogger(ExistsCondition.class.getName());
    private ContentType contentType;
    private String content;

    public ExistsCondition() {
    }

    public ExistsCondition(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        switch (this.contentType) {
            case VARIABLE: {
                String value;
                if (this.content == null || (value = this.getInstallData().getVariable(this.content)) == null) break;
                result = true;
                break;
            }
            case FILE: {
                Variables variables;
                File file;
                if (this.content == null || !(file = new File((variables = this.getInstallData().getVariables()).replace(this.content))).exists()) break;
                result = true;
                break;
            }
            default: {
                logger.warning("Illegal content type '" + this.contentType.getAttribute() + "' of ExistsCondition");
            }
        }
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition != null) {
            if (xmlcondition.getChildrenCount() != 1) {
                throw new Exception("Condition \"" + this.getId() + "\" needs exactly one nested element");
            }
            IXMLElement child = xmlcondition.getChildAtIndex(0);
            this.contentType = ContentType.getFromAttribute(child.getName());
            if (this.contentType == null) {
                throw new Exception("Unknown nested element '" + child.getName() + "' to condition \"" + this.getId() + "\"");
            }
            this.content = child.getContent();
            if (this.content == null || this.content.length() == 0) {
                throw new Exception("Condition \"" + this.getId() + "\" has a nested element without valid contents");
            }
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl el = new XMLElementImpl(this.contentType.getAttribute(), conditionRoot);
        el.setContent(this.content);
        conditionRoot.addChild(el);
    }

    public static enum ContentType {
        VARIABLE("variable"),
        FILE("file");

        private static Map<String, ContentType> lookup;
        private String attribute;

        private ContentType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ContentType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ContentType>();
            for (ContentType operation : EnumSet.allOf(ContentType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }
    }
}

