/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.ActionBase;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String BSFACTIONS = "bsfactions";
    public static final String BSFACTION = "bsfaction";
    public static final String BEFOREFILE = "beforefile";
    public static final String AFTERFILE = "afterfile";
    public static final String BEFOREDIR = "beforedir";
    public static final String AFTERDIR = "afterdir";
    public static final String BEFOREDELETE = "beforedelete";
    public static final String AFTERDELETE = "afterdelete";
    public static final String BEFOREDELETION = "beforedeletion";
    public static final String AFTERDELETION = "afterdeletion";
    private String script = null;
    private String language = null;
    private String scriptName = null;
    private transient BSFManager manager = null;
    private transient BSFEngine engine = null;
    private static Map<String, MethodDescriptor> orderMethodMap = null;
    private Properties variables = new Properties();
    private static Map<String, MethodExistenceChecker> langToMethodCheckerMap = new HashMap<String, MethodExistenceChecker>();

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void init() throws Exception {
        if (this.manager == null) {
            this.manager = new BSFManager();
        }
        if (this.engine == null) {
            this.engine = this.manager.loadScriptingEngine(this.language);
            this.scriptName = "script." + this.language;
            this.engine.exec(this.scriptName, 1, 1, (Object)this.script);
        }
    }

    public void destroy() throws Exception {
        if (this.engine != null) {
            this.engine.terminate();
            this.engine = null;
        }
        if (this.manager != null) {
            this.manager.terminate();
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUninstall(String order, Object[] params) throws Exception {
        MethodDescriptor desc = orderMethodMap.get(order);
        if (desc != null) {
            try {
                block15: {
                    for (int i = 0; i < desc.argNames.length; ++i) {
                        if (params[i] == null) continue;
                        this.manager.declareBean(desc.argNames[i], params[i], params[i].getClass());
                    }
                    this.manager.declareBean("variables", (Object)this.variables, Properties.class);
                    MethodExistenceChecker checker = langToMethodCheckerMap.get(this.language);
                    try {
                        if (checker == null) break block15;
                        if (!checker.isMethodDefined(desc.name, this.scriptName, this.engine, this.manager)) {
                            return;
                        }
                    }
                    catch (BSFException e) {
                        e.printStackTrace();
                        if (desc.argNames != null) {
                            for (int i = 0; i < desc.argNames.length; ++i) {
                                this.manager.undeclareBean(desc.argNames[i]);
                            }
                        }
                        this.manager.undeclareBean("variables");
                        return;
                    }
                }
                this.engine.eval(this.scriptName, 1, 1, (Object)desc.name);
                this.engine.exec(this.scriptName, 1, 1, (Object)(desc.name + "()"));
            }
            finally {
                if (desc.argNames != null) {
                    for (int i = 0; i < desc.argNames.length; ++i) {
                        this.manager.undeclareBean(desc.argNames[i]);
                    }
                }
                this.manager.undeclareBean("variables");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String order, Object[] params, Object idata) throws Exception {
        MethodDescriptor desc = orderMethodMap.get(order);
        if (desc != null) {
            try {
                block17: {
                    for (int i = 0; i < desc.argNames.length; ++i) {
                        if (params[i] == null) continue;
                        this.manager.declareBean(desc.argNames[i], params[i], params[i].getClass());
                    }
                    Method method = null;
                    Class<?> clazz = idata.getClass();
                    while (method == null && clazz != Object.class) {
                        try {
                            method = clazz.getDeclaredMethod("getVariables", new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    if (method != null) {
                        Properties properties = (Properties)method.invoke(idata, new Object[0]);
                        this.variables.putAll((Map<?, ?>)properties);
                    }
                    this.manager.declareBean("installData", idata, Class.forName("com.izforge.izpack.installer.AutomatedInstallData"));
                    MethodExistenceChecker checker = langToMethodCheckerMap.get(this.language);
                    try {
                        if (checker == null) break block17;
                        if (!checker.isMethodDefined(desc.name, this.scriptName, this.engine, this.manager)) {
                            return;
                        }
                    }
                    catch (BSFException e) {
                        e.printStackTrace();
                        for (int i = 0; i < desc.argNames.length; ++i) {
                            this.manager.undeclareBean(desc.argNames[i]);
                        }
                        this.manager.undeclareBean("installData");
                        return;
                    }
                }
                this.engine.eval(this.scriptName, 1, 1, (Object)desc.name);
                this.engine.exec(this.scriptName, 1, 1, (Object)(desc.name + "()"));
            }
            finally {
                for (int i = 0; i < desc.argNames.length; ++i) {
                    this.manager.undeclareBean(desc.argNames[i]);
                }
                this.manager.undeclareBean("installData");
            }
        }
    }

    static {
        orderMethodMap = new HashMap<String, MethodDescriptor>();
        orderMethodMap.put(BEFOREDELETION, new MethodDescriptor("beforeDeletion", new String[]{"files", "handler"}));
        orderMethodMap.put(AFTERDELETION, new MethodDescriptor("afterDeletion", new String[]{"files", "handler"}));
        orderMethodMap.put(BEFOREDELETE, new MethodDescriptor("beforeDelete", new String[]{"file", "handler"}));
        orderMethodMap.put(AFTERDELETE, new MethodDescriptor("afterDelete", new String[]{"file", "handler"}));
        orderMethodMap.put(BEFOREDIR, new MethodDescriptor("beforeDir", new String[]{"file", "pack"}));
        orderMethodMap.put(AFTERDIR, new MethodDescriptor("afterDir", new String[]{"file", "pack"}));
        orderMethodMap.put(BEFOREFILE, new MethodDescriptor("beforeFile", new String[]{"file", "pack"}));
        orderMethodMap.put(AFTERFILE, new MethodDescriptor("afterFile", new String[]{"file", "pack"}));
        orderMethodMap.put("beforepacks", new MethodDescriptor("beforePacks", new String[]{"installData", "npacks", "handler"}));
        orderMethodMap.put("afterpacks", new MethodDescriptor("afterPacks", new String[]{"installData", "handler"}));
        orderMethodMap.put("beforepack", new MethodDescriptor("beforePack", new String[]{"pack", "i", "handler"}));
        orderMethodMap.put("afterpack", new MethodDescriptor("afterPack", new String[]{"pack", "i", "handler"}));
        langToMethodCheckerMap.put("beanshell", new MethodExistenceChecker(){

            @Override
            public boolean isMethodDefined(String method, String scriptName, BSFEngine engine, BSFManager manager) throws BSFException {
                String script = "this.namespace.getMethod(\"" + method + "\", new Class[0])";
                Object res = engine.eval(scriptName, 1, 1, (Object)script);
                return res != null;
            }
        });
    }

    private static interface MethodExistenceChecker {
        public boolean isMethodDefined(String var1, String var2, BSFEngine var3, BSFManager var4) throws BSFException;
    }

    private static class MethodDescriptor {
        private String name;
        private String[] argNames;

        public MethodDescriptor(String name, String[] argNames) {
            this.name = name;
            this.argNames = argNames;
        }
    }
}

