/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.util.SummaryProcessor;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SummaryLoggerInstallerListener
extends SimpleInstallerListener {
    public SummaryLoggerInstallerListener(Resources resources) {
        super(resources, false);
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (idata instanceof GUIInstallData) {
            GUIInstallData installData = (GUIInstallData)idata;
            if (!installData.isInstallSuccess()) {
                return;
            }
            if (installData.getPanels().isEmpty()) {
                return;
            }
            String path = installData.getInfo().getSummaryLogFilePath();
            if (path == null) {
                return;
            }
            File parent = new File(path = IoHelper.translatePath(path, idata.getVariables())).getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            String summary = SummaryProcessor.getSummary(installData);
            FileOutputStream out = new FileOutputStream(path);
            ((OutputStream)out).write(summary.getBytes("utf-8"));
            ((OutputStream)out).close();
        }
    }
}

