/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.console.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatedInstaller
extends InstallerBase {
    private static final Logger logger = Logger.getLogger(AutomatedInstaller.class.getName());
    private TreeMap<String, Integer> panelInstanceCount;
    private final AutomatedInstallData installData;
    private boolean result = false;
    private RequirementsChecker requirements;
    private UninstallDataWriter uninstallDataWriter;
    private Variables variables;
    private final Locales locales;
    private final ObjectFactory factory;
    private final Housekeeper housekeeper;

    public AutomatedInstaller(AutomatedInstallData installData, Locales locales, RequirementsChecker requirements, UninstallDataWriter uninstallDataWriter, Variables variables, ObjectFactory factory, Housekeeper housekeeper) {
        this.installData = installData;
        this.locales = locales;
        this.requirements = requirements;
        this.uninstallDataWriter = uninstallDataWriter;
        this.panelInstanceCount = new TreeMap();
        this.variables = variables;
        this.factory = factory;
        this.housekeeper = housekeeper;
    }

    public void init(String inputFilename, String mediaPath) throws Exception {
        File input = new File(inputFilename);
        this.installData.setXmlData(this.getXMLData(input));
        String code = this.installData.getXmlData().getAttribute("langpack", "eng");
        Locale locale = this.locales.getLocale(code);
        this.installData.setLocale(locale);
        this.installData.setMessages(this.locales.getMessages());
        this.installData.setMediaPath(mediaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstall() throws Exception {
        boolean reboot;
        block29: {
            this.installData.refreshVariables();
            if (!this.requirements.check()) {
                System.out.println("[ Automated installation FAILED! ]");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            logger.info("[ Starting automated installation ]");
            ConsolePanelAutomationHelper uihelper = new ConsolePanelAutomationHelper(this.housekeeper);
            try {
                this.result = true;
                for (Panel p : this.installData.getPanelsOrder()) {
                    RulesEngine rules = this.installData.getRules();
                    if (!rules.canShowPanel(p.getPanelid(), this.installData.getVariables())) {
                        logger.fine("Condition for panel " + p.getPanelid() + "is not fulfilled, skipping panel!");
                        if (this.panelInstanceCount.containsKey(p.className)) {
                            this.panelInstanceCount.put(p.className, this.panelInstanceCount.get(p.className) + 1);
                            continue;
                        }
                        this.panelInstanceCount.put(p.className, 1);
                        continue;
                    }
                    if (!OsConstraintHelper.oneMatchesCurrentSystem(p.getOsConstraints())) continue;
                    PanelAutomation automationHelper = this.getPanelAutomationHelper(p);
                    if (automationHelper == null) {
                        this.executePreValidateActions(p, uihelper);
                        this.validatePanel(p);
                        this.executePostValidateActions(p, uihelper);
                        continue;
                    }
                    IXMLElement panelRoot = this.updateInstanceCount(p);
                    this.installPanel(p, automationHelper, panelRoot);
                    this.installData.refreshVariables();
                }
                if (this.uninstallDataWriter.isUninstallRequired()) {
                    this.result = this.uninstallDataWriter.write();
                }
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                reboot = false;
                if (!this.installData.isRebootNecessary()) break block29;
                System.out.println("[ There are file operations pending after reboot ]");
            }
            catch (Exception e) {
                boolean reboot2;
                block30: {
                    try {
                        this.result = false;
                        System.err.println(e.toString());
                        e.printStackTrace();
                        if (this.result) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        reboot2 = false;
                        if (!this.installData.isRebootNecessary()) break block30;
                        System.out.println("[ There are file operations pending after reboot ]");
                    }
                    catch (Throwable throwable) {
                        if (this.result) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        boolean reboot3 = false;
                        if (this.installData.isRebootNecessary()) {
                            System.out.println("[ There are file operations pending after reboot ]");
                            switch (this.installData.getInfo().getRebootAction()) {
                                case 3: {
                                    reboot3 = true;
                                }
                            }
                            if (reboot3) {
                                System.out.println("[ Rebooting now automatically ]");
                            }
                        }
                        this.housekeeper.shutDown(this.result ? 0 : 1, reboot3);
                        throw throwable;
                    }
                    switch (this.installData.getInfo().getRebootAction()) {
                        case 3: {
                            reboot2 = true;
                        }
                    }
                    if (reboot2) {
                        System.out.println("[ Rebooting now automatically ]");
                    }
                }
                this.housekeeper.shutDown(this.result ? 0 : 1, reboot2);
            }
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(this.result ? 0 : 1, reboot);
    }

    private void installPanel(Panel p, PanelAutomation automationHelper, IXMLElement panelRoot) throws InstallerException {
        this.executePreActivateActions(p, null);
        logger.fine("automationHelperInstance.runAutomated: " + automationHelper.getClass().getName() + " entered.");
        automationHelper.runAutomated(this.installData, panelRoot);
        logger.fine("automationHelperInstance.runAutomated: " + automationHelper.getClass().getName() + " successfully done.");
        this.executePreValidateActions(p, null);
        this.validatePanel(p);
        this.executePostValidateActions(p, null);
    }

    private IXMLElement updateInstanceCount(Panel p) {
        String panelClassName = p.className;
        List<IXMLElement> panelRoots = this.installData.getXmlData().getChildrenNamed(panelClassName);
        int panelRootNo = 0;
        if (this.panelInstanceCount.containsKey(panelClassName)) {
            panelRootNo = this.panelInstanceCount.get(panelClassName);
        }
        IXMLElement panelRoot = panelRoots.get(panelRootNo);
        this.panelInstanceCount.put(panelClassName, panelRootNo + 1);
        return panelRoot;
    }

    private PanelAutomation getPanelAutomationHelper(Panel p) {
        Class<?> automationHelperClass = null;
        PanelAutomation automationHelperInstance = null;
        String praefix = "com.izforge.izpack.panels.";
        if (p.className.contains(".")) {
            praefix = "";
        }
        String automationHelperClassName = praefix + p.className + "AutomationHelper";
        try {
            logger.fine("AutomationHelper: " + automationHelperClassName);
            automationHelperClass = Class.forName(automationHelperClassName);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "AutomationHelper class not found: " + automationHelperClassName, e);
        }
        this.executePreConstructActions(p, null);
        if (automationHelperClass != null) {
            try {
                logger.fine("Instantiate :" + automationHelperClassName);
                automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, "no default constructor for " + automationHelperClassName + ", skipping...", e);
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, "no default constructor for " + automationHelperClassName + ", skipping...", e);
            }
        }
        return automationHelperInstance;
    }

    private void validatePanel(Panel p) throws InstallerException {
        DataValidator dataValidator;
        String dataValidator2;
        DataValidator.Status validationResult;
        this.installData.refreshVariables();
        List<DynamicInstallerRequirementValidator> dynConds = this.installData.getDynamicinstallerrequirements();
        Messages messages = this.installData.getMessages();
        if (dynConds != null) {
            for (DynamicInstallerRequirementValidator dynamicInstallerRequirementValidator : dynConds) {
                validationResult = dynamicInstallerRequirementValidator.validateData(this.installData);
                if (validationResult == DataValidator.Status.OK) continue;
                String message = messages.get(dynamicInstallerRequirementValidator.getErrorMessageId(), new Object[0]);
                String errorMessage = messages.get("data.validation.error.title", new Object[0]) + ": " + this.variables.replace(message);
                if (validationResult == DataValidator.Status.WARNING && dynamicInstallerRequirementValidator.getDefaultAnswer()) {
                    System.out.println(errorMessage + " - ignoring");
                    return;
                }
                this.result = false;
                logger.warning("Dynamic installer requirement validation (" + dynamicInstallerRequirementValidator.getClass().getName() + ") failed");
                throw new InstallerException(errorMessage);
            }
        }
        if ((dataValidator2 = p.getValidator()) != null && (validationResult = (dataValidator = this.factory.create(dataValidator2, DataValidator.class, new Object[0])).validateData(this.installData)) != DataValidator.Status.OK) {
            String errorMessage = messages.get("data.validation.error.title", new Object[0]) + ": " + this.variables.replace(messages.get(dataValidator.getErrorMessageId(), new Object[0]));
            if (validationResult == DataValidator.Status.WARNING && dataValidator.getDefaultAnswer()) {
                System.out.println(errorMessage + " - ignoring");
                return;
            }
            this.result = false;
            logger.warning("Data validation (" + dataValidator.getClass().getName() + ") failed");
            throw new InstallerException(errorMessage);
        }
    }

    public IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser();
        IXMLElement rtn = parser.parse(in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> actions) {
        ArrayList<PanelAction> actionList = null;
        if (actions != null) {
            actionList = new ArrayList<PanelAction>();
            for (String actionClassName : actions) {
                PanelAction action = this.factory.create(actionClassName, PanelAction.class, new Object[0]);
                action.initialize(panel.getPanelActionConfiguration(actionClassName));
                actionList.add(action);
            }
        }
        return actionList;
    }

    private void executePreConstructActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preConstructActions = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (preConstructActions != null) {
            for (PanelAction preConstructAction : preConstructActions) {
                preConstructAction.executeAction(this.installData, handler);
            }
        }
    }

    private void executePreActivateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preActivateActions = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (preActivateActions != null) {
            for (PanelAction preActivateAction : preActivateActions) {
                preActivateAction.executeAction(this.installData, handler);
            }
        }
    }

    private void executePreValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preValidateActions = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (preValidateActions != null) {
            for (PanelAction preValidateAction : preValidateActions) {
                preValidateAction.executeAction(this.installData, handler);
            }
        }
    }

    private void executePostValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> postValidateActions = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (postValidateActions != null) {
            for (PanelAction postValidateAction : postValidateActions) {
                postValidateAction.executeAction(this.installData, handler);
            }
        }
    }
}

