/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.console.PanelConsoleFactory;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.OsConstraintHelper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ConsoleAction {
    private static final Logger logger = Logger.getLogger(ConsoleAction.class.getName());
    private final PanelConsoleFactory factory;
    private final AutomatedInstallData installData;
    private final ObjectFactory objectFactory;
    private final RulesEngine rules;

    public ConsoleAction(PanelConsoleFactory factory, AutomatedInstallData installData, ObjectFactory objectFactory, RulesEngine rules) {
        this.factory = factory;
        this.installData = installData;
        this.objectFactory = objectFactory;
        this.rules = rules;
    }

    public boolean run(Console console) {
        boolean result = false;
        try {
            this.installData.setCurPanelNumber(-1);
            for (Panel panel : this.installData.getPanelsOrder()) {
                this.installData.setCurPanelNumber(this.installData.getCurPanelNumber() + 1);
                if (!this.canShow(panel) || (result = this.run(panel, console))) {
                    this.installData.refreshVariables();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            result = false;
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
        if (!result && this.isInstall()) {
            this.installData.setInstallSuccess(false);
        }
        return result;
    }

    public boolean isInstall() {
        return true;
    }

    protected boolean run(Panel panel, Console console) {
        boolean result;
        try {
            PanelConsole action = this.factory.create(panel);
            logger.info("Running panel " + panel.getClassName());
            result = this.run(panel, action, console);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Console installation failed for panel " + panel.getClassName(), e);
            result = false;
        }
        if (result) {
            logger.info("Panel: " + panel.getClassName() + " completed successfully");
        }
        return result;
    }

    protected abstract boolean run(Panel var1, PanelConsole var2, Console var3) throws InstallerException;

    protected boolean canShow(Panel panel) {
        String id = panel.getPanelid();
        boolean result = OsConstraintHelper.oneMatchesCurrentSystem(panel.getOsConstraints());
        if (result) {
            result = panel.hasCondition() ? this.rules.isConditionTrue(panel.getCondition()) : this.rules.canShowPanel(id, this.installData.getVariables());
        }
        if (!result) {
            logger.fine("Skip panel with panelid=" + id);
        } else {
            logger.fine("Showing panel with panelid=" + id);
        }
        return result;
    }

    protected boolean validatePanel(Panel panel, Console console) throws InstallerException {
        DataValidator dataValidator;
        String dataValidator2;
        DataValidator.Status validationResult;
        this.installData.refreshVariables();
        List<DynamicInstallerRequirementValidator> dynConds = this.installData.getDynamicinstallerrequirements();
        if (dynConds != null) {
            for (DynamicInstallerRequirementValidator dynamicInstallerRequirementValidator : dynConds) {
                validationResult = dynamicInstallerRequirementValidator.validateData(this.installData);
                if (validationResult == DataValidator.Status.OK) continue;
                String errorMessage = this.format("data.validation.error.title", new Object[0]) + ": " + this.installData.getVariables().replace(this.format(dynamicInstallerRequirementValidator.getErrorMessageId(), new Object[0]));
                if (validationResult == DataValidator.Status.WARNING && dynamicInstallerRequirementValidator.getDefaultAnswer()) {
                    console.println(errorMessage + " - ignoring");
                    continue;
                }
                logger.warning("Data validation (" + dynamicInstallerRequirementValidator.getClass().getName() + ") failed");
                return false;
            }
        }
        if ((dataValidator2 = panel.getValidator()) != null && (validationResult = (dataValidator = this.objectFactory.create(dataValidator2, DataValidator.class, new Object[0])).validateData(this.installData)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && dataValidator.getDefaultAnswer()) {
                console.println("Configuration said, it's ok to go on, if validation is not successfull");
            } else {
                console.println("Validation failed, please verify your input");
                return false;
            }
        }
        return true;
    }

    protected AutomatedInstallData getInstallData() {
        return this.installData;
    }

    protected String format(String key, Object ... args) {
        return this.installData.getMessages().get(key, args);
    }
}

