/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.debugger.Debugger;
import com.izforge.izpack.installer.gui.GUIListener;
import com.izforge.izpack.installer.gui.InstallerView;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.WindowHandler;
import com.izforge.izpack.installer.manager.PanelManager;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class InstallerFrame
extends JFrame
implements InstallerView {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final transient Logger logger = Logger.getLogger(InstallerFrame.class.getName());
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    private Messages messages;
    private GUIInstallData installdata;
    private IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton helpButton = null;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected ArrayList<GUIListener> guiListener = new ArrayList();
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private Debugger debugger;
    private boolean imageLeft = false;
    private PanelManager panelManager;
    private ResourceManager resourceManager;
    private UninstallDataWriter uninstallDataWriter;
    private Variables variables;
    private UninstallData uninstallData;
    private final IUnpacker unpacker;
    private final Housekeeper housekeeper;
    private final Log log;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, GUIInstallData installData, RulesEngine rules, IconsDatabase icons, PanelManager panelManager, UninstallDataWriter uninstallDataWriter, ResourceManager resourceManager, UninstallData uninstallData, IUnpacker unpacker, Housekeeper housekeeper, Log log) throws Exception {
        super(title);
        this.installdata = installData;
        this.rules = rules;
        this.resourceManager = resourceManager;
        this.uninstallDataWriter = uninstallDataWriter;
        this.uninstallData = uninstallData;
        this.panelManager = panelManager;
        this.unpacker = unpacker;
        this.variables = installData.getVariables();
        this.housekeeper = housekeeper;
        this.log = log;
        this.messages = installData.getMessages();
        this.setIcons(icons);
        this.addWindowListener(new WindowHandler(this));
    }

    @Override
    public void sizeFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setPreferredSize(new Dimension(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height));
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void buildGUI() {
        ImageIcon icon;
        this.setDefaultCloseOperation(0);
        ImageIcon jframeIcon = this.resourceManager.getImageIcon("JFrameIcon", "/com/izforge/izpack/img/JFrameIcon.png");
        this.setIconImage(jframeIcon.getImage());
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        glassPane.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.setCurPanelNumber(0);
        IzPanel panel_0 = this.installdata.getPanels().get(0);
        this.panelsContainer.add(panel_0);
        logger.fine("Building GUI. The panel list to display is " + this.installdata.getPanels());
        NavigationHandler navHandler = new NavigationHandler();
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        TitledBorder border = BorderFactory.createTitledBorder(new EtchedLineBorder(), this.messages.get("installer.madewith", new Object[0]) + " ", 0, 0, new Font("Dialog", 0, 10));
        navPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), border));
        this.helpButton = ButtonFactory.createButton(this.messages.get("installer.help", new Object[0]), (Icon)this.getIcons().get("help"), this.installdata.buttonsHColor);
        navPanel.add(this.helpButton);
        this.helpButton.setName(GuiId.BUTTON_HELP.id);
        this.helpButton.addActionListener(new HelpHandler());
        navPanel.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.messages.get("installer.prev", new Object[0]), (Icon)this.getIcons().get("stepback"), this.installdata.buttonsHColor);
        navPanel.add(this.prevButton);
        this.prevButton.addActionListener(navHandler);
        this.prevButton.setName(GuiId.BUTTON_PREV.id);
        this.prevButton.setVisible(false);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.messages.get("installer.next", new Object[0]), (Icon)this.getIcons().get("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.nextButton);
        this.nextButton.setName(GuiId.BUTTON_NEXT.id);
        this.nextButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.messages.get("installer.quit", new Object[0]), (Icon)this.getIcons().get("stop"), this.installdata.buttonsHColor);
        navPanel.add(this.quitButton);
        this.quitButton.setName(GuiId.BUTTON_QUIT.id);
        this.quitButton.addActionListener(navHandler);
        this.contentPane.add((Component)navPanel, "South");
        this.debugger = new Debugger(this.installdata, this.getIcons(), this.rules);
        JPanel debugpanel = this.debugger.getDebugPanel();
        if (Debug.isTRACE()) {
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow") && Boolean.valueOf(this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                JFrame debugframe = new JFrame("Debug information");
                debugframe.setContentPane(debugpanel);
                debugframe.setSize(new Dimension(400, 400));
                debugframe.setVisible(true);
            } else {
                debugpanel.setPreferredSize(new Dimension(200, 400));
                this.contentPane.add((Component)debugpanel, "East");
            }
        }
        if ((icon = this.loadIcon(ICON_RESOURCE, "0")) != null) {
            JPanel imgPanel = new JPanel();
            imgPanel.setLayout(new BorderLayout());
            imgPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            this.iconLabel = new JLabel(icon);
            this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            imgPanel.add((Component)this.iconLabel, "North");
            this.contentPane.add((Component)imgPanel, "West");
            this.loadAndShowImageForPanelNum(this.iconLabel, 0);
        }
        this.getRootPane().setDefaultButton(this.nextButton);
        this.callGUIListener(0, navPanel);
        this.createHeading(navPanel);
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, JPanel param) {
        for (GUIListener aGuiListener : this.guiListener) {
            aGuiListener.guiActionPerformed(what, param);
        }
    }

    private ImageIcon loadIcon(String resPrefix, String panelid) {
        ImageIcon icon = null;
        String ext = this.getIconResourceNameExtension();
        try {
            icon = this.resourceManager.getImageIcon(resPrefix, resPrefix + "." + panelid + ext);
        }
        catch (ResourceNotFoundException exception) {
            logger.fine("No icon for panel=" + panelid + ": " + exception.getMessage());
        }
        return icon;
    }

    private String getIconResourceNameExtension() {
        try {
            String iconext = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (iconext == null) {
                iconext = "";
            } else if (iconext.length() > 0 && iconext.charAt(0) != '.') {
                iconext = "." + iconext;
            }
            iconext = iconext.trim();
            return iconext;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void loadAndShowImageForPanelNum(JLabel jLabel, int panelNo) {
        this.loadAndShowImage(jLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImageForPanelOrId(JLabel jLabel, int panelNo, String panelId) {
        this.loadAndShowImage(jLabel, ICON_RESOURCE, panelNo, panelId);
    }

    private void loadAndShowImage(JLabel jLabel, String resPrefix, int panelNo, String panelId) {
        ImageIcon icon = this.loadIcon(resPrefix, panelId);
        if (icon != null) {
            icon = this.loadIcon(resPrefix, panelNo + "");
        }
        jLabel.setVisible(false);
        jLabel.setIcon(icon);
        jLabel.setVisible(true);
    }

    private void loadAndShowImage(JLabel jLabel, String resPrefix, int panelNo) {
        ImageIcon icon = this.loadIcon(resPrefix, panelNo + "");
        if (icon == null) {
            icon = this.loadIcon(resPrefix, panelNo + "");
        }
        if (icon != null) {
            jLabel.setVisible(false);
            jLabel.setIcon(icon);
            jLabel.setVisible(true);
        }
    }

    public void switchPanel(int oldIndex) {
        logger.fine("Switching panel, old index is " + oldIndex);
        try {
            this.installdata.refreshVariables();
        }
        catch (Exception e) {
            logger.fine("Refreshing dynamic variables failed, asking user whether to proceed.");
            StringBuilder msg = new StringBuilder();
            msg.append("<html>");
            msg.append("The following error occured during refreshing panel contents:<br>");
            msg.append("<i>").append(e.getMessage()).append("</i><br>");
            msg.append("Are you sure you want to continue with this installation?");
            msg.append("</html>");
            JLabel label = new JLabel(msg.toString());
            label.setFont(new Font("Sans Serif", 0, 12));
            Object[] optionValues = new Object[]{"Continue", "Exit"};
            int selectedOption = JOptionPane.showOptionDialog(null, label, "Warning", 0, 2, null, optionValues, optionValues[1]);
            logger.fine("Selected option: " + selectedOption);
            if (selectedOption == 0) {
                logger.fine("Continuing installation");
            }
            logger.fine("Exiting");
            System.exit(1);
        }
        try {
            if (this.installdata.getCurPanelNumber() < oldIndex) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel newPanel = this.installdata.getPanels().get(this.installdata.getCurPanelNumber());
            IzPanel oldPanel = this.installdata.getPanels().get(oldIndex);
            this.showHelpButton(newPanel.canShowHelp());
            if (Debug.isTRACE()) {
                this.debugger.switchPanel(newPanel.getMetadata(), oldPanel.getMetadata());
            }
            this.log.addDebugMessage("InstallerFrame.switchPanel: try switching newPanel from {0} to {1} ({2} to {3})", new String[]{oldPanel.getClass().getName(), newPanel.getClass().getName(), Integer.toString(oldIndex), Integer.toString(this.installdata.getCurPanelNumber())}, "PanelTrace", null);
            this.configureButtonVisibility();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JButton cdb = null;
                    String buttonName = "next";
                    if (InstallerFrame.this.nextButton.isEnabled()) {
                        cdb = InstallerFrame.this.nextButton;
                        InstallerFrame.this.quitButton.setDefaultCapable(false);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(true);
                    } else if (InstallerFrame.this.quitButton.isEnabled()) {
                        cdb = InstallerFrame.this.quitButton;
                        buttonName = "quit";
                        InstallerFrame.this.quitButton.setDefaultCapable(true);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(false);
                    }
                    InstallerFrame.this.getRootPane().setDefaultButton(cdb);
                    InstallerFrame.this.log.addDebugMessage("InstallerFrame.switchPanel: setting {0} as default button", new String[]{buttonName}, "PanelTrace", null);
                }
            });
            this.panelsContainer.remove(oldPanel);
            oldPanel.panelDeactivate();
            this.panelsContainer.add(newPanel);
            if (newPanel.getInitialFocus() != null) {
                JTextComponent inText;
                final Component inFoc = newPanel.getInitialFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        inFoc.requestFocusInWindow();
                    }
                });
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.performHeading(newPanel);
            this.performHeadingCounter();
            newPanel.executePreActivationActions();
            newPanel.panelActivate();
            this.panelsContainer.setVisible(true);
            Panel metadata = newPanel.getMetadata();
            if (this.iconLabel != null) {
                if (metadata != null && !"UNKNOWN".equals(metadata.getPanelid())) {
                    this.loadAndShowImageForPanelOrId(this.iconLabel, this.getCurrentPanelVisbilityNumber(), metadata.getPanelid());
                } else {
                    this.loadAndShowImageForPanelNum(this.iconLabel, this.getCurrentPanelVisbilityNumber());
                }
            }
            this.isBack = false;
            this.callGUIListener(3);
            this.log.addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error when switching panel", e);
        }
    }

    private int getCurrentPanelVisbilityNumber() {
        return this.panelManager.getPanelVisibilityNumber(this.installdata.getCurPanelNumber());
    }

    private void configureButtonVisibility() {
        if (this.panelManager.isLast(this.installdata.getCurPanelNumber())) {
            this.prevButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.lockNextButton();
        } else {
            if (this.hasNavigatePrevious(this.installdata.getCurPanelNumber(), true) != -1) {
                this.prevButton.setVisible(true);
                this.unlockPrevButton();
            } else {
                this.lockPrevButton();
                this.prevButton.setVisible(false);
            }
            if (this.hasNavigateNext(this.installdata.getCurPanelNumber(), true) != -1) {
                this.nextButton.setVisible(true);
                this.unlockNextButton();
            } else {
                this.lockNextButton();
                this.nextButton.setVisible(false);
            }
        }
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void exit() {
        if (!(!this.installdata.isCanClose() && (this.nextButton.isVisible() && this.nextButton.isEnabled() || this.prevButton.isVisible() && this.prevButton.isEnabled()))) {
            if (!this.writeUninstallData()) {
                // empty if block
            }
            this.shutdown();
        } else {
            this.confirmExit();
        }
    }

    protected void wipeAborted() {
        if (!this.unpacker.interrupt(40000L)) {
            return;
        }
        for (String installedFile : this.uninstallData.getInstalledFilesList()) {
            File file = new File(installedFile);
            file.delete();
        }
    }

    public void install(AbstractUIProgressHandler listener) {
        this.unpacker.setHandler(listener);
        Thread unpackerthread = new Thread((Runnable)this.unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
    }

    public void writeXMLTree(IXMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.getPanels().size(); ++i) {
            IzPanel panel = this.installdata.getPanels().get(i);
            panel.makeXMLData(this.installdata.getXmlData().getChildAtIndex(i));
        }
        writer.write(root);
    }

    public void setQuitButtonText(String text) {
        String text1 = text;
        if (text1 == null) {
            text1 = this.messages.get("installer.quit", new Object[0]);
        }
        this.quitButton.setText(text1);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.quitButton.setIcon((Icon)this.getIcons().get(iconName));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    @Override
    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    @Override
    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    @Override
    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    @Override
    public void unlockNextButton() {
        this.unlockNextButton(true);
    }

    @Override
    public void unlockNextButton(boolean requestFocus) {
        this.nextButton.setEnabled(true);
        if (requestFocus) {
            this.nextButton.requestFocusInWindow();
            this.getRootPane().setDefaultButton(this.nextButton);
            if (this.getFocusOwner() != null) {
                logger.fine("Current focus owner: " + this.getFocusOwner().getName());
            }
            if (this.getRootPane().getDefaultButton() != this.nextButton) {
                logger.fine("Next button not default button, setting...");
                this.quitButton.setDefaultCapable(false);
                this.prevButton.setDefaultCapable(false);
                this.nextButton.setDefaultCapable(true);
                this.getRootPane().setDefaultButton(this.nextButton);
            }
        }
    }

    public void skipPanel() {
        if (this.installdata.getCurPanelNumber() < this.installdata.getPanels().size() - 1) {
            if (this.isBack) {
                this.navigatePrevious(this.installdata.getCurPanelNumber());
            } else {
                this.navigateNext(this.installdata.getCurPanelNumber(), false);
            }
        }
    }

    public boolean canShow(int panelnumber) {
        IzPanel panel = this.installdata.getPanels().get(panelnumber);
        Panel panelmetadata = panel.getMetadata();
        String panelid = panelmetadata.getPanelid();
        logger.fine("Current Panel: " + panelid);
        this.refreshDynamicVariables();
        if (!panelmetadata.hasCondition()) {
            if (!this.rules.canShowPanel(panelid, this.installdata.getVariables())) {
                logger.fine("Can't show panel " + panelid);
                return false;
            }
            return true;
        }
        boolean canShow = this.rules.isConditionTrue(panelmetadata.getCondition());
        logger.fine("Skipping panel " + panelid + " due to unmet condition " + panelmetadata.getCondition());
        return canShow;
    }

    @Override
    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.navigateNext(this.installdata.getCurPanelNumber(), true);
    }

    public void navigateNext(int startPanel, boolean doValidation) {
        logger.fine("Navigate to next panel. Start panel is " + startPanel);
        if (this.installdata.getCurPanelNumber() < this.installdata.getPanels().size() - 1) {
            IzPanel panel = this.installdata.getPanels().get(startPanel);
            panel.executePreValidationActions();
            boolean isValid = !doValidation || panel.panelValidated();
            panel.executePostValidationActions();
            if (!this.nextButton.isEnabled()) {
                return;
            }
            if (!isValid) {
                return;
            }
            int nextPanel = this.hasNavigateNext(startPanel, false);
            if (-1 != nextPanel) {
                this.installdata.setCurPanelNumber(nextPanel);
                this.switchPanel(startPanel);
            }
        }
    }

    public int hasNavigateNext(int startPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = startPanel + 1; res == -1 && panel < this.installdata.getPanels().size(); ++panel) {
            if (visibleOnly && !this.panelManager.isVisible(panel) || !this.canShow(panel)) continue;
            res = panel;
        }
        logger.fine("The next panel of " + startPanel + " is panel number " + res);
        return res;
    }

    public int hasNavigatePrevious(int endingPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = endingPanel - 1; res == -1 && panel >= 0; --panel) {
            if (visibleOnly && !this.panelManager.isVisible(panel) || !this.canShow(panel)) continue;
            res = panel;
        }
        return res;
    }

    @Override
    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.getCurPanelNumber());
    }

    public void navigatePrevious(int endingPanel) {
        int prevPanel = this.hasNavigatePrevious(endingPanel, false);
        if (-1 != prevPanel) {
            this.installdata.setCurPanelNumber(prevPanel);
            this.switchPanel(endingPanel);
        }
    }

    @Override
    public void showHelp() {
        IzPanel izPanel = this.installdata.getPanels().get(this.installdata.getCurPanelNumber());
        izPanel.showHelp();
    }

    public Messages getMessages() {
        return this.messages;
    }

    @Deprecated
    public LocaleDatabase getLangpack() {
        return (LocaleDatabase)this.messages;
    }

    @Deprecated
    public void setLangpack(LocaleDatabase langpack) {
    }

    public IconsDatabase getIcons() {
        return this.icons;
    }

    public void setIcons(IconsDatabase icons) {
        this.icons = icons;
    }

    public List<GUIListener> getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            Color foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(foreground);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat(this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        if (this.imageLeft) {
            this.headingLabels[0].setAlignmentX(1.0f);
        }
        for (int i = 1; i < headingLines; ++i) {
            this.headingLabels[i] = new JLabel();
            if (this.imageLeft) {
                this.headingLabels[i].setAlignmentX(1.0f);
                continue;
            }
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 8));
        }
    }

    private void createHeadingCounter(JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                }
            } else if ("text".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                } else {
                    this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                }
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    Color foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    headingCountPanels.setForeground(foreground);
                }
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i;
                Component[] comps = navPanel.getComponents();
                for (i = 0; i < comps.length && !comps[i].equals(this.prevButton); ++i) {
                }
                if (i <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i);
                    navPanel.add((Component)this.headingCounterComponent, i);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon;
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        int borderSize = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            borderSize = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        imgPanel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        if ((icon = this.loadIcon(HEADING_ICON_RESOURCE, "0")) != null) {
            JLabel iconLab = new JLabel(icon);
            if (this.imageLeft) {
                imgPanel.add((Component)iconLab, "West");
            } else {
                imgPanel.add((Component)iconLab, "East");
            }
            this.headingLabels[this.headingLabels.length - 1] = iconLab;
        }
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            back = Color.decode(this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(navPanel, null);
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageOnLeft") && (this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("yes") || this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("true"))) {
            this.imageLeft = true;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        if (this.imageLeft) {
            leftHeadingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        for (int i = 0; i < headingLines; ++i) {
            leftHeadingPanel.add(this.headingLabels[i]);
        }
        this.createHeadingCounter(navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        if (this.imageLeft) {
            northPanel.add(imgPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(leftHeadingPanel);
        } else {
            northPanel.add(leftHeadingPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(imgPanel);
        }
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !this.installdata.guiPrefs.modifier.get("useHeadingPanel").equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return caller.getI18nStringForClass("headline", null) != null;
    }

    private void performHeading(IzPanel panel) {
        int i;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        String headline = panel.getI18nStringForClass("headline");
        if (headline == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (i = 0; i <= headingLines; ++i) {
            if (this.headingLabels[i] == null) continue;
            this.headingLabels[i].setVisible(false);
        }
        for (i = 0; i < headingLines - 1; ++i) {
            String info = panel.getI18nStringForClass("headinfo" + Integer.toString(i));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i + 1].setText(info);
            this.headingLabels[i + 1].setVisible(true);
        }
        this.headingLabels[0].setText(headline);
        this.headingLabels[0].setVisible(true);
        int curPanelNo = this.getCurrentPanelVisbilityNumber();
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    public void performHeadingCounter() {
        if (this.headingCounterComponent != null) {
            int curPanelNo = this.panelManager.getPanelVisibilityNumber(this.installdata.getCurPanelNumber());
            int visPanelsCount = this.panelManager.getCountVisiblePanel();
            String message = String.format("%s %d %s %d", this.messages.get("installer.step", new Object[0]), curPanelNo + 1, this.messages.get("installer.of", new Object[0]), visPanelsCount + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                this.updateProgressBar(visPanelsCount + 1, curPanelNo + 1, message);
            } else {
                this.updateProgressCounter(message);
            }
        }
    }

    public void updateProgressCounter(String message) {
        ((JLabel)this.headingCounterComponent).setText(message);
    }

    public void updateProgressBar(int maximum, int value, String message) {
        JProgressBar counterComponent = (JProgressBar)this.headingCounterComponent;
        counterComponent.setMaximum(maximum);
        counterComponent.setValue(value);
        counterComponent.setString(message);
    }

    private void showHelpButton(boolean show) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(show);
    }

    public void refreshDynamicVariables() {
        try {
            this.installdata.refreshVariables();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error when refreshing variable", e);
            logger.fine("Refreshing dynamic variables failed, asking user whether to proceed.");
            StringBuilder msg = new StringBuilder();
            msg.append("<html>");
            msg.append("The following error occured during refreshing panel contents:<br>");
            msg.append("<i>" + e.getMessage() + "</i><br>");
            msg.append("Are you sure you want to continue with this installation?");
            msg.append("</html>");
            JLabel label = new JLabel(msg.toString());
            label.setFont(new Font("Sans Serif", 0, 12));
            Object[] optionValues = new Object[]{"Continue", "Exit"};
            int selectedOption = JOptionPane.showOptionDialog(null, label, "Warning", 0, 2, null, optionValues, optionValues[1]);
            logger.fine("Selected option: " + selectedOption);
            if (selectedOption == 0) {
                logger.fine("Continuing installation");
            }
            logger.fine("Exiting");
            System.exit(1);
        }
    }

    private boolean writeUninstallData() {
        boolean result = true;
        if (this.uninstallDataWriter.isUninstallRequired() && !(result = this.uninstallDataWriter.write())) {
            String title = this.messages.get("installer.error", new Object[0]);
            String message = this.messages.get("installer.uninstall.writefailed", new Object[0]);
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
        return result;
    }

    private void shutdown() {
        boolean reboot = false;
        if (this.installdata.isRebootNecessary()) {
            System.out.println("[ There are file operations pending after reboot ]");
            switch (this.installdata.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                    break;
                }
                case 2: {
                    String message = this.variables.replace(this.messages.get("installer.reboot.ask.message", new Object[0]));
                    String title = this.variables.replace(this.messages.get("installer.reboot.ask.title", new Object[0]));
                    int res = JOptionPane.showConfirmDialog(this, message, title, 0);
                    if (res != 0) break;
                    reboot = true;
                    break;
                }
                case 1: {
                    String message = this.variables.replace(this.messages.get("installer.reboot.notice.message", new Object[0]));
                    String title = this.variables.replace(this.messages.get("installer.reboot.notice.title", new Object[0]));
                    JOptionPane.showConfirmDialog(this, message, title, 0);
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(0, reboot);
    }

    private void confirmExit() {
        int res;
        if (this.unpacker.isInterruptDisabled() && this.interruptCount < 3) {
            ++this.interruptCount;
            return;
        }
        String mkey = "installer.quit.reversemessage";
        String tkey = "installer.quit.reversetitle";
        String message = this.messages.get("installer.quit.reversemessage", new Object[0]);
        String title = this.messages.get("installer.quit.reversetitle", new Object[0]);
        if (message.contains("installer.quit.reversemessage")) {
            message = this.messages.get("installer.quit.message", new Object[0]);
        }
        if (title.contains("installer.quit.reversetitle")) {
            title = this.messages.get("installer.quit.title", new Object[0]);
        }
        if ((res = JOptionPane.showConfirmDialog(this, message = this.variables.replace(message), title = this.variables.replace(title), 0)) == 0) {
            this.wipeAborted();
            this.housekeeper.shutDown(0);
        }
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        @Override
        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class HelpHandler
    implements ActionListener {
        HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallerFrame.this.showHelp();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstallerFrame.this.blockGUI();
                            NavigationHandler.this.navigate(e);
                            InstallerFrame.this.releaseGUI();
                        }
                    });
                }
            }).start();
        }

        private void navigate(ActionEvent e) {
            Object source = e.getSource();
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (source == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

