/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class LanguageDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3256443616359887667L;
    private static final transient Logger logger = Logger.getLogger(LanguageDialog.class.getName());
    private JComboBox comboBox;
    private Map<String, String> isoTable;
    private GUIInstallData installData;
    private static final String[] LANGUAGE_DISPLAY_TYPES = new String[]{"iso3", "native", "default"};
    private JFrame frame;
    private RequirementsChecker requirements;
    private final Resources resources;
    private final Locales locales;

    public LanguageDialog(JFrame frame, Resources resources, Locales locales, GUIInstallData installDataGUI, RequirementsChecker requirements) throws Exception {
        super(frame);
        this.frame = frame;
        this.resources = resources;
        this.locales = locales;
        this.installData = installDataGUI;
        this.requirements = requirements;
        this.setName(GuiId.DIALOG_PICKER.id);
        this.initLanguageDialog();
    }

    private void initLanguageDialog() {
        this.addWindowListener(new WindowHandler());
        JPanel contentPane = (JPanel)this.getContentPane();
        this.setTitle("Language Selection");
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.ipadx = 0;
        gbConstraints.ipady = 6;
        ImageIcon img = this.getImage();
        JLabel imgLabel = new JLabel(img);
        gbConstraints.gridy = 0;
        contentPane.add(imgLabel);
        String firstMessage = "Please select your language";
        if (this.getLangType().equals(LANGUAGE_DISPLAY_TYPES[0])) {
            firstMessage = "Please select your language below";
        }
        JLabel label1 = new JLabel(firstMessage, 10);
        gbConstraints.gridy = 1;
        gbConstraints.insets = new Insets(15, 5, 5, 5);
        layout.addLayoutComponent(label1, gbConstraints);
        contentPane.add(label1);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        Object[] langPacks = this.reviseItems(this.locales.getLocales());
        this.comboBox = new JComboBox<Object>(langPacks);
        this.comboBox.setName(GuiId.COMBO_BOX_LANG_FLAG.id);
        if (this.useFlags()) {
            this.comboBox.setRenderer(new FlagRenderer(this.resources));
        }
        gbConstraints.gridy = 3;
        layout.addLayoutComponent(this.comboBox, gbConstraints);
        contentPane.add(this.comboBox);
        gbConstraints.insets = new Insets(15, 5, 15, 5);
        JButton okButton = new JButton("OK");
        okButton.setName(GuiId.BUTTON_LANG_OK.id);
        okButton.addActionListener(this);
        gbConstraints.fill = 0;
        gbConstraints.gridy = 4;
        gbConstraints.anchor = 10;
        layout.addLayoutComponent(okButton, gbConstraints);
        contentPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (System.getProperty("mrj.version") == null) {
            this.pack();
        }
        this.setSize(this.getPreferredSize());
        Dimension frameSize = this.getSize();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
        this.setResizable(true);
        this.setSelection(Locale.getDefault().getISO3Language().toLowerCase());
        this.setModal(true);
        this.toFront();
    }

    private Object[] reviseItems(List<Locale> locales) {
        Object[] result;
        String langType = this.getLangType();
        if (langType.equals(LANGUAGE_DISPLAY_TYPES[0])) {
            result = new Object[locales.size()];
            for (int i = 0; i < locales.size(); ++i) {
                result[i] = locales.get(i).getISO3Language();
            }
        } else {
            result = langType.equals(LANGUAGE_DISPLAY_TYPES[1]) ? this.expandItems(locales, new JComboBox().getFont()) : this.expandItems(locales, null);
        }
        return result;
    }

    private String[] expandItems(List<Locale> locales, Font testFont) {
        String[] result = new String[locales.size()];
        for (int i = 0; i < locales.size(); ++i) {
            String it;
            Locale locale = locales.get(i);
            result[i] = it = this.expandItem(locale, testFont);
        }
        return result;
    }

    private String expandItem(Locale locale, Font testFont) {
        if (testFont == null) {
            return locale.getDisplayLanguage();
        }
        String str = locale.getDisplayLanguage(locale);
        int cdut = testFont.canDisplayUpTo(str);
        if (cdut > -1) {
            str = locale.getDisplayLanguage();
        }
        return str;
    }

    public ImageIcon getImage() {
        ImageIcon img;
        try {
            img = this.resources.getImageIcon("installer.langsel.img", new String[0]);
        }
        catch (Exception err) {
            img = null;
        }
        return img;
    }

    public Object getSelection() {
        Object retval = null;
        if (this.isoTable != null) {
            retval = this.isoTable.get((String)this.comboBox.getSelectedItem());
        }
        return retval != null ? retval : this.comboBox.getSelectedItem();
    }

    public void setSelection(Object item) {
        Object mapped = null;
        if (this.isoTable != null) {
            for (String key : this.isoTable.keySet()) {
                if (!this.isoTable.get(key).equals(item)) continue;
                mapped = key;
                break;
            }
        }
        if (mapped == null) {
            mapped = item;
        }
        this.comboBox.setSelectedItem(mapped);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedPack = (String)this.getSelection();
        if (selectedPack == null) {
            throw new RuntimeException("installation canceled");
        }
        try {
            this.propagateLocale(selectedPack);
            this.installData.configureGuiButtons();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.dispose();
    }

    public void runPicker() {
        this.frame.setVisible(false);
        this.setVisible(true);
    }

    protected String getLangType() {
        if (this.installData.guiPrefs.modifier.containsKey("langDisplayType")) {
            String val = this.installData.guiPrefs.modifier.get("langDisplayType");
            val = val.toLowerCase();
            for (String aLANGUAGE_DISPLAY_TYPES : LANGUAGE_DISPLAY_TYPES) {
                if (!val.equalsIgnoreCase(aLANGUAGE_DISPLAY_TYPES)) continue;
                return val;
            }
            logger.fine("Value for language display type not valid; value: " + val);
        }
        return LANGUAGE_DISPLAY_TYPES[0];
    }

    protected boolean useFlags() {
        return !this.installData.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase(this.installData.guiPrefs.modifier.get("useFlags"));
    }

    public void initLangPack() throws Exception {
        if (this.locales.getLocales().size() > 1) {
            this.runPicker();
        }
        this.installData.refreshVariables();
        if (!this.requirements.check()) {
            logger.info("Not all installer requirements are fulfilled.");
            System.exit(-1);
        }
    }

    private void propagateLocale(String code) {
        Locale locale = this.locales.getLocale(code);
        this.locales.setLocale(locale);
        this.installData.setLocale(locale);
        this.installData.setMessages(this.locales.getMessages());
    }

    private class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3832899961942782769L;
        private TreeMap<String, ImageIcon> icons = new TreeMap();
        private TreeMap<String, ImageIcon> grayIcons = new TreeMap();
        private Resources resources;

        public FlagRenderer(Resources resources) {
            this.resources = resources;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iso3 = (String)value;
            this.setText(iso3);
            if (LanguageDialog.this.isoTable != null) {
                iso3 = (String)LanguageDialog.this.isoTable.get(iso3);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (!this.icons.containsKey(iso3)) {
                ImageIcon icon = this.resources.getImageIcon("flag." + iso3, new String[0]);
                this.icons.put(iso3, icon);
                icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                this.grayIcons.put(iso3, icon);
            }
            if (isSelected || index == -1) {
                this.setIcon(this.icons.get(iso3));
            } else {
                this.setIcon(this.grayIcons.get(iso3));
            }
            return this;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

