/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.os.FileQueue;
import com.izforge.izpack.util.os.FileQueueMove;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public abstract class FileUnpacker {
    private final Cancellable cancellable;
    private final AbstractUIProgressHandler handler;
    private final Platform platform;
    private final Librarian librarian;
    private File target;
    private File tmpTarget;
    private FileQueue queue;
    private boolean queued;
    private static final Logger logger = Logger.getLogger(FileUnpacker.class.getName());

    public FileUnpacker(Cancellable cancellable, AbstractUIProgressHandler handler, FileQueue queue, Platform platform, Librarian librarian) {
        this.cancellable = cancellable;
        this.handler = handler;
        this.queue = queue;
        this.librarian = librarian;
        this.platform = platform;
    }

    public abstract FileQueue unpack(PackFile var1, ObjectInputStream var2, File var3) throws IOException, InstallerException;

    public boolean isQueued() {
        return this.queued;
    }

    protected FileQueue getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileQueue copy(PackFile file, InputStream in, File target) throws IOException {
        OutputStream out = this.getTarget(file, target);
        try {
            byte[] buffer = new byte[5120];
            long bytesCopied = 0L;
            while (bytesCopied < file.length()) {
                if (this.cancellable.isCancelled()) {
                    FileQueue fileQueue = this.queue;
                    return fileQueue;
                }
                bytesCopied = this.copy(file, buffer, in, out, bytesCopied);
            }
        }
        finally {
            FileUtils.close(out);
        }
        return this.postCopy(file);
    }

    protected FileQueue postCopy(PackFile file) throws IOException {
        this.setLastModified(file);
        if (this.isBlockable(file)) {
            this.queue();
        }
        return this.getQueue();
    }

    protected long copy(PackFile file, byte[] buffer, InputStream in, OutputStream out, long bytesCopied) throws IOException {
        int maxBytes = (int)Math.min(file.length() - bytesCopied, (long)buffer.length);
        int read = this.read(buffer, in, maxBytes);
        if (read == -1) {
            throw new IOException("Unexpected end of stream (installer corrupted?)");
        }
        out.write(buffer, 0, read);
        return bytesCopied += (long)read;
    }

    protected int read(byte[] buffer, InputStream in, int maxBytes) throws IOException {
        return in.read(buffer, 0, maxBytes);
    }

    protected AbstractUIProgressHandler getHandler() {
        return this.handler;
    }

    protected OutputStream getTarget(PackFile file, File target) throws IOException {
        FileOutputStream result;
        this.target = target;
        if (this.isBlockable(file)) {
            this.tmpTarget = File.createTempFile("__FQ__", null, target.getParentFile());
            result = new FileOutputStream(this.tmpTarget);
        } else {
            result = new FileOutputStream(target);
        }
        return result;
    }

    protected void setLastModified(PackFile file) {
        if (file.lastModified() >= 0L) {
            File f;
            File file2 = f = this.tmpTarget != null ? this.tmpTarget : this.target;
            if (!f.setLastModified(file.lastModified())) {
                logger.warning("Failed to set last modified timestamp for: " + this.target);
            }
        }
    }

    private boolean isBlockable(PackFile file) {
        return file.blockable() != Blockable.BLOCKABLE_NONE && this.platform.isA(Platform.Name.WINDOWS);
    }

    private void queue() throws IOException {
        if (this.queue == null) {
            this.queue = new FileQueue(this.librarian);
        }
        FileQueueMove move = new FileQueueMove(this.tmpTarget, this.target);
        move.setForceInUse(true);
        move.setOverwrite(true);
        this.queue.add(move);
        logger.fine(this.tmpTarget.getAbsolutePath() + " -> " + this.target.getAbsolutePath() + " added to file queue for being copied after reboot");
        this.tmpTarget.deleteOnExit();
        this.queued = true;
    }
}

