/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.console.PanelConsoleHelper;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.util.Console;
import java.io.PrintWriter;
import java.util.Properties;

public class TargetPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private final Resources resources;

    public TargetPanelConsoleHelper(Resources resources) {
        this.resources = resources;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean runConsoleFromProperties(AutomatedInstallData installData, Properties properties) {
        String strTargetPath = properties.getProperty("INSTALL_PATH");
        if (strTargetPath == null || "".equals(strTargetPath.trim())) {
            System.err.println("Missing mandatory target path!");
            return false;
        }
        strTargetPath = installData.getVariables().replace(strTargetPath);
        installData.setInstallPath(strTargetPath);
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData, Console console) {
        String strDefaultPath = PathInputPanel.loadDefaultInstallDir(this.resources, installData);
        String strTargetPath = console.prompt("Select target path [" + strDefaultPath + "] ", null);
        if (strTargetPath != null) {
            if ((strTargetPath = strTargetPath.trim()).isEmpty()) {
                strTargetPath = strDefaultPath;
            }
            strTargetPath = installData.getVariables().replace(strTargetPath);
            installData.setInstallPath(strTargetPath);
            return this.promptEndPanel(installData, console);
        }
        return false;
    }
}

