/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.automation.PanelAutomation;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final Logger logger = Logger.getLogger(UserInputPanelAutomationHelper.class.getName());
    private static final String AUTO_KEY_USER_INPUT = "userInput";
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private Map<String, String> entries;

    public UserInputPanelAutomationHelper() {
        this.entries = null;
    }

    public UserInputPanelAutomationHelper(Map<String, String> entries) {
        this.entries = entries;
    }

    @Override
    public void makeXMLData(AutomatedInstallData idata, IXMLElement panelRoot) {
        XMLElementImpl userInput = new XMLElementImpl(AUTO_KEY_USER_INPUT, panelRoot);
        panelRoot.addChild(userInput);
        for (String key : this.entries.keySet()) {
            String value = this.entries.get(key);
            XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_ENTRY, userInput);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            userInput.addChild(dataElement);
        }
    }

    @Override
    public void runAutomated(AutomatedInstallData idata, IXMLElement panelRoot) throws InstallerException {
        IXMLElement userInput = panelRoot.getFirstChildNamed(AUTO_KEY_USER_INPUT);
        if (userInput == null) {
            throw new InstallerException("Missing userInput element on line " + panelRoot.getLineNr());
        }
        List<IXMLElement> userEntries = userInput.getChildrenNamed(AUTO_KEY_ENTRY);
        if (userEntries == null) {
            throw new InstallerException("Missing entry element(s) on line " + panelRoot.getLineNr());
        }
        Variables variables = idata.getVariables();
        for (IXMLElement dataElement : userEntries) {
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            value = variables.replace(value);
            logger.fine("Setting variable " + variable + " to " + value);
            idata.setVariable(variable, value);
        }
    }
}

