/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.console.PanelConsoleHelper;
import com.izforge.izpack.panels.userinput.processor.Processor;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserInputPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final Logger logger = Logger.getLogger(UserInputPanelConsoleHelper.class.getName());
    protected int instanceNumber = instanceCount++;
    private static int instanceCount = 0;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String NODE_ID = "panel";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String FIELD_NODE_ID = "field";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    private static final String VARIABLE = "variable";
    private static final String SET = "set";
    private static final String TEXT = "txt";
    private static final String SPEC = "spec";
    private static final String PWD = "pwd";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TEXT_FIELD = "text";
    private static final String COMBO_FIELD = "combo";
    private static final String STATIC_TEXT = "staticText";
    private static final String CHOICE = "choice";
    private static final String DIR = "dir";
    private static final String FILE = "file";
    private static final String PASSWORD = "password";
    private static final String VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String TITLE_FIELD = "title";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String SPACE = "space";
    private static final String DIVIDER = "divider";
    static final String DISPLAY_FORMAT = "displayFormat";
    static final String PLAIN_STRING = "plainString";
    static final String SPECIAL_SEPARATOR = "specialSeparator";
    static final String LAYOUT = "layout";
    static final String RESULT_FORMAT = "resultFormat";
    private static final String DESCRIPTION = "description";
    private static final String TRUE = "true";
    private static final String NAME = "name";
    private static final String FAMILY = "family";
    private static final String OS = "os";
    private static final String SELECTEDPACKS = "createForPack";
    private static Input SPACE_INTPUT_FIELD = new Input("space", null, null, "space", "\r", 0);
    private static Input DIVIDER_INPUT_FIELD = new Input("divider", null, null, "divider", "------------------------------------------", 0);
    public List<Input> listInputs = new ArrayList<Input>();
    private final Resources resources;

    public UserInputPanelConsoleHelper(Resources resources) {
        this.resources = resources;
    }

    @Override
    public boolean runConsoleFromProperties(AutomatedInstallData installData, Properties properties) {
        this.collectInputs(installData);
        for (Input listInput : this.listInputs) {
            String strVariableValue;
            String strVariableName = listInput.strVariableName;
            if (strVariableName == null || (strVariableValue = properties.getProperty(strVariableName)) == null) continue;
            installData.setVariable(strVariableName, strVariableValue);
        }
        return true;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        this.collectInputs(installData);
        for (Input input : this.listInputs) {
            if (input.strVariableName == null) continue;
            printWriter.println(input.strVariableName + "=");
        }
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData, Console console) {
        boolean processpanel = this.collectInputs(installData);
        if (!processpanel) {
            return true;
        }
        boolean status = true;
        for (Input field : this.listInputs) {
            if (TEXT_FIELD.equals(field.strFieldType) || FILE.equals(field.strFieldType) || RULE_FIELD.equals(field.strFieldType) || DIR.equals(field.strFieldType)) {
                status = status && this.processTextField(field, installData);
                continue;
            }
            if (COMBO_FIELD.equals(field.strFieldType) || RADIO_FIELD.equals(field.strFieldType)) {
                status = status && this.processComboRadioField(field, installData);
                continue;
            }
            if (CHECK_FIELD.equals(field.strFieldType)) {
                status = status && this.processCheckField(field, installData);
                continue;
            }
            if (STATIC_TEXT.equals(field.strFieldType) || TITLE_FIELD.equals(field.strFieldType) || DIVIDER.equals(field.strFieldType) || SPACE.equals(field.strFieldType)) {
                status = status && this.processSimpleField(field, installData);
                continue;
            }
            if (!PASSWORD.equals(field.strFieldType)) continue;
            status = status && this.processPasswordField(field, installData);
        }
        return this.promptEndPanel(installData, console);
    }

    public boolean collectInputs(AutomatedInstallData installData) {
        this.listInputs.clear();
        IXMLElement spec = null;
        String panelid = installData.getPanelsOrder().get(installData.getCurPanelNumber()).getPanelid();
        String instance = Integer.toString(this.instanceNumber);
        SpecHelper specHelper = new SpecHelper(this.resources);
        try {
            specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        List<IXMLElement> specElements = specHelper.getSpec().getChildrenNamed(NODE_ID);
        for (IXMLElement data : specElements) {
            String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
            String dataID = data.getAttribute(PANEL_IDENTIFIER);
            if ((attribute == null || !instance.equals(attribute)) && (dataID == null || panelid == null || !panelid.equals(dataID))) continue;
            List<IXMLElement> forPacks = data.getChildrenNamed(SELECTEDPACKS);
            List<IXMLElement> forOs = data.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, installData) || !this.itemRequiredForOs(forOs)) continue;
            spec = data;
            break;
        }
        if (spec == null) {
            return false;
        }
        List<IXMLElement> fields = spec.getChildrenNamed(FIELD_NODE_ID);
        for (IXMLElement field : fields) {
            Input in;
            String conditionid;
            List<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
            List<IXMLElement> forOs = field.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, installData) || !this.itemRequiredForOs(forOs) || (conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !installData.getRules().isConditionTrue(conditionid, installData) || (in = this.getInputFromField(field, installData)) == null) continue;
            this.listInputs.add(in);
        }
        return true;
    }

    boolean processSimpleField(Input input, AutomatedInstallData idata) {
        VariableSubstitutorImpl variableSubstitutor = new VariableSubstitutorImpl(idata.getVariables());
        try {
            System.out.println(variableSubstitutor.substitute(input.strText));
        }
        catch (Exception e) {
            System.out.println(input.strText);
        }
        return true;
    }

    boolean processPasswordField(Input input, AutomatedInstallData idata) {
        Password pwd = (Password)input;
        boolean rtn = false;
        for (int i = 0; i < pwd.input.length; ++i) {
            rtn = this.processTextField(pwd.input[i], idata);
            if (rtn) continue;
            return rtn;
        }
        return rtn;
    }

    boolean processTextField(Input input, AutomatedInstallData idata) {
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        if (input.listChoices.size() == 0) {
            logger.warning("No 'spec' element defined in file field");
            return false;
        }
        String set = idata.getVariable(variable);
        if (set == null && (set = input.strDefaultValue) == null) {
            set = "";
        }
        if (!"".equals(set)) {
            VariableSubstitutorImpl vs = new VariableSubstitutorImpl(idata.getVariables());
            try {
                set = vs.substitute(set);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.toString(), e);
            }
        }
        String fieldText = input.listChoices.get((int)0).strText;
        System.out.println(fieldText + " [" + set + "] ");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String strIn = br.readLine();
            if (!strIn.trim().equals("")) {
                idata.setVariable(variable, strIn);
            } else {
                idata.setVariable(variable, set);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    boolean processComboRadioField(Input input, AutomatedInstallData idata) {
        List<Choice> lisChoices;
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        String currentvariablevalue = idata.getVariable(variable);
        input.iSelectedChoice = -1;
        boolean userinput = false;
        if (input.strText != null) {
            System.out.println(input.strText);
        }
        if ((lisChoices = input.listChoices).size() == 0) {
            logger.warning("No 'spec' element defined in file field");
            return false;
        }
        if (currentvariablevalue != null) {
            userinput = true;
        }
        for (int i = 0; i < lisChoices.size(); ++i) {
            Choice choice = lisChoices.get(i);
            String value = choice.strValue;
            if (userinput) {
                if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                    input.iSelectedChoice = i;
                }
            } else {
                String set = choice.strSet;
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutorImpl variableSubstitutor = new VariableSubstitutorImpl(idata.getVariables());
                        set = variableSubstitutor.substitute(set);
                    }
                    if (set.equals(TRUE)) {
                        input.iSelectedChoice = i;
                    }
                }
            }
            System.out.println(i + "  [" + (input.iSelectedChoice == i ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            boolean bKeepAsking = true;
            while (bKeepAsking) {
                System.out.println("input selection:");
                String strIn = reader.readLine();
                if (strIn.trim().equals("") && input.iSelectedChoice != -1) {
                    bKeepAsking = false;
                }
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (j < 0 || j >= lisChoices.size()) continue;
                input.iSelectedChoice = j;
                bKeepAsking = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        idata.setVariable(variable, input.listChoices.get((int)input.iSelectedChoice).strValue);
        return true;
    }

    boolean processCheckField(Input input, AutomatedInstallData idata) {
        List<Choice> lisChoices;
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        String currentvariablevalue = idata.getVariable(variable);
        if (currentvariablevalue == null) {
            currentvariablevalue = "";
        }
        if ((lisChoices = input.listChoices).size() == 0) {
            logger.warning("No 'spec' element defined in check field");
            return false;
        }
        Choice choice = null;
        for (int i = 0; i < lisChoices.size(); ++i) {
            choice = lisChoices.get(i);
            String value = choice.strValue;
            if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                input.iSelectedChoice = i;
                continue;
            }
            String set = input.strDefaultValue;
            if (set == null) continue;
            if (set != null && !"".equals(set)) {
                VariableSubstitutorImpl vs = new VariableSubstitutorImpl(idata.getVariables());
                try {
                    set = vs.substitute(set);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!set.equals(TRUE)) continue;
            input.iSelectedChoice = 1;
        }
        System.out.println("  [" + (input.iSelectedChoice == 1 ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            boolean bKeepAsking = true;
            while (bKeepAsking) {
                System.out.println("input 1 to select, 0 to deselect:");
                String strIn = reader.readLine();
                if (strIn.trim().equals("")) {
                    bKeepAsking = false;
                }
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (j != 0 && j != 1) continue;
                input.iSelectedChoice = j;
                bKeepAsking = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        idata.setVariable(variable, input.listChoices.get((int)input.iSelectedChoice).strValue);
        return true;
    }

    public Input getInputFromField(IXMLElement field, AutomatedInstallData idata) {
        String strVariableName = field.getAttribute(VARIABLE);
        String strFieldType = field.getAttribute(TYPE_ATTRIBUTE);
        if (TITLE_FIELD.equals(strFieldType)) {
            String strText = null;
            strText = field.getAttribute(TEXT);
            return new Input(strVariableName, null, null, TITLE_FIELD, strText, 0);
        }
        if (STATIC_TEXT.equals(strFieldType)) {
            String strText = null;
            strText = field.getAttribute(TEXT);
            return new Input(strVariableName, null, null, STATIC_TEXT, strText, 0);
        }
        if (TEXT_FIELD.equals(strFieldType) || FILE.equals(strFieldType) || DIR.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = spec.getAttribute(TEXT);
                strSet = spec.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            choicesList.add(new Choice(strText, null, strSet));
            return new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0);
        }
        if (RULE_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = spec.getAttribute(TEXT);
                strSet = spec.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            if (strSet != null && spec.getAttribute(LAYOUT) != null) {
                String token;
                StringTokenizer layoutTokenizer = new StringTokenizer(spec.getAttribute(LAYOUT));
                List<String> listSet = Arrays.asList(new String[layoutTokenizer.countTokens()]);
                StringTokenizer setTokenizer = new StringTokenizer(strSet);
                while (setTokenizer.hasMoreTokens()) {
                    token = setTokenizer.nextToken();
                    if (!token.contains(":")) continue;
                    listSet.set(new Integer(token.substring(0, token.indexOf(":"))), token.substring(token.indexOf(":") + 1));
                }
                int iCounter = 0;
                StringBuffer buffer = new StringBuffer();
                String strRusultFormat = spec.getAttribute(RESULT_FORMAT);
                String strSpecialSeparator = spec.getAttribute(SPECIAL_SEPARATOR);
                while (layoutTokenizer.hasMoreTokens()) {
                    token = layoutTokenizer.nextToken();
                    if (token.matches(".*:.*:.*")) {
                        buffer.append(listSet.get(iCounter) != null ? listSet.get(iCounter) : "");
                        ++iCounter;
                        continue;
                    }
                    if (SPECIAL_SEPARATOR.equals(strRusultFormat)) {
                        buffer.append(strSpecialSeparator);
                        continue;
                    }
                    if (PLAIN_STRING.equals(strRusultFormat)) continue;
                    buffer.append(token);
                }
                strSet = buffer.toString();
            }
            choicesList.add(new Choice(strText, null, strSet));
            return new Input(strVariableName, strSet, choicesList, TEXT_FIELD, strFieldText, 0);
        }
        if (COMBO_FIELD.equals(strFieldType) || RADIO_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            int selection = -1;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            List<IXMLElement> choices = null;
            if (spec != null) {
                choices = spec.getChildrenNamed(CHOICE);
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            for (int i = 0; i < choices.size(); ++i) {
                VariableSubstitutorImpl variableSubstitutor;
                String set;
                IXMLElement choice = choices.get(i);
                String processorClass = choice.getAttribute("processor");
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).newInstance()).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    set = choice.getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        variableSubstitutor = new VariableSubstitutorImpl(idata.getVariables());
                        set = variableSubstitutor.substitute(set);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        String choiceSet = null;
                        if (token.equals(set)) {
                            choiceSet = TRUE;
                            selection = counter;
                        }
                        choicesList.add(new Choice(token, token, choiceSet));
                        ++counter;
                    }
                    continue;
                }
                String value = choice.getAttribute(VALUE);
                set = choice.getAttribute(SET);
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        variableSubstitutor = new VariableSubstitutorImpl(idata.getVariables());
                        set = variableSubstitutor.substitute(set);
                    }
                    if (set.equalsIgnoreCase(TRUE)) {
                        selection = i;
                    }
                }
                choicesList.add(new Choice(choice.getAttribute(TEXT), value, set));
            }
            if (choicesList.size() == 1) {
                selection = 0;
            }
            return new Input(strVariableName, null, choicesList, strFieldType, strFieldText, selection);
        }
        if (CHECK_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            int iSelectedChoice = 0;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = spec.getAttribute(TEXT);
                strSet = spec.getAttribute(SET);
                choicesList.add(new Choice(strText, spec.getAttribute("false"), null));
                choicesList.add(new Choice(strText, spec.getAttribute(TRUE), null));
                if (strSet != null && strSet.equalsIgnoreCase(TRUE)) {
                    iSelectedChoice = 1;
                }
            } else {
                System.out.println("No spec specified for input of type check");
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            return new Input(strVariableName, strSet, choicesList, CHECK_FIELD, strFieldText, iSelectedChoice);
        }
        if (SPACE.equals(strFieldType)) {
            return SPACE_INTPUT_FIELD;
        }
        if (DIVIDER.equals(strFieldType)) {
            return DIVIDER_INPUT_FIELD;
        }
        if (PASSWORD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            if (spec != null) {
                List<IXMLElement> pwds = spec.getChildrenNamed(PWD);
                if (pwds == null || pwds.size() == 0) {
                    System.out.println("No pwd specified in the spec for type password");
                    return null;
                }
                Input[] inputs = new Input[pwds.size()];
                for (int i = 0; i < pwds.size(); ++i) {
                    IXMLElement pwde = pwds.get(i);
                    strText = pwde.getAttribute(TEXT);
                    strSet = pwde.getAttribute(SET);
                    choicesList.add(new Choice(strText, null, strSet));
                    inputs[i] = new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0);
                }
                return new Password(strFieldType, inputs);
            }
            System.out.println("No spec specified for input of type password");
            return null;
        }
        System.out.println(strFieldType + " field collection not implemented");
        return null;
    }

    private boolean itemRequiredFor(List<IXMLElement> packs, AutomatedInstallData idata) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < idata.getSelectedPacks().size(); ++i) {
            String selected = idata.getSelectedPacks().get(i).getName();
            for (IXMLElement pack : packs) {
                String required = pack.getAttribute(NAME, "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemRequiredForOs(List<IXMLElement> os) {
        if (os.size() == 0) {
            return true;
        }
        for (IXMLElement osElement : os) {
            String family = osElement.getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static class Password
    extends Input {
        Input[] input;

        public Password(String strFieldType, Input[] input) {
            super(strFieldType);
            this.input = input;
        }
    }

    public static class Choice {
        String strText;
        String strValue;
        String strSet;

        public Choice(String strText, String strValue, String strSet) {
            this.strText = strText;
            this.strValue = strValue;
            this.strSet = strSet;
        }
    }

    public static class Input {
        String strVariableName;
        String strDefaultValue;
        List<Choice> listChoices;
        String strFieldType;
        String strText;
        int iSelectedChoice = -1;

        public Input(String strFieldType) {
            this.strFieldType = strFieldType;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice) {
            this.strVariableName = strVariableName;
            this.strDefaultValue = strDefaultValue;
            this.listChoices = listChoices;
            this.strFieldType = strFieldType;
            this.strText = strFieldText;
            this.iSelectedChoice = iSelectedChoice;
        }
    }
}

