/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import com.izforge.izpack.util.regex.Regexp;
import com.izforge.izpack.util.regex.RegularExpression;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class ContainsRegexpSelector
extends BaseExtendSelector {
    private String userProvidedExpression = null;
    private RegularExpression myRegExp = null;
    private Regexp myExpression = null;
    public static final String EXPRESSION_KEY = "expression";

    public String toString() {
        StringBuffer buf = new StringBuffer("{containsregexpselector expression: ");
        buf.append(this.userProvidedExpression);
        buf.append("}");
        return buf.toString();
    }

    public void setExpression(String theexpression) {
        this.userProvidedExpression = theexpression;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramname = parameter.getName();
                if (EXPRESSION_KEY.equalsIgnoreCase(paramname)) {
                    this.setExpression(parameter.getValue());
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.userProvidedExpression == null) {
            this.setError("The expression attribute is required");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        String teststr = null;
        BufferedReader in = null;
        this.validate();
        if (file.isDirectory()) {
            return true;
        }
        if (this.myRegExp == null) {
            this.myRegExp = new RegularExpression();
            this.myRegExp.setPattern(this.userProvidedExpression);
            this.myExpression = this.myRegExp.getRegexp();
        }
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            teststr = in.readLine();
            while (teststr != null) {
                if (this.myExpression.matches(teststr)) {
                    boolean bl = true;
                    return bl;
                }
                teststr = in.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new Exception("Could not read file " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new Exception("Could not close file " + filename);
                }
            }
        }
    }
}

