/*
 * Decompiled with CFR 0.152.
 */
package com.payex.pospay.client.myntinstaller;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class RRASPingMonitorChecker
implements InstallerListener {
    private boolean shouldRRASPingMonitorBeStarted = false;

    public void afterInstallerInitialization(AutomatedInstallData data) throws Exception {
        if (this.isRRASPingMonitorServiceRunning()) {
            this.shouldRRASPingMonitorBeStarted = true;
            this.stopRRASPingMonitorService();
        }
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.shouldRRASPingMonitorBeStarted) {
            this.startRRASPingMonitorService();
        }
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
    }

    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    public boolean isFileListener() {
        return false;
    }

    public void beforeDir(File dir, PackFile pf) throws Exception {
    }

    public void afterDir(File dir, PackFile pf) throws Exception {
    }

    public void beforeFile(File file, PackFile pf) throws Exception {
    }

    public void afterFile(File file, PackFile pf) throws Exception {
    }

    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    private boolean isRRASPingMonitorServiceRunning() throws IOException, InterruptedException {
        if (this.isWindows()) {
            Process p = Runtime.getRuntime().exec("cmd /c sc query | find \"RRASPingMonitorService\"");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                return false;
            }
            return line.contains("RRASPingMonitorService");
        }
        return false;
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    private void stopRRASPingMonitorService() throws IOException, InterruptedException {
        Process stopServiceProcess = null;
        stopServiceProcess = Runtime.getRuntime().exec("cmd /c net stop RRASPingMonitorService");
        if (stopServiceProcess != null) {
            stopServiceProcess.waitFor();
        }
    }

    private void startRRASPingMonitorService() throws IOException, InterruptedException {
        Process startServiceProcess = null;
        startServiceProcess = Runtime.getRuntime().exec("cmd /c net start RRASPingMonitorService");
        if (startServiceProcess != null) {
            startServiceProcess.waitFor();
        }
    }
}

