/*
 * Decompiled with CFR 0.152.
 */
package com.payex.pospay.client.myntinstaller;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class UpgradeCleaner
implements InstallerListener {
    private final String databaseLog = "database.log";
    private final String databaseScript = "database.script";

    public void afterInstallerInitialization(AutomatedInstallData arg0) throws Exception {
    }

    public void beforePacks(AutomatedInstallData installData, Integer arg1, AbstractUIProgressHandler arg2) throws Exception {
        String pospayHome = installData.getInstallPath();
        if (this.isUpgrade(pospayHome)) {
            System.out.println("Upgrade detected, clean up initiated");
            String outsideCore = pospayHome + File.separator + "sw" + File.separator + "java";
            String insideCore = outsideCore + File.separator + "core" + File.separator + "0";
            this.removeJars(outsideCore, insideCore);
            this.removeDatabase(pospayHome);
            this.removeJre(pospayHome);
            if (this.isWindows()) {
                this.checkPosPayService(pospayHome, installData);
            }
        }
    }

    public void afterDir(File arg0, PackFile arg1) throws Exception {
    }

    public void afterFile(File arg0, PackFile arg1) throws Exception {
    }

    public void afterPack(Pack arg0, Integer arg1, AbstractUIProgressHandler arg2) throws Exception {
    }

    public void afterPacks(AutomatedInstallData arg0, AbstractUIProgressHandler arg1) throws Exception {
    }

    public void beforeDir(File arg0, PackFile arg1) throws Exception {
    }

    public void beforeFile(File arg0, PackFile arg1) throws Exception {
    }

    public void beforePack(Pack arg0, Integer arg1, AbstractUIProgressHandler arg2) throws Exception {
    }

    public boolean isFileListener() {
        return false;
    }

    private boolean isUpgrade(String pospayHome) {
        File file = new File(pospayHome);
        return file.exists();
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    private void removeJars(String ... paths) throws IOException {
        for (String path : paths) {
            File[] files;
            File filesystemFolder = new File(path);
            if (!filesystemFolder.exists()) {
                return;
            }
            if (filesystemFolder.listFiles() == null) {
                return;
            }
            for (File file : files = filesystemFolder.listFiles()) {
                if (!file.exists() || file.isDirectory()) continue;
                file.delete();
            }
        }
    }

    private void removeDatabase(String pospayHome) {
        File databaseFolder = new File(pospayHome = pospayHome + File.separator + "data");
        if (!databaseFolder.exists()) {
            return;
        }
        for (File file : databaseFolder.listFiles()) {
            if (!file.getName().equals("database.log") && !file.getName().equals("database.script")) continue;
            file.delete();
        }
    }

    private void removeJre(String pospayHome) {
        File jreFolder = new File(pospayHome = pospayHome + File.separator + "jre");
        if (!jreFolder.exists()) {
            return;
        }
        try {
            this.delete(jreFolder);
            System.out.println(pospayHome + " was deleted");
        }
        catch (IOException e) {
            System.out.println("Something went wrong when deleting " + pospayHome);
            e.printStackTrace();
        }
    }

    private void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    private void checkPosPayService(String pospayHome, AutomatedInstallData aid) {
        if (this.isPPSDependingOnRRAS()) {
            if (this.isLAN(pospayHome)) {
                aid.setVariable("terminal-connection", "lan");
                return;
            }
            aid.setVariable("terminal-connection", "usb");
            return;
        }
    }

    private boolean isPPSDependingOnRRAS() {
        try {
            Process p = Runtime.getRuntime().exec("cmd /c sc qc PosPayService | find \"DEPENDENCIES\"");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            if (line != null && line.contains("RemoteAccess")) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isLAN(String pospayHome) {
        String path = System.getenv("PPP_HOME") + "/config/config.properties";
        File file = new File(path);
        if (file.isFile()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (!line.contains("pospay.client.relay.enabled")) continue;
                    if (line.contains(" ")) {
                        line = line.replaceAll(" ", "");
                    }
                    return line.equalsIgnoreCase("pospay.client.relay.enabled=false");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

