/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.rules;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.ComparisonOperator;
import com.izforge.izpack.api.rules.Condition;

public abstract class CompareCondition
extends Condition {
    protected String operand1;
    protected String operand2;
    protected ComparisonOperator operator = ComparisonOperator.EQUAL;

    public CompareCondition(String op1, String op2) {
        this.operand1 = op1;
        this.operand2 = op2;
    }

    public CompareCondition() {
    }

    public String getLeftOperand() {
        return this.operand1;
    }

    public void setLeftOperand(String value) {
        this.operand1 = value;
    }

    public String getRightOperand() {
        return this.operand2;
    }

    public void setRightOperand(String value) {
        this.operand2 = value;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        try {
            this.operand1 = xmlcondition.getFirstChildNamed("arg1").getContent();
            this.operand2 = xmlcondition.getFirstChildNamed("arg2").getContent();
            String operatorAttr = xmlcondition.getFirstChildNamed("operator").getContent();
            if (operatorAttr != null) {
                this.operator = ComparisonOperator.getComparisonOperatorFromAttribute(operatorAttr);
            }
        }
        catch (Exception e) {
            throw new Exception("missing element in <condition type=\"" + this.getClass().getSimpleName() + "\"/>");
        }
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on the values <b>");
        details.append(this.operand1);
        details.append("</b> and <b>");
        details.append(this.operand2);
        details.append("</b>");
        details.append("This value has to be <b>" + (Object)((Object)this.operator));
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameXml = new XMLElementImpl("arg1", conditionRoot);
        nameXml.setContent(this.operand1);
        conditionRoot.addChild(nameXml);
        XMLElementImpl valueXml = new XMLElementImpl("arg2", conditionRoot);
        valueXml.setContent(this.operand2);
        conditionRoot.addChild(valueXml);
        XMLElementImpl opXml = new XMLElementImpl("operator", conditionRoot);
        opXml.setContent(this.operator.getAttribute());
        conditionRoot.addChild(opXml);
    }
}

