/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultVariables
implements Variables {
    private final Properties properties;
    private List<DynamicVariable> dynamicVariables = new ArrayList<DynamicVariable>();
    private final VariableSubstitutor replacer;
    private RulesEngine rules;
    private static final Logger logger = Logger.getLogger(DefaultVariables.class.getName());

    public DefaultVariables() {
        this(new Properties());
    }

    public DefaultVariables(Properties properties) {
        this.properties = properties;
        this.replacer = new VariableSubstitutorImpl(properties);
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    @Override
    public void set(String name, String value) {
        if (value != null) {
            this.properties.setProperty(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    @Override
    public String get(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        int result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            try {
                result = Integer.valueOf(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, -1L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        long result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            try {
                result = Long.valueOf(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String replace(String value) {
        if (value != null) {
            try {
                value = this.replacer.substitute(value);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return value;
    }

    @Override
    public synchronized void add(DynamicVariable variable) {
        this.dynamicVariables.add(variable);
    }

    @Override
    public synchronized void refresh() {
        for (DynamicVariable variable : this.dynamicVariables) {
            String newValue;
            String conditionId = variable.getConditionid();
            boolean log = logger.isLoggable(Level.FINE);
            if (conditionId != null && !this.rules.isConditionTrue(conditionId)) {
                if (!log) continue;
                logger.fine("Refreshing dynamic variable=" + variable.getName() + " skipped due to unmet condition=" + conditionId);
                continue;
            }
            try {
                newValue = variable.evaluate(this.replacer);
            }
            catch (IzPackException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IzPackException("Failed to refresh dynamic variables", exception);
            }
            if (newValue != null) {
                this.set(variable.getName(), newValue);
                if (!log) continue;
                logger.fine("Dynamic variable=" + variable.getName() + " set, value=" + newValue);
                continue;
            }
            if (!log) continue;
            logger.fine("Dynamic variable=" + variable.getName() + " unchanged, value=" + variable.getValue());
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

