/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.regex.RegularExpressionFilter;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import java.util.logging.Logger;

public class DynamicVariableImpl
implements DynamicVariable {
    private static final long serialVersionUID = -7985397187206803090L;
    private static final transient Logger logger = Logger.getLogger(DynamicVariableImpl.class.getName());
    private String name;
    private Value value;
    private String conditionid;
    private RegularExpressionFilter regexp;
    private boolean checkonce = false;
    private boolean ignorefailure = true;
    private transient String currentValue;

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("No dynamic variable name defined");
        }
        if (this.value == null) {
            throw new Exception("No dynamic variable value defined for variable " + this.name);
        }
        this.value.validate();
        if (this.regexp != null) {
            this.regexp.validate();
        }
    }

    @Override
    public String evaluate(VariableSubstitutor ... substitutors) throws Exception {
        String newValue = this.currentValue;
        if (this.value == null) {
            return null;
        }
        if (this.checkonce && this.currentValue != null) {
            return this.currentValue;
        }
        try {
            newValue = this.value.resolve(this.regexp, substitutors);
            if (this.checkonce) {
                this.currentValue = newValue;
            }
        }
        catch (Exception e) {
            if (!this.ignorefailure) {
                throw e;
            }
            if (this.regexp != null) {
                for (VariableSubstitutor substitutor : substitutors) {
                    newValue = substitutor.substitute(this.regexp.getDefaultValue(), null);
                }
                if (this.checkonce) {
                    this.currentValue = newValue;
                }
            }
            logger.fine("Error evaluating dynamic variable '" + this.getName() + "': " + e);
        }
        return newValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value) {
        if (value != null) {
            this.value = value;
        }
    }

    @Override
    public RegularExpressionFilter getRegularExpression() {
        return this.regexp;
    }

    @Override
    public void setRegularExpression(RegularExpressionFilter expression) {
        if (expression != null) {
            this.regexp = expression;
        }
    }

    @Override
    public String getConditionid() {
        return this.conditionid;
    }

    @Override
    public void setConditionid(String conditionid) {
        if (conditionid != null) {
            this.conditionid = conditionid;
        }
    }

    public boolean isCheckonce() {
        return this.checkonce;
    }

    @Override
    public void setCheckonce(boolean checkonce) {
        this.checkonce = checkonce;
    }

    public boolean isIgnoreFailure() {
        return this.ignorefailure;
    }

    @Override
    public void setIgnoreFailure(boolean ignore) {
        this.ignorefailure = ignore;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DynamicVariable)) {
            return false;
        }
        DynamicVariable compareObj = (DynamicVariable)obj;
        return this.name.equals(compareObj.getName()) && (this.conditionid == null || this.conditionid.equals(compareObj.getConditionid()));
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.conditionid.hashCode();
    }
}

