/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.handler;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.util.Console;

public class ConsolePrompt
implements Prompt {
    private final Console console;

    public ConsolePrompt(Console console) {
        this.console = console;
    }

    @Override
    public void message(Prompt.Type type, String message) {
        this.console.println(message);
    }

    @Override
    public void message(Prompt.Type type, String title, String message) {
        this.message(type, message);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options) {
        return this.confirm(type, null, message, options);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options, Prompt.Option defaultOption) {
        return this.confirm(type, null, message, options, defaultOption);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options) {
        return this.confirm(type, title, message, options, null);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        Prompt.Option result;
        this.console.println(message);
        if (options == Prompt.Options.OK_CANCEL) {
            String defaultValue = defaultOption != null && defaultOption == Prompt.Option.OK ? "O" : "C";
            String selected = this.console.prompt("Enter O for OK, C to Cancel", new String[]{"O", "C"}, defaultValue);
            result = "O".equals(selected) ? Prompt.Option.OK : Prompt.Option.CANCEL;
        } else if (options == Prompt.Options.YES_NO_CANCEL) {
            String selected;
            String defaultValue = "C";
            if (defaultOption != null) {
                if (defaultOption == Prompt.Option.YES) {
                    defaultValue = "Y";
                } else if (defaultOption == Prompt.Option.NO) {
                    defaultValue = "N";
                }
            }
            result = "Y".equals(selected = this.console.prompt("Enter Y for Yes, N for No, or C to Cancel", new String[]{"Y", "N", "C"}, defaultValue)) ? Prompt.Option.YES : ("N".equals(selected) ? Prompt.Option.NO : Prompt.Option.CANCEL);
        } else {
            String selected;
            String defaultValue = "N";
            if (defaultOption != null && defaultOption == Prompt.Option.YES) {
                defaultValue = "Y";
            }
            result = "Y".equals(selected = this.console.prompt("Enter Y for Yes or N for No", new String[]{"Y", "N"}, defaultValue)) ? Prompt.Option.YES : Prompt.Option.NO;
        }
        return result;
    }
}

