/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionReference;
import com.izforge.izpack.api.rules.RulesEngine;

public class NotCondition
extends ConditionReference {
    private static final long serialVersionUID = 3194843222487006309L;
    protected transient RulesEngine rules;
    private IXMLElement referencedConditionXMLElement;

    public NotCondition(RulesEngine rules) {
        this.rules = rules;
    }

    public IXMLElement getReferencedConditionXMLElement() {
        return this.referencedConditionXMLElement;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
        if (xmlcondition.getChildrenCount() != 1) {
            throw new Exception("Condition \"" + this.getId() + "\" needs exactly one condition as operand");
        }
        this.referencedConditionXMLElement = xmlcondition.getChildAtIndex(0);
    }

    @Override
    public void resolveReference() {
        String refid = this.referencedConditionXMLElement.getAttribute("refid");
        Condition condition = refid != null ? this.rules.getCondition(refid) : this.rules.createCondition(this.referencedConditionXMLElement);
        if (condition == null) {
            throw new IzPackException("Referenced condition \"" + refid + "\" not found");
        }
        this.setReferencedCondition(condition);
    }

    @Override
    public boolean isTrue() {
        Condition condition = this.getReferencedCondition();
        if (condition == null) {
            return false;
        }
        return !condition.isTrue();
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>NOT ");
        details.append(this.getReferencedCondition().getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        IXMLElement conditionElement = this.getInstallData().getRules().createConditionElement(this.getReferencedCondition(), conditionRoot);
        this.getReferencedCondition().makeXMLData(conditionElement);
        conditionRoot.addChild(conditionElement);
    }

    public static Condition createFromCondition(Condition referencedCondition, RulesEngine rules) {
        NotCondition notCondition = null;
        if (referencedCondition != null) {
            notCondition = new NotCondition(rules);
            notCondition.setReferencedCondition(referencedCondition);
            notCondition.setInstalldata(referencedCondition.getInstallData());
        }
        return notCondition;
    }
}

