/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.CompareCondition;
import com.izforge.izpack.api.rules.ComparisonOperator;
import java.util.Comparator;

public class CompareVersionsCondition
extends CompareCondition {
    private static final long serialVersionUID = -5845914969794400006L;

    @Override
    public boolean isTrue() {
        boolean result = false;
        AutomatedInstallData installData = this.getInstallData();
        if (installData != null && this.operand1 != null && this.operand2 != null) {
            Variables variables = installData.getVariables();
            String arg1 = variables.replace(this.operand1);
            String arg2 = variables.replace(this.operand2);
            if (this.operator == null) {
                this.operator = ComparisonOperator.EQUAL;
            }
            int res = new VersionStringComparator().compare(arg1, arg2);
            switch (this.operator) {
                case EQUAL: {
                    result = res == 0;
                    break;
                }
                case NOTEQUAL: {
                    result = res != 0;
                    break;
                }
                case GREATER: {
                    result = res > 0;
                    break;
                }
                case GREATEREQUAL: {
                    result = res >= 0;
                    break;
                }
                case LESS: {
                    result = res < 0;
                    break;
                }
                case LESSEQUAL: {
                    result = res <= 0;
                    break;
                }
            }
        }
        return result;
    }

    private static class VersionStringComparator
    implements Comparator<String> {
        private VersionStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            String[] arr1 = s1.split("[^a-zA-Z0-9_]+");
            String[] arr2 = s2.split("[^a-zA-Z0-9_]+");
            int max = Math.min(arr1.length, arr2.length);
            for (int ii = 0; ii <= max; ++ii) {
                int i2;
                int i1;
                if (ii == arr1.length) {
                    return ii == arr2.length ? 0 : -1;
                }
                if (ii == arr2.length) {
                    return 1;
                }
                try {
                    i1 = Integer.parseInt(arr1[ii]);
                }
                catch (Exception x) {
                    i1 = Integer.MAX_VALUE;
                }
                try {
                    i2 = Integer.parseInt(arr2[ii]);
                }
                catch (Exception x) {
                    i2 = Integer.MAX_VALUE;
                }
                if (i1 != i2) {
                    return i1 - i2;
                }
                int i3 = arr1[ii].compareTo(arr2[ii]);
                if (i3 == 0) continue;
                return i3;
            }
            return 0;
        }
    }
}

