/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import java.util.logging.Logger;

public class UserCondition
extends Condition {
    private static final long serialVersionUID = -2076347348048202718L;
    private static final transient Logger logger = Logger.getLogger(UserCondition.class.getName());
    private String requiredUsername;

    public UserCondition() {
        this(null);
    }

    public UserCondition(String requiredUsername) {
        this.requiredUsername = requiredUsername;
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        if (this.requiredUsername == null) {
            logger.warning("Condition \"" + this.getId() + "\": Expected user name not set, condition will return false");
        } else {
            String actualUsername = System.getProperty("user.name");
            if (actualUsername != null && !actualUsername.isEmpty()) {
                result = this.requiredUsername.equals(actualUsername);
            } else {
                logger.warning("Condition \"" + this.getId() + "\": Non-existing or empty system property user.name, condition will return false.");
            }
        }
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        IXMLElement userElement = xmlcondition.getFirstChildNamed("requiredusername");
        if (userElement == null) {
            throw new Exception("Missing \"requiredusername\" element in condition \"" + this.getId() + "\"");
        }
        this.requiredUsername = userElement.getContent();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl requiredUserEl = new XMLElementImpl("requiredusername", conditionRoot);
        requiredUserEl.setContent(this.requiredUsername);
        conditionRoot.addChild(requiredUserEl);
    }
}

