/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class AntActionInstallerListener
extends SimpleInstallerListener {
    private static final Logger logger = Logger.getLogger(AntActionInstallerListener.class.getName());
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private HashMap<String, HashMap<Object, ArrayList<AntAction>>> actions = null;
    private ArrayList<AntAction> uninstActions = null;
    private VariableSubstitutor variableSubstitutor;
    private UninstallData uninstallData;

    public AntActionInstallerListener(VariableSubstitutor variableSubstitutor, Resources resources, UninstallData uninstallData) {
        super(resources, true);
        this.variableSubstitutor = variableSubstitutor;
        this.actions = new HashMap();
        this.uninstActions = new ArrayList();
        this.uninstallData = uninstallData;
    }

    public HashMap<String, HashMap<Object, ArrayList<AntAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, this.variableSubstitutor);
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        for (Pack pack : idata.getSelectedPacks()) {
            IXMLElement packElement = this.getSpecHelper().getPackForName(pack.getName());
            if (packElement == null) continue;
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            List<IXMLElement> antCallEntries = packElement.getChildrenNamed("antcall");
            if (antCallEntries != null && antCallEntries.size() >= 1) {
                for (IXMLElement antCallEntry : antCallEntries) {
                    AntAction act = this.readAntCall(antCallEntry, idata);
                    if (act == null) continue;
                    ((ArrayList)packActions.get(act.getOrder())).add(act);
                }
                if (((ArrayList)packActions.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(pack.getName(), packActions);
        }
        for (Pack pack : idata.getAvailablePacks()) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.getName(), "beforepack", handler);
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.getName(), "afterpack", handler);
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.informProgressBar()) {
            handler.nextStep(this.getMsg("AntAction.pack"), this.getProgressBarCallerId(), this.getActionCount(idata, "afterpacks"));
        }
        for (Pack pack : idata.getSelectedPacks()) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "afterpacks", handler);
        }
        if (this.uninstActions.size() > 0) {
            this.uninstallData.addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(AutomatedInstallData idata, String order) {
        int retval = 0;
        for (Pack pack : idata.getSelectedPacks()) {
            String currentPack = pack.getName();
            ArrayList<AntAction> actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    protected ArrayList<AntAction> getActions(String packName, String order) {
        if (this.actions == null) {
            return null;
        }
        HashMap<Object, ArrayList<AntAction>> packActions = this.actions.get(packName);
        if (packActions == null || packActions.size() == 0) {
            return null;
        }
        return packActions.get(order);
    }

    private void performAllActions(String packName, String order, AbstractUIProgressHandler handler) throws InstallerException {
        ArrayList<AntAction> actList = this.getActions(packName, order);
        if (actList == null || actList.size() == 0) {
            return;
        }
        logger.fine("Executing all " + order + " Ant actions of pack " + packName + " ...");
        for (AntAction act : actList) {
            if (this.informProgressBar() && handler != null && handler instanceof ExtendedUIProgressHandler && order.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)handler)).progress(act.getMessageID() != null ? this.getMsg(act.getMessageID()) : "");
            }
            try {
                String conditionId = act.getConditionId();
                if (conditionId == null || conditionId != null && this.getInstalldata().getRules().isConditionTrue(act.getConditionId())) {
                    act.performInstallAction();
                }
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
            if (act.getUninstallTargets().size() <= 0) continue;
            this.uninstActions.add(act);
        }
    }

    private AntAction readAntCall(IXMLElement el, AutomatedInstallData idata) throws InstallerException {
        String msgId;
        String buildFile = null;
        String buildResource = null;
        if (el == null) {
            return null;
        }
        SpecHelper spec = this.getSpecHelper();
        VariableSubstitutorImpl subst = new VariableSubstitutorImpl(idata.getVariables());
        AntAction act = new AntAction();
        try {
            act.setOrder(spec.getRequiredAttribute(el, "order"));
            act.setUninstallOrder(el.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        act.setQuiet(spec.isAttributeYes(el, "quiet", false));
        act.setVerbose(spec.isAttributeYes(el, "verbose", false));
        buildFile = el.getAttribute("buildfile");
        act.setConditionId(el.getAttribute("condition"));
        buildResource = this.processBuildfileResource(spec, idata, el);
        if (null == buildFile && null == buildResource) {
            throw new InstallerException("Invalid AntActionsSpec.xml: either buildfile or buildresource must be specified");
        }
        if (null != buildFile && null != buildResource) {
            throw new InstallerException("Invalid AntActionsSpec.xml: cannot specify both buildfile and buildresource");
        }
        if (null != buildFile) {
            try {
                act.setBuildFile(FileUtil.getAbsoluteFile(subst.substitute(buildFile), idata.getInstallPath()));
            }
            catch (Exception e) {
                act.setBuildFile(FileUtil.getAbsoluteFile(buildFile, idata.getInstallPath()));
            }
        } else {
            act.setBuildFile(new File(buildResource));
        }
        String str = el.getAttribute("logfile");
        if (str != null) {
            try {
                act.setLogFile(FileUtil.getAbsoluteFile(subst.substitute(str), idata.getInstallPath()));
            }
            catch (Exception e) {
                act.setLogFile(FileUtil.getAbsoluteFile(str, idata.getInstallPath()));
            }
        }
        if ((msgId = el.getAttribute("messageid")) != null && msgId.length() > 0) {
            act.setMessageID(msgId);
        }
        for (IXMLElement propEl : el.getChildrenNamed("propertyfile")) {
            act.addPropertyFile(spec.getRequiredAttribute(propEl, "path"));
        }
        for (IXMLElement propEl : el.getChildrenNamed("property")) {
            act.setProperty(spec.getRequiredAttribute(propEl, "name"), spec.getRequiredAttribute(propEl, "value"));
        }
        for (IXMLElement targEl : el.getChildrenNamed("target")) {
            act.addTarget(spec.getRequiredAttribute(targEl, "name"));
        }
        for (IXMLElement utargEl : el.getChildrenNamed("uninstall_target")) {
            act.addUninstallTarget(spec.getRequiredAttribute(utargEl, "name"));
        }
        if (null != buildResource && act.getUninstallTargets().size() > 0) {
            this.addBuildResourceToUninstallerData(buildResource);
        }
        return act;
    }

    private String processBuildfileResource(SpecHelper spec, AutomatedInstallData idata, IXMLElement el) throws InstallerException {
        String buildResource = null;
        String attr = el.getAttribute("buildresource");
        if (null != attr) {
            BufferedInputStream bis = new BufferedInputStream(spec.getResource(attr));
            FilterOutputStream bos = null;
            try {
                int aByte;
                File tempFile = File.createTempFile("buildfile_resource", "xml");
                tempFile.deleteOnExit();
                bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                while (-1 != (aByte = bis.read())) {
                    ((BufferedOutputStream)bos).write(aByte);
                }
                bis.close();
                bos.close();
                buildResource = tempFile.getAbsolutePath();
            }
            catch (Exception x) {
                throw new InstallerException("Failed to write buildfile_resource", x);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
        return buildResource;
    }

    private void addBuildResourceToUninstallerData(String buildResource) throws InstallerException {
        byte[] content = null;
        File buildFile = new File(buildResource);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)buildFile.length());
        BufferedInputStream bis = null;
        try {
            int aByte;
            bis = new BufferedInputStream(new FileInputStream(buildFile));
            while (-1 != (aByte = bis.read())) {
                bos.write(aByte);
            }
            content = bos.toByteArray();
            this.uninstallData.addAdditionalData("build_resource", content);
        }
        catch (Exception x) {
            throw new InstallerException("Failed to add buildfile_resource to uninstaller", x);
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

