/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.event.BSFAction;
import com.izforge.izpack.event.SimpleUninstallerListener;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class BSFUninstallerListener
extends SimpleUninstallerListener {
    private List<BSFAction> bsfActions = null;

    private void loadActions() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/bsfActions");
        if (in == null) {
            return;
        }
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.bsfActions = (List)objIn.readObject();
        objIn.close();
        in.close();
    }

    @Override
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        this.loadActions();
        for (BSFAction action : this.bsfActions) {
            action.init();
            action.executeUninstall("beforedeletion", new Object[]{files, handler});
            action.destroy();
        }
    }

    @Override
    public void afterDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        for (BSFAction action : this.bsfActions) {
            action.init();
            action.executeUninstall("afterdeletion", new Object[]{files, handler});
            action.destroy();
        }
    }

    @Override
    public void beforeDelete(File file, AbstractUIProgressHandler handler) throws Exception {
        for (BSFAction action : this.bsfActions) {
            action.init();
            action.executeUninstall("beforedelete", new Object[]{file, handler});
            action.destroy();
        }
    }

    @Override
    public void afterDelete(File file, AbstractUIProgressHandler handler) throws Exception {
        for (BSFAction action : this.bsfActions) {
            action.init();
            action.executeUninstall("afterdelete", new Object[]{file, handler});
            action.destroy();
        }
    }

    @Override
    public boolean isFileListener() {
        return true;
    }
}

