/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.data.DynamicVariableImpl;
import com.izforge.izpack.core.regex.RegularExpressionFilterImpl;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.core.variable.EnvironmentValue;
import com.izforge.izpack.core.variable.ExecValue;
import com.izforge.izpack.core.variable.JarEntryConfigValue;
import com.izforge.izpack.core.variable.PlainConfigFileValue;
import com.izforge.izpack.core.variable.PlainValue;
import com.izforge.izpack.core.variable.RegistryValue;
import com.izforge.izpack.core.variable.ZipEntryConfigFileValue;
import com.izforge.izpack.event.ConfigurationAction;
import com.izforge.izpack.event.ConfigurationActionTask;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.config.ConfigFileTask;
import com.izforge.izpack.util.config.ConfigurableFileCopyTask;
import com.izforge.izpack.util.config.ConfigurableTask;
import com.izforge.izpack.util.config.IniFileCopyTask;
import com.izforge.izpack.util.config.OptionFileCopyTask;
import com.izforge.izpack.util.config.RegistryTask;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import com.izforge.izpack.util.config.SingleIniFileTask;
import com.izforge.izpack.util.config.SingleOptionFileTask;
import com.izforge.izpack.util.config.SingleXmlFileMergeTask;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.file.types.Mapper;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class ConfigurationInstallerListener
extends SimpleInstallerListener {
    private static final Logger logger = Logger.getLogger(ConfigurationInstallerListener.class.getName());
    public static final String SPEC_FILE_NAME = "ConfigurationActionsSpec.xml";
    private HashMap<String, HashMap<Object, ArrayList<ConfigurationAction>>> actions = new HashMap();
    private VariableSubstitutor substlocal;
    private VariableSubstitutor substglobal;

    public ConfigurationInstallerListener(Resources resources) {
        super(resources, true);
    }

    public HashMap<String, HashMap<Object, ArrayList<ConfigurationAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, (VariableSubstitutor)new VariableSubstitutorImpl(idata.getVariables()));
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        Iterator<Pack> iter = idata.getSelectedPacks().iterator();
        Pack p = null;
        while (iter != null && iter.hasNext()) {
            p = iter.next();
            logger.fine("Entering beforepacks configuration action for pack " + p.getName());
            IXMLElement pack = this.getSpecHelper().getPackForName(p.getName());
            if (pack == null) continue;
            logger.fine("Found configuration action descriptor for pack " + p.getName());
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            List<IXMLElement> configActionEntries = pack.getChildrenNamed("configurationaction");
            if (configActionEntries != null) {
                logger.fine("Found " + configActionEntries.size() + " configuration actions");
                if (configActionEntries.size() >= 1) {
                    Iterator<IXMLElement> entriesIter = configActionEntries.iterator();
                    while (entriesIter != null && entriesIter.hasNext()) {
                        ConfigurationAction act = this.readConfigAction(entriesIter.next(), idata);
                        if (act == null) continue;
                        logger.fine("Adding " + act.getOrder() + "configuration action with " + act.getActionTasks().size() + " tasks");
                        ((ArrayList)packActions.get(act.getOrder())).add(act);
                    }
                    if (((ArrayList)packActions.get("afterpacks")).size() > 0) {
                        this.setProgressBarCaller();
                    }
                }
                if (((ArrayList)packActions.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(p.getName(), packActions);
        }
        iter = idata.getAvailablePacks().iterator();
        while (iter.hasNext()) {
            String currentPack = iter.next().getName();
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.getName(), "beforepack", handler);
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.getName(), "afterpack", handler);
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.informProgressBar()) {
            handler.nextStep(this.getMsg("ConfigurationAction.pack"), this.getProgressBarCallerId(), this.getActionCount(idata, "afterpacks"));
        }
        for (Pack pack : idata.getSelectedPacks()) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "afterpacks", handler);
        }
    }

    private int getActionCount(AutomatedInstallData idata, String order) {
        int retval = 0;
        for (Pack pack : idata.getSelectedPacks()) {
            String currentPack = pack.getName();
            ArrayList<ConfigurationAction> actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    protected ArrayList<ConfigurationAction> getActions(String packName, String order) {
        if (this.actions == null) {
            return null;
        }
        HashMap<Object, ArrayList<ConfigurationAction>> packActions = this.actions.get(packName);
        if (packActions == null || packActions.size() == 0) {
            return null;
        }
        return packActions.get(order);
    }

    private void performAllActions(String packName, String order, AbstractUIProgressHandler handler) throws InstallerException {
        ArrayList<ConfigurationAction> actList = this.getActions(packName, order);
        if (actList == null || actList.size() == 0) {
            return;
        }
        logger.fine("Executing all " + order + " configuration actions for " + packName + " ...");
        for (ConfigurationAction act : actList) {
            if (this.informProgressBar() && handler != null && handler instanceof ExtendedUIProgressHandler && order.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)handler)).progress(act.getMessageID() != null ? this.getMsg(act.getMessageID()) : "");
                continue;
            }
            try {
                act.performInstallAction();
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
        }
    }

    private ConfigurationAction readConfigAction(IXMLElement el, AutomatedInstallData idata) throws InstallerException {
        if (el == null) {
            return null;
        }
        SpecHelper spec = this.getSpecHelper();
        ConfigurationAction act = new ConfigurationAction();
        try {
            act.setOrder(spec.getRequiredAttribute(el, "order"));
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        this.substglobal = new VariableSubstitutorImpl(idata.getVariables());
        this.substlocal = new VariableSubstitutorImpl(this.readVariables(idata, el));
        act.setActionTasks(this.readConfigurables(idata, el));
        act.addActionTasks(this.readConfigurableSets(idata, el));
        return act;
    }

    private String substituteVariables(String name) {
        if (this.substglobal != null) {
            try {
                name = this.substglobal.substitute(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.substlocal != null) {
            try {
                name = this.substlocal.substitute(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    protected List<ConfigurationActionTask> readConfigurableSets(AutomatedInstallData idata, IXMLElement parent) throws InstallerException {
        ArrayList<ConfigurationActionTask> configtasks = new ArrayList<ConfigurationActionTask>();
        for (IXMLElement el : parent.getChildrenNamed("configurableset")) {
            ConfigurableFileCopyTask task;
            String attrib = this.requireAttribute(el, "type");
            ConfigType configType = null;
            if (attrib != null) {
                configType = ConfigType.getFromAttribute(attrib);
                if (configType == null) {
                    throw new InstallerException("Unknown configurableset type '" + attrib + "'");
                }
            } else {
                throw new InstallerException("Missing configurableset type");
            }
            switch (configType) {
                case OPTIONS: {
                    task = new OptionFileCopyTask();
                    this.readConfigurableSetCommonAttributes(idata, el, task);
                    break;
                }
                case INI: {
                    task = new IniFileCopyTask();
                    this.readConfigurableSetCommonAttributes(idata, el, task);
                    break;
                }
                default: {
                    throw new InstallerException("Type '" + configType.getAttribute() + "' currently not allowed for ConfigurableSet");
                }
            }
            configtasks.add(new ConfigurationActionTask(task, this.getAttribute(el, "condition"), this.getInstalldata().getRules()));
        }
        return configtasks;
    }

    private void readConfigurableSetCommonAttributes(AutomatedInstallData idata, IXMLElement el, ConfigurableFileCopyTask task) throws InstallerException {
        task.setToDir(FileUtil.getAbsoluteFile(this.getAttribute(el, "todir"), idata.getInstallPath()));
        task.setToFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "tofile"), idata.getInstallPath()));
        task.setFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "fromfile"), idata.getInstallPath()));
        String boolattr = this.getAttribute(el, "keepOldKeys");
        if (boolattr != null) {
            task.setPatchPreserveEntries(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "keepOldValues")) != null) {
            task.setPatchPreserveValues(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "resolveExpressions")) != null) {
            task.setPatchResolveExpressions(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "failonerror")) != null) {
            task.setFailOnError(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "includeemptydirs")) != null) {
            task.setIncludeEmptyDirs(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "overwrite")) != null) {
            task.setOverwrite(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "preservelastmodified")) != null) {
            task.setPreserveLastModified(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "enablemultiplemappings")) != null) {
            task.setEnableMultipleMappings(Boolean.parseBoolean(boolattr));
        }
        if ((boolattr = this.getAttribute(el, "cleanup")) != null) {
            task.setCleanup(Boolean.parseBoolean(boolattr));
        }
        for (FileSet fs : this.readFileSets(idata, el)) {
            task.addFileSet(fs);
        }
        try {
            for (FileNameMapper mapper : this.readMapper(idata, el)) {
                task.add(mapper);
            }
        }
        catch (Exception e) {
            throw new InstallerException(e.getMessage());
        }
    }

    private void readSingleConfigurableTaskCommonAttributes(AutomatedInstallData idata, IXMLElement el, SingleConfigurableTask task) throws InstallerException {
        String attr = this.getAttribute(el, "create");
        if (attr != null) {
            task.setCreate(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "keepOldKeys")) != null) {
            task.setPatchPreserveEntries(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "keepOldValues")) != null) {
            task.setPatchPreserveValues(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "resolveExpressions")) != null) {
            task.setPatchResolveVariables(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "escape")) != null) {
            task.setEscape(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "escapeNewLine")) != null) {
            task.setEscapeNewLine(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "headerComment")) != null) {
            task.setHeaderComment(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "emptyLines")) != null) {
            task.setEmptyLines(Boolean.parseBoolean(attr));
        }
        if ((attr = this.getAttribute(el, "operator")) != null) {
            task.setOperator(attr);
        }
    }

    private void readConfigFileTaskCommonAttributes(AutomatedInstallData idata, IXMLElement el, ConfigFileTask task) throws InstallerException {
        File tofile = FileUtil.getAbsoluteFile(this.requireAttribute(el, "tofile"), idata.getInstallPath());
        task.setToFile(tofile);
        task.setOldFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "patchfile"), idata.getInstallPath()));
        File newfile = FileUtil.getAbsoluteFile(this.getAttribute(el, "originalfile"), idata.getInstallPath());
        task.setNewFile(newfile);
        String boolattr = this.getAttribute(el, "cleanup");
        if (boolattr != null) {
            task.setCleanup(Boolean.parseBoolean(boolattr));
        }
    }

    protected List<ConfigurationActionTask> readConfigurables(AutomatedInstallData idata, IXMLElement parent) throws InstallerException {
        ArrayList<ConfigurationActionTask> configtasks = new ArrayList<ConfigurationActionTask>();
        for (IXMLElement el : parent.getChildrenNamed("configurable")) {
            ConfigurableTask task;
            String attrib = this.requireAttribute(el, "type");
            ConfigType configType = null;
            if (attrib != null) {
                configType = ConfigType.getFromAttribute(attrib);
                if (configType == null) {
                    throw new InstallerException("Unknown configurable type '" + attrib + "'");
                }
            } else {
                throw new InstallerException("Missing configurable type");
            }
            switch (configType) {
                case OPTIONS: {
                    task = new SingleOptionFileTask();
                    this.readConfigFileTaskCommonAttributes(idata, el, (ConfigFileTask)task);
                    this.readSingleConfigurableTaskCommonAttributes(idata, el, (SingleConfigurableTask)task);
                    ((SingleConfigurableTask)task).readFromXML(el);
                    break;
                }
                case INI: {
                    task = new SingleIniFileTask();
                    this.readConfigFileTaskCommonAttributes(idata, el, (ConfigFileTask)task);
                    this.readSingleConfigurableTaskCommonAttributes(idata, el, (SingleConfigurableTask)task);
                    ((SingleConfigurableTask)task).readFromXML(el);
                    break;
                }
                case XML: {
                    task = new SingleXmlFileMergeTask();
                    File tofile = FileUtil.getAbsoluteFile(this.requireAttribute(el, "tofile"), idata.getInstallPath());
                    ((SingleXmlFileMergeTask)task).setToFile(tofile);
                    ((SingleXmlFileMergeTask)task).setPatchFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "patchfile"), idata.getInstallPath()));
                    File originalfile = FileUtil.getAbsoluteFile(this.getAttribute(el, "originalfile"), idata.getInstallPath());
                    if (originalfile == null) {
                        originalfile = tofile;
                    }
                    ((SingleXmlFileMergeTask)task).setOriginalFile(originalfile);
                    ((SingleXmlFileMergeTask)task).setConfigFile(FileUtil.getAbsoluteFile(this.getAttribute(el, "configfile"), idata.getInstallPath()));
                    String boolattr = this.getAttribute(el, "cleanup");
                    if (boolattr != null) {
                        ((SingleXmlFileMergeTask)task).setCleanup(Boolean.parseBoolean(boolattr));
                    }
                    List<FileSet> fslist = this.readFileSets(idata, el);
                    for (FileSet fs : fslist) {
                        ((SingleXmlFileMergeTask)task).addFileSet(fs);
                    }
                    this.readAndAddXPathProperties(idata, el, (SingleXmlFileMergeTask)task);
                    break;
                }
                case REGISTRY: {
                    task = new RegistryTask();
                    ((RegistryTask)task).setFromKey(this.requireAttribute(el, "fromkey"));
                    ((RegistryTask)task).setKey(this.requireAttribute(el, "tokey"));
                    this.readSingleConfigurableTaskCommonAttributes(idata, el, (SingleConfigurableTask)task);
                    break;
                }
                default: {
                    throw new InstallerException("Type '" + configType.getAttribute() + "' currently not allowed for Configurable");
                }
            }
            configtasks.add(new ConfigurationActionTask(task, this.getAttribute(el, "condition"), this.getInstalldata().getRules()));
        }
        return configtasks;
    }

    private void readAndAddXPathProperties(AutomatedInstallData idata, IXMLElement parent, SingleXmlFileMergeTask task) throws InstallerException {
        for (IXMLElement f : parent.getChildrenNamed("xpathproperty")) {
            task.addProperty(this.requireAttribute(f, "key"), this.requireAttribute(f, "value"));
        }
    }

    private List<FileSet> readFileSets(AutomatedInstallData idata, IXMLElement parent) throws InstallerException {
        Iterator<IXMLElement> iter = parent.getChildrenNamed("fileset").iterator();
        ArrayList<FileSet> fslist = new ArrayList<FileSet>();
        try {
            while (iter.hasNext()) {
                String boolval;
                IXMLElement f = iter.next();
                FileSet fs = new FileSet();
                String strattr = this.getAttribute(f, "dir");
                if (strattr != null) {
                    fs.setDir(FileUtil.getAbsoluteFile(strattr, idata.getInstallPath()));
                }
                if ((strattr = this.getAttribute(f, "file")) != null) {
                    fs.setFile(FileUtil.getAbsoluteFile(strattr, idata.getInstallPath()));
                } else if (fs.getDir() == null) {
                    throw new InstallerException("At least one of both attributes, 'dir' or 'file' required in fileset");
                }
                strattr = this.getAttribute(f, "includes");
                if (strattr != null) {
                    fs.setIncludes(strattr);
                }
                if ((strattr = this.getAttribute(f, "excludes")) != null) {
                    fs.setExcludes(strattr);
                }
                if ((boolval = this.getAttribute(f, "casesensitive")) != null) {
                    fs.setCaseSensitive(Boolean.parseBoolean(boolval));
                }
                if ((boolval = this.getAttribute(f, "defaultexcludes")) != null) {
                    fs.setDefaultexcludes(Boolean.parseBoolean(boolval));
                }
                if ((boolval = this.getAttribute(f, "followsymlinks")) != null) {
                    fs.setFollowSymlinks(Boolean.parseBoolean(boolval));
                }
                this.readAndAddIncludes(idata, f, fs);
                this.readAndAddExcludes(idata, f, fs);
                fslist.add(fs);
            }
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        return fslist;
    }

    private List<FileNameMapper> readMapper(AutomatedInstallData idata, IXMLElement parent) throws InstallerException {
        Iterator<IXMLElement> iter = parent.getChildrenNamed("mapper").iterator();
        ArrayList<FileNameMapper> mappers = new ArrayList<FileNameMapper>();
        try {
            while (iter.hasNext()) {
                IXMLElement f = iter.next();
                String attrib = this.requireAttribute(f, "type");
                Mapper.MapperType mappertype = null;
                if (attrib != null) {
                    mappertype = Mapper.MapperType.getFromAttribute(attrib);
                    if (mappertype == null) {
                        throw new InstallerException("Unknown filename mapper type '" + attrib + "'");
                    }
                } else {
                    throw new InstallerException("Missing filename mapper type");
                }
                FileNameMapper mapper = (FileNameMapper)Class.forName(mappertype.getImplementation()).newInstance();
                if (mapper instanceof GlobPatternMapper) {
                    String boolval = this.getAttribute(f, "casesensitive");
                    if (boolval != null) {
                        ((GlobPatternMapper)mapper).setCaseSensitive(Boolean.parseBoolean(boolval));
                    }
                } else {
                    throw new InstallerException("Filename mapper type \"\" currently not supported");
                }
                ((GlobPatternMapper)mapper).setFrom(this.requireAttribute(f, "from"));
                ((GlobPatternMapper)mapper).setTo(this.requireAttribute(f, "to"));
                mappers.add(mapper);
            }
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        return mappers;
    }

    private void readAndAddIncludes(AutomatedInstallData idata, IXMLElement parent, FileSet fileset) throws InstallerException {
        for (IXMLElement f : parent.getChildrenNamed("include")) {
            fileset.createInclude().setName(this.requireAttribute(f, "name"));
        }
    }

    private void readAndAddExcludes(AutomatedInstallData idata, IXMLElement parent, FileSet fileset) throws InstallerException {
        for (IXMLElement f : parent.getChildrenNamed("exclude")) {
            fileset.createExclude().setName(this.requireAttribute(f, "name"));
        }
    }

    private int getConfigFileType(String varname, String type) throws InstallerException {
        int filetype = 0;
        if (type != null) {
            if (type.equalsIgnoreCase("options")) {
                filetype = 0;
            } else if (type.equalsIgnoreCase("xml")) {
                filetype = 2;
            } else if (type.equalsIgnoreCase("ini")) {
                filetype = 1;
            } else {
                this.parseError("Error in definition of dynamic variable " + varname + ": Unknown entry type " + type);
            }
        }
        return filetype;
    }

    protected Properties readVariables(AutomatedInstallData idata, IXMLElement parent) throws InstallerException {
        ArrayList<DynamicVariable> dynamicVariables = new ArrayList<DynamicVariable>();
        for (IXMLElement var : parent.getChildrenNamed("variable")) {
            IXMLElement regexElement;
            String filekey;
            String filesection;
            String stype;
            String entryname;
            String name = this.requireAttribute(var, "name");
            DynamicVariableImpl dynamicVariable = new DynamicVariableImpl();
            dynamicVariable.setName(name);
            String value = this.getAttribute(var, "value");
            if (value != null) {
                dynamicVariable.setValue(new PlainValue(value));
            } else {
                IXMLElement valueElement = var.getFirstChildNamed("value");
                if (valueElement != null) {
                    value = valueElement.getContent();
                    if (value == null) {
                        this.parseError("Empty value element for dynamic variable " + name);
                    }
                    dynamicVariable.setValue(new PlainValue(value));
                }
            }
            value = this.getAttribute(var, "environment");
            if (value != null) {
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue(new EnvironmentValue(value));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous environment value definition for dynamic variable " + name);
                }
            }
            if ((value = this.getAttribute(var, "regkey")) != null) {
                String regroot = this.getAttribute(var, "regroot");
                String regvalue = this.getAttribute(var, "regvalue");
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue(new RegistryValue(regroot, value, regvalue));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous registry value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("file")) != null) {
                String stype2 = var.getAttribute("type");
                String filesection2 = var.getAttribute("section");
                String filekey2 = this.requireAttribute(var, "key");
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue(new PlainConfigFileValue(value, this.getConfigFileType(name, stype2), filesection2, filekey2));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("zipfile")) != null) {
                entryname = this.requireAttribute(var, "entry");
                stype = var.getAttribute("type");
                filesection = var.getAttribute("section");
                filekey = this.requireAttribute(var, "key");
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue(new ZipEntryConfigFileValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = var.getAttribute("jarfile")) != null) {
                entryname = this.requireAttribute(var, "entry");
                stype = var.getAttribute("type");
                filesection = var.getAttribute("section");
                filekey = this.requireAttribute(var, "key");
                if (dynamicVariable.getValue() == null) {
                    dynamicVariable.setValue(new JarEntryConfigValue(value, entryname, this.getConfigFileType(name, stype), filesection, filekey));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous file value definition for dynamic variable " + name);
                }
            }
            if ((value = this.getAttribute(var, "executable")) != null) {
                if (dynamicVariable.getValue() == null) {
                    String dir = var.getAttribute("dir");
                    String exectype = var.getAttribute("type");
                    String boolval = var.getAttribute("stderr");
                    boolean stderr = false;
                    if (boolval != null) {
                        stderr = Boolean.parseBoolean(boolval);
                    }
                    if (value.length() <= 0) {
                        this.parseError("No command given in definition of dynamic variable " + name);
                    }
                    Vector<String> cmd = new Vector<String>();
                    cmd.add(value);
                    List<IXMLElement> args = var.getChildrenNamed("arg");
                    if (args != null) {
                        for (IXMLElement arg : args) {
                            String content = arg.getContent();
                            if (content == null) continue;
                            cmd.add(content);
                        }
                    }
                    String[] cmdarr = new String[cmd.size()];
                    if (exectype.equalsIgnoreCase("process") || exectype == null) {
                        dynamicVariable.setValue(new ExecValue(cmd.toArray(cmdarr), dir, false, stderr));
                    } else if (exectype.equalsIgnoreCase("shell")) {
                        dynamicVariable.setValue(new ExecValue(cmd.toArray(cmdarr), dir, true, stderr));
                    } else {
                        this.parseError("Bad execution type " + exectype + " given for dynamic variable " + name);
                    }
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous execution output value definition for dynamic variable " + name);
                }
            }
            if (dynamicVariable.getValue() == null) {
                this.parseError("No value specified at all for dynamic variable " + name);
            }
            if ((value = this.getAttribute(var, "checkonce")) != null) {
                dynamicVariable.setCheckonce(Boolean.valueOf(value));
            }
            if ((value = this.getAttribute(var, "ignorefailure")) != null) {
                dynamicVariable.setIgnoreFailure(Boolean.valueOf(value));
            }
            if ((regexElement = var.getFirstChildNamed("regex")) != null) {
                String expression = this.getAttribute(regexElement, "regexp");
                String selectexpr = this.getAttribute(regexElement, "select");
                String replaceexpr = this.getAttribute(regexElement, "replace");
                String defaultvalue = this.getAttribute(regexElement, "defaultvalue");
                String scasesensitive = this.getAttribute(regexElement, "casesensitive");
                String sglobal = this.getAttribute(regexElement, "global");
                if (dynamicVariable.getRegularExpression() == null) {
                    dynamicVariable.setRegularExpression(new RegularExpressionFilterImpl(expression, selectexpr, replaceexpr, defaultvalue, Boolean.valueOf(scasesensitive != null ? scasesensitive : "true"), Boolean.valueOf(sglobal != null ? sglobal : "false")));
                    try {
                        dynamicVariable.validate();
                    }
                    catch (Exception e) {
                        this.parseError("Error in definition of dynamic variable " + name + ": " + e.getMessage());
                    }
                } else {
                    this.parseError("Ambiguous regular expression filter definition for dynamic variable " + name);
                }
            }
            for (DynamicVariable dynvar : dynamicVariables) {
                String conditionid = this.getAttribute(var, "condition");
                dynamicVariable.setConditionid(conditionid);
                if (dynvar.getName().equals(name)) {
                    dynamicVariables.remove(dynvar);
                    this.parseWarn(var, "Dynamic Variable '" + name + "' overwritten");
                }
                dynamicVariables.add(dynamicVariable);
            }
        }
        return this.evaluateDynamicVariables(dynamicVariables, idata);
    }

    private Properties evaluateDynamicVariables(List<DynamicVariable> dynamicvariables, AutomatedInstallData installdata) throws InstallerException {
        VariableSubstitutorImpl subst = new VariableSubstitutorImpl(installdata.getVariables());
        Properties props = new Properties();
        RulesEngine rules = installdata.getRules();
        logger.fine("Evaluating configuration variables");
        if (dynamicvariables != null) {
            for (DynamicVariable dynvar : dynamicvariables) {
                String name = dynvar.getName();
                logger.fine("Configuration variable: " + name);
                boolean refresh = false;
                String conditionid = dynvar.getConditionid();
                logger.fine("condition: " + conditionid);
                if (conditionid != null && conditionid.length() > 0) {
                    if (rules != null && rules.isConditionTrue(conditionid)) {
                        logger.fine("Refresh configuration variable \"" + name + "\" based on global condition \" " + conditionid + "\"");
                        refresh = true;
                    }
                } else {
                    logger.fine("Refresh configuration variable \"" + name + "\" based on local condition \" " + conditionid + "\"");
                    refresh = true;
                }
                if (!refresh) continue;
                try {
                    String newValue = dynvar.evaluate(subst);
                    if (newValue != null) {
                        logger.fine("Configuration variable " + name + ": " + newValue);
                        props.setProperty(name, newValue);
                        continue;
                    }
                    logger.fine("Configuration variable " + name + " unchanged: " + dynvar.getValue());
                }
                catch (Exception e) {
                    throw new InstallerException(e);
                }
            }
        }
        return props;
    }

    protected String requireAttribute(IXMLElement element, String attribute) throws InstallerException {
        String value = this.getAttribute(element, attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected String getAttribute(IXMLElement element, String attribute) throws InstallerException {
        String value = element.getAttribute(attribute);
        if (value != null) {
            return this.substituteVariables(value);
        }
        return value;
    }

    protected void parseError(String message) throws InstallerException {
        throw new InstallerException("ConfigurationActionsSpec.xml:" + message);
    }

    protected void parseError(IXMLElement parent, String message) throws InstallerException {
        throw new InstallerException("ConfigurationActionsSpec.xml:" + parent.getLineNr() + ": " + message);
    }

    protected void parseWarn(IXMLElement parent, String message) {
        System.out.println("Warning: ConfigurationActionsSpec.xml:" + parent.getLineNr() + ": " + message);
    }

    public static enum ConfigType {
        OPTIONS("options"),
        INI("ini"),
        XML("xml"),
        REGISTRY("registry");

        private static Map<String, ConfigType> lookup;
        private String attribute;

        private ConfigType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ConfigType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ConfigType>();
            for (ConfigType operation : EnumSet.allOf(ConfigType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }
    }
}

