/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.api.handler.Prompt;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class GUIPrompt
implements Prompt {
    private final JComponent parent;
    private static final String OK_BUTTON = "OptionPane.okButtonText";
    private static final String CANCEL_BUTTON = "OptionPane.cancelButtonText";
    private static final String YES_BUTTON = "OptionPane.yesButtonText";
    private static final String NO_BUTTON = "OptionPane.noButtonText";

    public GUIPrompt() {
        this(null);
    }

    public GUIPrompt(JComponent parent) {
        this.parent = parent;
    }

    @Override
    public void message(Prompt.Type type, String message) {
        this.message(type, null, message);
    }

    @Override
    public void message(Prompt.Type type, String title, String message) {
        if (title == null) {
            title = this.getTitle(type);
        }
        JOptionPane.showMessageDialog(this.parent, message, title, this.getMessageType(type));
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options) {
        return this.confirm(type, message, options, null);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String message, Prompt.Options options, Prompt.Option defaultOption) {
        return this.confirm(type, this.getTitle(type), message, options, defaultOption);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options) {
        return this.confirm(type, title, message, options, null);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        int selected;
        int optionType;
        int messageType = this.getMessageType(type);
        switch (options) {
            case OK_CANCEL: {
                optionType = 2;
                break;
            }
            case YES_NO_CANCEL: {
                optionType = 1;
                break;
            }
            default: {
                optionType = 0;
            }
        }
        if (title == null) {
            title = this.getTitle(type);
        }
        if (defaultOption == null) {
            selected = JOptionPane.showConfirmDialog(this.parent, message, title, optionType, messageType);
        } else {
            ArrayList<String> opts = new ArrayList<String>();
            String initialValue = null;
            switch (optionType) {
                case 2: {
                    String ok = UIManager.getString(OK_BUTTON);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    opts.add(ok);
                    opts.add(cancel);
                    initialValue = defaultOption == Prompt.Option.OK ? ok : (defaultOption == Prompt.Option.CANCEL ? cancel : null);
                    break;
                }
                case 0: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : null);
                    break;
                }
                case 1: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : (defaultOption == Prompt.Option.CANCEL ? cancel : null));
                    break;
                }
            }
            selected = JOptionPane.showOptionDialog(this.parent, message, title, optionType, messageType, null, opts.toArray(), initialValue);
        }
        return this.getSelected(options, selected);
    }

    private Prompt.Option getSelected(Prompt.Options options, int selected) {
        Prompt.Option result;
        switch (selected) {
            case 0: {
                result = options == Prompt.Options.OK_CANCEL ? Prompt.Option.OK : Prompt.Option.YES;
                break;
            }
            case 1: {
                result = Prompt.Option.NO;
                break;
            }
            case 2: {
                result = Prompt.Option.CANCEL;
                break;
            }
            default: {
                result = options == Prompt.Options.YES_NO_CANCEL ? Prompt.Option.CANCEL : Prompt.Option.NO;
            }
        }
        return result;
    }

    private String getTitle(Prompt.Type type) {
        String result;
        switch (type) {
            case INFORMATION: {
                result = "Info";
                break;
            }
            case QUESTION: {
                result = "Question";
                break;
            }
            case WARNING: {
                result = "Warning";
                break;
            }
            default: {
                result = "Error";
            }
        }
        return result;
    }

    private int getMessageType(Prompt.Type type) {
        int result;
        switch (type) {
            case INFORMATION: {
                result = 1;
                break;
            }
            case WARNING: {
                result = 2;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }
}

