/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.container.impl.InstallerContainer;
import com.izforge.izpack.installer.container.provider.GUIInstallDataProvider;
import com.izforge.izpack.installer.container.provider.IconsProvider;
import com.izforge.izpack.installer.gui.InstallerController;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.language.LanguageDialog;
import com.izforge.izpack.installer.manager.PanelManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.injectors.ProviderAdapter;

public class GUIInstallerContainer
extends InstallerContainer {
    public GUIInstallerContainer() {
        this.initialise();
    }

    protected GUIInstallerContainer(MutablePicoContainer container) {
        this.initialise(container);
    }

    @Override
    protected void registerComponents(MutablePicoContainer pico) {
        super.registerComponents(pico);
        pico.addAdapter(new ProviderAdapter(new GUIInstallDataProvider())).addAdapter(new ProviderAdapter(new IconsProvider()));
        pico.addComponent(PanelManager.class).addComponent(GUIPrompt.class).addComponent(InstallerController.class).addComponent(InstallerFrame.class).addComponent(Log.class).as(Characteristics.USE_NAMES).addComponent(LanguageDialog.class);
    }

    @Override
    protected void resolveComponents(MutablePicoContainer pico) {
        super.resolveComponents(pico);
        AutomatedInstallData installdata = pico.getComponent(AutomatedInstallData.class);
        pico.addConfig("title", this.getTitle(installdata)).addConfig("frame", this.initFrame());
    }

    private JFrame initFrame() {
        ResourceManager resourceManager = this.getComponent(ResourceManager.class);
        JFrame frame = new JFrame();
        ImageIcon imageIcon = resourceManager.getImageIcon("JFrameIcon", "/com/izforge/izpack/img/JFrameIcon.png");
        frame.setIconImage(imageIcon.getImage());
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
        return frame;
    }

    private String getTitle(AutomatedInstallData automatedInstallData) {
        String key = "installer.reversetitle";
        Messages messages = automatedInstallData.getMessages();
        String message = messages.get("installer.reversetitle", new Object[0]);
        message = message.equals("installer.reversetitle") ? messages.get("installer.title", new Object[0]) + " " + automatedInstallData.getInfo().getAppName() : automatedInstallData.getVariables().replace(message);
        return message;
    }
}

