/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.data;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.merge.resolve.PathResolver;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UninstallDataWriter {
    private UninstallData uninstallData;
    private AutomatedInstallData installData;
    private PathResolver pathResolver;
    private JarOutputStream jar;
    private FileOutputStream jarStream;
    private RulesEngine rules;
    private static final Logger logger = Logger.getLogger(UninstallDataWriter.class.getName());
    private static final String LOGFILE_PATH = "InstallerFrame.logfilePath";

    public UninstallDataWriter(UninstallData uninstallData, AutomatedInstallData installData, PathResolver pathResolver, RulesEngine rules) {
        this.uninstallData = uninstallData;
        this.installData = installData;
        this.pathResolver = pathResolver;
        this.rules = rules;
    }

    public boolean isUninstallRequired() {
        String condition = this.installData.getInfo().getUninstallerCondition();
        return this.installData.getInfo().getUninstallerPath() != null && (condition == null || condition.length() == 0 || this.rules.isConditionTrue(condition));
    }

    public boolean write() {
        boolean result = false;
        try {
            BufferedWriter extLogWriter = this.getExternalLogFile();
            this.createOutputJar();
            System.out.println("[ Writing the uninstaller data ... ]");
            this.writeJarSkeleton();
            this.writeFilesLog(extLogWriter);
            this.writeUninstallerJarFileLog();
            this.writeExecutables();
            this.writeUninstallerListeners();
            this.writeJars();
            this.writeNativeLibraries();
            this.writeAdditionalUninstallData();
            this.writeScriptFiles();
            this.jar.close();
            result = true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, t.getMessage(), t);
            this.destroyJar();
        }
        return result;
    }

    private BufferedWriter getExternalLogFile() {
        String logfile = this.installData.getVariable(LOGFILE_PATH);
        BufferedWriter writer = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = this.installData.getInfo().getUninstallerPath() + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, this.installData.getVariables()))).getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                logger.warning("Failed to create directory: " + outFile.getParentFile().getPath());
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.WARNING, "Cannot create logfile", e);
            }
            if (out != null) {
                writer = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        return writer;
    }

    private void writeJarSkeleton() throws IOException {
        List<Mergeable> uninstallerMerge = this.pathResolver.getMergeableFromPath("com/izforge/izpack/uninstaller/");
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("uninstaller-META-INF/", "META-INF/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/api/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/data/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/core/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/util/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/gui/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/img/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("org/picocontainer/"));
        uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("org/apache/tools/zip/"));
        if (!this.uninstallData.getUninstallerListeners().isEmpty()) {
            uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/event/"));
        }
        if (this.rules.isConditionTrue("izpack.windowsinstall")) {
            uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/izforge/izpack/core/os/"));
            uninstallerMerge.addAll(this.pathResolver.getMergeableFromPath("com/coi/tools/os/"));
        }
        for (Mergeable mergeable : uninstallerMerge) {
            mergeable.merge(this.jar);
        }
        if (this.installData.getInfo().isPrivilegedExecutionRequiredUninstaller()) {
            this.jar.putNextEntry(new JarEntry("exec-admin"));
            this.jar.closeEntry();
            if (this.rules.isConditionTrue("izpack.windowsinstall")) {
                this.writeResource("com/izforge/izpack/util/windows/elevate.js");
            }
            if (this.rules.isConditionTrue("izpack.macinstall")) {
                this.writeResource("com/izforge/izpack/util/mac/run-with-privileges-on-osx");
            }
        }
        List<Mergeable> langPack = this.pathResolver.getMergeableFromPath("resources/langpacks/" + this.installData.getLocaleISO3() + ".xml", "langpack.xml");
        for (Mergeable mergeable : langPack) {
            mergeable.merge(this.jar);
        }
    }

    private void writeFilesLog(BufferedWriter extLogWriter) throws IOException {
        List<String> files = this.uninstallData.getUninstalableFilesList();
        this.jar.putNextEntry(new JarEntry("install.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(this.jar));
        logWriter.write(this.installData.getInstallPath());
        logWriter.newLine();
        Iterator<String> iter = files.iterator();
        if (extLogWriter != null) {
            while (iter.hasNext()) {
                String txt = iter.next();
                logWriter.write(txt);
                extLogWriter.write(txt);
                if (!iter.hasNext()) continue;
                logWriter.newLine();
                extLogWriter.newLine();
            }
            logWriter.flush();
            extLogWriter.flush();
            extLogWriter.close();
        } else {
            while (iter.hasNext()) {
                String txt = iter.next();
                logWriter.write(txt);
                if (!iter.hasNext()) continue;
                logWriter.newLine();
            }
            logWriter.flush();
        }
        this.jar.closeEntry();
    }

    private void writeExecutables() throws IOException {
        this.jar.putNextEntry(new JarEntry("executables"));
        ObjectOutputStream execStream = new ObjectOutputStream(this.jar);
        execStream.writeInt(this.uninstallData.getExecutablesList().size());
        for (ExecutableFile file : this.uninstallData.getExecutablesList()) {
            execStream.writeObject(file);
        }
        execStream.flush();
        this.jar.closeEntry();
    }

    private void writeUninstallerJarFileLog() throws IOException {
        this.jar.putNextEntry(new JarEntry("jarlocation.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(this.jar));
        logWriter.write(this.uninstallData.getUninstallerJarFilename());
        logWriter.newLine();
        logWriter.write(this.uninstallData.getUninstallerPath());
        logWriter.flush();
        this.jar.closeEntry();
    }

    private void writeUninstallerListeners() throws IOException {
        ArrayList<String> listeners = new ArrayList<String>();
        this.writeCustomDataResources(this.uninstallData.getUninstallerListeners());
        for (CustomData data : this.uninstallData.getUninstallerListeners()) {
            if (data.listenerName == null) continue;
            listeners.add(data.listenerName);
        }
        this.jar.putNextEntry(new JarEntry("uninstallerListeners"));
        ObjectOutputStream stream = new ObjectOutputStream(this.jar);
        stream.writeObject(listeners);
        stream.flush();
        this.jar.closeEntry();
    }

    private void writeJars() throws IOException {
        this.writeCustomDataResources(this.uninstallData.getJars());
    }

    private void writeNativeLibraries() throws IOException {
        for (String path : this.uninstallData.getNativeLibraries()) {
            this.writeResource(path);
        }
    }

    private void writeAdditionalUninstallData() throws IOException {
        Map<String, Object> additionalData = this.uninstallData.getAdditionalData();
        if (additionalData != null && !additionalData.isEmpty()) {
            for (String key : additionalData.keySet()) {
                Object content = additionalData.get(key);
                this.writeContent(key, content);
            }
        }
    }

    private void writeScriptFiles() throws IOException {
        ArrayList<String> unInstallScripts = this.uninstallData.getUninstallScripts();
        int idx = 0;
        for (String unInstallScript : unInstallScripts) {
            this.jar.putNextEntry(new JarEntry("rootscript" + Integer.toString(idx)));
            ObjectOutputStream rootStream = new ObjectOutputStream(this.jar);
            rootStream.writeUTF(unInstallScript);
            rootStream.flush();
            this.jar.closeEntry();
            ++idx;
        }
    }

    private void writeCustomDataResources(List<CustomData> customData) throws IOException {
        for (CustomData data : customData) {
            if (data.contents == null) continue;
            for (String content : data.contents) {
                this.writeResource(content);
            }
        }
    }

    private void writeResource(String path) throws IOException {
        for (Mergeable mergeable : this.pathResolver.getMergeableFromPath(path)) {
            mergeable.merge(this.jar);
        }
    }

    private void writeContent(String path, Object content) throws IOException {
        this.jar.putNextEntry(new JarEntry(path));
        if (content instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)content).writeTo(this.jar);
        } else {
            ObjectOutputStream out = new ObjectOutputStream(this.jar);
            out.writeObject(content);
            out.flush();
        }
        this.jar.closeEntry();
    }

    private void createOutputJar() throws IOException {
        String dirPath = IoHelper.translatePath(this.installData.getInfo().getUninstallerPath(), this.installData.getVariables());
        String jarPath = dirPath + File.separator + this.installData.getInfo().getUninstallerName();
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create output path: " + dir);
        }
        this.uninstallData.setUninstallerJarFilename(jarPath);
        this.uninstallData.setUninstallerPath(dirPath);
        this.jarStream = new FileOutputStream(jarPath);
        this.jar = new JarOutputStream(new BufferedOutputStream(this.jarStream));
        this.jar.setLevel(9);
        this.uninstallData.addFile(jarPath, true);
    }

    private void destroyJar() {
        File file;
        FileUtils.close(this.jar);
        FileUtils.close(this.jarStream);
        String path = this.uninstallData.getUninstallerJarFilename();
        if (path != null && (file = new File(path)).exists() && !file.delete()) {
            logger.warning("Failed to delete incomplete uninstall information: " + path);
        }
    }
}

