/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.event;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InstallerListeners
implements InstallerListener {
    private final List<InstallerListener> listeners = new ArrayList<InstallerListener>();
    private boolean fileListener;

    public void add(InstallerListener listener) {
        this.listeners.add(listener);
        if (!this.fileListener && listener.isFileListener()) {
            this.fileListener = true;
        }
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public InstallerListener get(int index) {
        return this.listeners.get(index);
    }

    @Override
    public void beforePacks(AutomatedInstallData data, Integer packs, AbstractUIProgressHandler handler) throws Exception {
        for (InstallerListener listener : this.listeners) {
            listener.beforePacks(data, packs, handler);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        for (InstallerListener listener : this.listeners) {
            listener.beforePack(pack, i, handler);
        }
    }

    @Override
    public boolean isFileListener() {
        return this.fileListener;
    }

    @Override
    public void beforeDir(File dir, PackFile packFile) throws Exception {
        if (this.fileListener) {
            for (InstallerListener listener : this.listeners) {
                if (!listener.isFileListener()) continue;
                listener.beforeDir(dir, packFile);
            }
        }
    }

    @Override
    public void afterDir(File dir, PackFile packFile) throws Exception {
        if (this.fileListener) {
            for (InstallerListener listener : this.listeners) {
                if (!listener.isFileListener()) continue;
                listener.afterDir(dir, packFile);
            }
        }
    }

    @Override
    public void beforeFile(File file, PackFile packFile) throws Exception {
        if (this.fileListener) {
            for (InstallerListener listener : this.listeners) {
                if (!listener.isFileListener()) continue;
                listener.beforeFile(file, packFile);
            }
        }
    }

    @Override
    public void afterFile(File file, PackFile packFile) throws Exception {
        if (this.fileListener) {
            for (InstallerListener listener : this.listeners) {
                if (!listener.isFileListener()) continue;
                listener.afterFile(file, packFile);
            }
        }
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        for (InstallerListener listener : this.listeners) {
            listener.afterPack(pack, i, handler);
        }
    }

    @Override
    public void afterPacks(AutomatedInstallData data, AbstractUIProgressHandler handler) throws Exception {
        for (InstallerListener listener : this.listeners) {
            listener.afterPacks(data, handler);
        }
    }

    @Override
    public void afterInstallerInitialization(AutomatedInstallData installData) throws Exception {
        for (InstallerListener listener : this.listeners) {
            listener.afterInstallerInitialization(installData);
        }
    }
}

