/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.manager;

import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.OsConstraintHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PanelManager {
    private GUIInstallData installData;
    private Container installerContainer;
    private final ObjectFactory factory;
    private int lastVis;
    private final ArrayList<Integer> visiblePanelMapping = new ArrayList();

    public PanelManager(GUIInstallData installData, Container installerContainer, ObjectFactory factory) {
        this.installData = installData;
        this.installerContainer = installerContainer;
        this.factory = factory;
    }

    public void createPanels() throws ClassNotFoundException {
        HashMap<String, Panel> panels = new HashMap<String, Panel>();
        int curVisPanelNumber = 0;
        this.lastVis = 0;
        int count = 0;
        for (Panel panel : this.installData.getPanelsOrder()) {
            String key;
            if (!OsConstraintHelper.oneMatchesCurrentSystem(panel.getOsConstraints())) continue;
            String panelId = panel.getPanelid();
            String string = key = panelId != null ? panelId : panel.getClassName();
            if (panels.put(key, panel) != null) {
                throw new IllegalStateException("Duplicate panel: " + key);
            }
            IzPanel izPanel = this.createPanel(panel);
            if (panelId != null) {
                this.installerContainer.addComponent(panelId, izPanel);
            } else {
                this.installerContainer.addComponent(izPanel.getClass(), izPanel);
            }
            this.installData.getPanels().add(izPanel);
            if (izPanel.isHidden()) {
                this.visiblePanelMapping.add(count, -1);
            } else {
                this.visiblePanelMapping.add(count, curVisPanelNumber);
                ++curVisPanelNumber;
                this.lastVis = count;
            }
            ++count;
            XMLElementImpl panelRoot = new XMLElementImpl(panel.getClassName(), this.installData.getXmlData());
            if (panelId != null) {
                panelRoot.setAttribute("id", panelId);
            }
            this.installData.getXmlData().addChild(panelRoot);
            this.visiblePanelMapping.add(count, this.lastVis);
        }
    }

    public boolean isVisible(int panelNumber) {
        return this.visiblePanelMapping.get(panelNumber) != -1;
    }

    public boolean isLast(int panelNumber) {
        return this.visiblePanelMapping.get(this.installData.getPanels().size()) == panelNumber;
    }

    public int getPanelVisibilityNumber(int panel) {
        return this.visiblePanelMapping.get(panel);
    }

    public int getCountVisiblePanel() {
        return this.lastVis;
    }

    private IzPanel createPanel(Panel panel) {
        this.executePreConstructionActions(panel);
        IzPanel izPanel = this.factory.create(panel.getClassName(), IzPanel.class, panel);
        String dataValidator = panel.getValidator();
        if (dataValidator != null) {
            izPanel.setValidationService(this.factory.create(dataValidator, DataValidator.class, new Object[0]));
        }
        izPanel.setHelpUrl(panel.getHelpUrl(this.installData.getLocaleISO3()));
        this.addPreActivationActions(panel, izPanel);
        this.addPreValidateActions(panel, izPanel);
        this.addPostValidationActions(panel, izPanel);
        return izPanel;
    }

    private void executePreConstructionActions(Panel panel) {
        List<String> classNames = panel.getPreConstructionActions();
        if (classNames != null) {
            for (String className : classNames) {
                PanelAction action = this.factory.create(className, PanelAction.class, new Object[0]);
                action.initialize(panel.getPanelActionConfiguration(className));
                action.executeAction(this.installData, null);
            }
        }
    }

    private void addPreActivationActions(Panel panel, IzPanel izPanel) {
        List<String> classNames = panel.getPreActivationActions();
        if (classNames != null) {
            for (String className : classNames) {
                PanelAction action = this.factory.create(className, PanelAction.class, new Object[0]);
                action.initialize(panel.getPanelActionConfiguration(className));
                izPanel.addPreActivationAction(action);
            }
        }
    }

    private void addPreValidateActions(Panel panel, IzPanel izPanel) {
        List<String> classNames = panel.getPreValidationActions();
        if (classNames != null) {
            for (String className : classNames) {
                PanelAction action = this.factory.create(className, PanelAction.class, new Object[0]);
                action.initialize(panel.getPanelActionConfiguration(className));
                izPanel.addPreValidationAction(action);
            }
        }
    }

    private void addPostValidationActions(Panel panel, IzPanel izPanel) {
        List<String> classNames = panel.getPostValidationActions();
        if (classNames != null) {
            for (String className : classNames) {
                PanelAction action = this.factory.create(className, PanelAction.class, new Object[0]);
                action.initialize(panel.getPanelActionConfiguration(className));
                izPanel.addPostValidationAction(action);
            }
        }
    }
}

