/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.io.FileSpanningInputStream;
import com.izforge.izpack.core.io.VolumeLocator;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.multiunpacker.MultiVolumeFileUnpacker;
import com.izforge.izpack.installer.multiunpacker.MultiVolumeUnpackerAutomationHelper;
import com.izforge.izpack.installer.multiunpacker.MultiVolumeUnpackerHelper;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.LooseFileUnpacker;
import com.izforge.izpack.installer.unpacker.UnpackerBase;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.logging.Logger;

public class MultiVolumeUnpacker
extends UnpackerBase {
    private VolumeLocator locator;
    private FileSpanningInputStream volumes;
    static final String VOLUMES_INFO = "volumes.info";
    private static final Logger logger = Logger.getLogger(MultiVolumeUnpacker.class.getName());

    public MultiVolumeUnpacker(AutomatedInstallData installData, Resources resources, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData uninstallData, Platform platform, Librarian librarian, Housekeeper housekeeper, InstallerListeners listeners) {
        super(installData, resources, rules, variableSubstitutor, uninstallData, platform, librarian, housekeeper, listeners);
    }

    @Override
    public void setHandler(AbstractUIProgressHandler handler) {
        super.setHandler(handler);
        if (handler instanceof PanelAutomation) {
            logger.fine("running in auto installation mode.");
            this.locator = new MultiVolumeUnpackerAutomationHelper(this.getInstallData());
        } else {
            logger.fine("running in normal installation mode.");
            this.locator = new MultiVolumeUnpackerHelper(this.getInstallData(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preUnpack() throws Exception {
        super.preUnpack();
        InputStream in = null;
        ObjectInputStream objectIn = null;
        try {
            in = this.getResources().getInputStream(VOLUMES_INFO);
            objectIn = new ObjectInputStream(in);
            int volumeCount = objectIn.readInt();
            String volumeName = objectIn.readUTF();
            logger.fine("Reading from " + volumeCount + " volumes with basename " + volumeName + " ");
            String mediaPath = this.getInstallData().getMediaPath();
            if (mediaPath == null || mediaPath.length() == 0) {
                mediaPath = this.getDefaultMediaPath();
            }
            logger.fine("Using mediaDirectory = " + mediaPath);
            File volume = new File(mediaPath, volumeName);
            if (!volume.exists()) {
                volume = this.locator.getVolume(volume.getAbsolutePath(), false);
            }
            this.volumes = new FileSpanningInputStream(volume, volumeCount);
            this.volumes.setLocator(this.locator);
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(objectIn);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(objectIn);
    }

    @Override
    protected FileUnpacker createFileUnpacker(PackFile file, Pack pack, FileQueue queue, Cancellable cancellable) throws IOException, InstallerException {
        FileUnpacker unpacker = pack.isLoose() ? new LooseFileUnpacker(this.getLoosePackFileDir(file), cancellable, this.getHandler(), queue, this.getPlatform(), this.getLibrarian()) : new MultiVolumeFileUnpacker(this.volumes, cancellable, this.getHandler(), queue, this.getPlatform(), this.getLibrarian());
        return unpacker;
    }

    @Override
    protected void skip(PackFile file, Pack pack, ObjectInputStream packInputStream) throws IOException {
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        FileUtils.close(this.volumes);
    }

    private File getLoosePackFileDir(PackFile file) throws IOException, InstallerException {
        File volume;
        File dir;
        File result = this.getAbsoluteInstallSource();
        File loose = new File(result, file.getRelativeSourcePath());
        if (!loose.exists() && (dir = (volume = this.volumes.getVolume()).getParentFile()) != null && (loose = new File(dir, file.getRelativeSourcePath())).exists()) {
            result = dir;
        }
        return result;
    }

    private String getDefaultMediaPath() {
        String result = null;
        try {
            URI uri;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            if (codeSource != null && "file".equals((uri = codeSource.getLocation().toURI()).getScheme())) {
                File dir = new File(uri.getSchemeSpecificPart()).getAbsoluteFile();
                if (dir.getName().endsWith(".jar")) {
                    dir = dir.getParentFile();
                }
                result = dir.getPath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (result == null) {
            result = System.getProperty("user.dir");
        }
        return result;
    }
}

