/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import com.izforge.izpack.util.FileExecutor;

public class JDKChecker
implements RequirementChecker {
    private final AutomatedInstallData installData;
    private final Prompt prompt;

    public JDKChecker(AutomatedInstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    @Override
    public boolean check() {
        boolean result = !this.installData.getInfo().isJdkRequired() || this.exists() || this.notFound();
        return result;
    }

    protected boolean exists() {
        FileExecutor exec = new FileExecutor();
        String[] output = new String[2];
        String[] params = new String[]{"javac", "-help"};
        return exec.executeCommand(params, output) == 0;
    }

    protected boolean notFound() {
        String message = "It looks like your system does not have a Java Development Kit (JDK) available.\nThe software that you plan to install requires a JDK for both its installation and execution.\n\nDo you still want to proceed with the installation process?";
        Prompt.Option selected = this.prompt.confirm(Prompt.Type.WARNING, message, Prompt.Options.YES_NO);
        return selected == Prompt.Option.YES;
    }
}

