/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;

public class JavaVersionChecker
implements RequirementChecker {
    private final AutomatedInstallData installData;
    private final Prompt prompt;

    public JavaVersionChecker(AutomatedInstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    @Override
    public boolean check() {
        boolean result;
        String version = this.getJavaVersion();
        String required = this.installData.getInfo().getJavaVersion();
        boolean bl = result = required == null || version == null || version.compareTo(required) >= 0;
        if (!result) {
            this.versionNotAvailable(version, required);
        }
        return result;
    }

    protected void versionNotAvailable(String version, String requiredVersion) {
        this.prompt.message(Prompt.Type.ERROR, this.getVersionNotAvailable(version, requiredVersion));
    }

    protected String getVersionNotAvailable(String version, String requiredVersion) {
        StringBuilder msg = new StringBuilder();
        msg.append("The application that you are trying to install requires a ");
        msg.append(requiredVersion);
        msg.append(" version or later of the Java platform.\n");
        msg.append("You are running a ");
        msg.append(version);
        msg.append(" version of the Java platform.\n");
        msg.append("Please upgrade to a newer version.");
        return msg.toString();
    }

    protected String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

