/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;

public class LooseFileUnpacker
extends FileUnpacker {
    private final File sourceDir;
    private static final Logger logger = Logger.getLogger(LooseFileUnpacker.class.getName());

    public LooseFileUnpacker(File sourceDir, Cancellable cancellable, AbstractUIProgressHandler handler, FileQueue queue, Platform platform, Librarian librarian) {
        super(cancellable, handler, queue, platform, librarian);
        this.sourceDir = sourceDir;
    }

    @Override
    public FileQueue unpack(PackFile file, ObjectInputStream packInputStream, File target) throws IOException, InstallerException {
        FileQueue queue = this.getQueue();
        File resolvedFile = new File(this.sourceDir, file.getRelativeSourcePath());
        if (!resolvedFile.exists()) {
            File userDir = new File(System.getProperty("user.dir"));
            resolvedFile = new File(userDir, file.getRelativeSourcePath());
        }
        if (resolvedFile.exists()) {
            FileInputStream stream = new FileInputStream(resolvedFile);
            file = new PackFile(resolvedFile.getParentFile(), resolvedFile, file.getTargetPath(), file.osConstraints(), file.override(), file.overrideRenameTo(), file.blockable(), file.getAdditionals());
            queue = this.copy(file, stream, target);
        } else {
            logger.warning("Could not find loosely bundled file: " + file.getRelativeSourcePath());
            if (!this.getHandler().emitWarning("File not found", "Could not find loosely bundled file: " + file.getRelativeSourcePath())) {
                throw new InstallerException("Installation cancelled");
            }
        }
        return queue;
    }
}

