/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.DefaultFileUnpacker;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.installer.unpacker.LooseFileUnpacker;
import com.izforge.izpack.installer.unpacker.Pack200FileUnpacker;
import com.izforge.izpack.installer.unpacker.ScriptParser;
import com.izforge.izpack.installer.web.WebAccessor;
import com.izforge.izpack.installer.web.WebRepositoryAccessor;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.os.FileQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.Pack200;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UnpackerBase
implements IUnpacker {
    private final AutomatedInstallData installData;
    private final UninstallData uninstallData;
    private final Resources resources;
    private final RulesEngine rules;
    private final VariableSubstitutor variableSubstitutor;
    private final Platform platform;
    private final Librarian librarian;
    private final Housekeeper housekeeper;
    private final InstallerListeners listeners;
    private AbstractUIProgressHandler handler;
    private File absoluteInstallSource;
    private Pack200.Unpacker unpacker;
    private boolean result = true;
    private final Cancellable cancellable;
    private State state = State.READY;
    private boolean disableInterrupt = false;
    private static final Logger logger = Logger.getLogger(UnpackerBase.class.getName());
    private static final String tempSubPath = "/IzpackWebTemp";

    public UnpackerBase(AutomatedInstallData installData, Resources resources, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData uninstallData, Platform platform, Librarian librarian, Housekeeper housekeeper, InstallerListeners listeners) {
        this.installData = installData;
        this.resources = resources;
        this.rules = rules;
        this.variableSubstitutor = variableSubstitutor;
        this.uninstallData = uninstallData;
        this.platform = platform;
        this.librarian = librarian;
        this.housekeeper = housekeeper;
        this.listeners = listeners;
        this.cancellable = new Cancellable(){

            @Override
            public boolean isCancelled() {
                return UnpackerBase.this.isInterrupted();
            }
        };
    }

    @Override
    public void setHandler(AbstractUIProgressHandler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        this.unpack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack() {
        this.state = State.UNPACKING;
        try {
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
            this.preUnpack();
            FileQueue queue = this.unpack(parsables, executables, updateChecks);
            this.postUnpack(queue, parsables, executables, updateChecks);
        }
        catch (Exception exception) {
            this.setResult(false);
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            AbstractUIProgressHandler handler = this.getHandler();
            handler.stopAction();
            String message = exception.getMessage();
            if ("Installation cancelled".equals(message)) {
                handler.emitNotification("Installation cancelled");
            } else {
                if (message == null || "".equals(message)) {
                    message = "Internal error occurred : " + exception.toString();
                }
                handler.emitError("An error occurred", message);
            }
            this.housekeeper.shutDown(4);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interrupt(long timeout) {
        boolean result;
        if (this.isInterruptDisabled()) {
            result = false;
        } else {
            UnpackerBase unpackerBase = this;
            synchronized (unpackerBase) {
                if (this.state != State.INTERRUPTED) {
                    this.state = State.INTERRUPT;
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                result = this.state == State.INTERRUPTED;
            }
        }
        return result;
    }

    @Override
    public synchronized void setDisableInterrupt(boolean disable) {
        if (this.state == State.INTERRUPT || this.state == State.INTERRUPTED) {
            throw new IllegalStateException("Cannot disable interrupts. Unpacking has already been interrupted");
        }
        this.disableInterrupt = disable;
    }

    @Override
    public synchronized boolean isInterruptDisabled() {
        return this.disableInterrupt;
    }

    protected void preUnpack() throws Exception {
        AutomatedInstallData installData = this.getInstallData();
        AbstractUIProgressHandler handler = this.getHandler();
        int count = installData.getSelectedPacks().size();
        logger.fine("Unpacker starting");
        handler.startAction("Unpacking", count);
        this.listeners.beforePacks(installData, count, handler);
    }

    protected FileQueue unpack(List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) throws Exception {
        FileQueue queue = null;
        List<Pack> packs = this.getInstallData().getSelectedPacks();
        int count = packs.size();
        for (int i = 0; i < count; ++i) {
            Pack pack = packs.get(i);
            if (!this.shouldUnpack(pack)) continue;
            this.listeners.beforePack(pack, i, this.handler);
            queue = this.unpack(pack, i, queue, parsables, executables, updateChecks);
            if (this.isInterrupted()) break;
            this.listeners.afterPack(pack, i, this.handler);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileQueue unpack(Pack pack, int packNo, FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) throws Exception {
        InputStream in = null;
        ObjectInputStream packInputStream = null;
        try {
            in = this.getPackStream(pack.getName(), pack.isUninstall());
            packInputStream = new ObjectInputStream(in);
            int fileCount = packInputStream.readInt();
            AbstractUIProgressHandler handler = this.getHandler();
            String stepName = this.getStepName(pack);
            handler.nextStep(stepName, packNo + 1, fileCount);
            for (int i = 0; i < fileCount; ++i) {
                PackFile file = (PackFile)packInputStream.readObject();
                if (file.hasCondition() && !this.isConditionTrue(file.getCondition()) || !OsConstraintHelper.oneMatchesCurrentSystem(file.osConstraints())) {
                    this.skip(file, pack, packInputStream);
                    continue;
                }
                queue = this.unpack(file, packInputStream, i, pack, queue);
            }
            this.readParsableFiles(packInputStream, parsables);
            this.readExecutableFiles(packInputStream, executables);
            this.readUpdateChecks(packInputStream, updateChecks);
        }
        catch (Throwable throwable) {
            FileUtils.close(packInputStream);
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close(packInputStream);
        FileUtils.close(in);
        return queue;
    }

    protected FileQueue unpack(PackFile file, ObjectInputStream packInputStream, int fileNo, Pack pack, FileQueue queue) throws Exception {
        File target;
        Variables variables = this.getInstallData().getVariables();
        String path = IoHelper.translatePath(file.getTargetPath(), variables);
        File dir = target = new File(path);
        if (!file.isDirectory()) {
            dir = target.getParentFile();
        }
        this.createDirectory(dir, file);
        this.getUninstallData().addFile(path, pack.isUninstall());
        if (file.isDirectory()) {
            return queue;
        }
        this.listeners.beforeFile(target, file);
        AbstractUIProgressHandler handler = this.getHandler();
        handler.progress(fileNo, path);
        if (target.exists() && file.override() != OverrideType.OVERRIDE_TRUE && !this.isOverwriteFile(file, target)) {
            if (!file.isBackReference() && !pack.isLoose()) {
                if (file.isPack200Jar()) {
                    this.skip(packInputStream, 4L);
                } else {
                    this.skip(packInputStream, file.length());
                }
            }
            return queue;
        }
        this.handleOverrideRename(file, target);
        queue = this.extract(file, target, packInputStream, pack, queue);
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileQueue extract(PackFile file, File target, ObjectInputStream packInputStream, Pack pack, FileQueue queue) throws Exception {
        InputStream in;
        ObjectInputStream packStream;
        block8: {
            FileUnpacker unpacker;
            block7: {
                FileQueue fileQueue;
                packStream = packInputStream;
                in = null;
                try {
                    if (!pack.isLoose() && file.isBackReference()) {
                        in = this.getPackStream(file.previousPackId, pack.isUninstall());
                        packStream = new ObjectInputStream(in);
                        this.skip(in, file.offsetInPreviousPack - 4L);
                    }
                    unpacker = this.createFileUnpacker(file, pack, queue, this.cancellable);
                    unpacker.unpack(file, packStream, target);
                    if (!this.isInterrupted()) break block7;
                    fileQueue = queue;
                }
                catch (Throwable throwable) {
                    FileUtils.close(in);
                    if (packStream != packInputStream) {
                        FileUtils.close(packStream);
                    }
                    throw throwable;
                }
                FileUtils.close(in);
                if (packStream != packInputStream) {
                    FileUtils.close(packStream);
                }
                return fileQueue;
            }
            if (unpacker.isQueued()) break block8;
            this.listeners.afterFile(target, file);
        }
        FileUtils.close(in);
        if (packStream != packInputStream) {
            FileUtils.close(packStream);
        }
        return queue;
    }

    protected void skip(PackFile file, Pack pack, ObjectInputStream packInputStream) throws IOException {
        if (!pack.isLoose() && !file.isBackReference()) {
            this.skip(packInputStream, file.length());
        }
    }

    protected FileUnpacker createFileUnpacker(PackFile file, Pack pack, FileQueue queue, Cancellable cancellable) throws IOException, InstallerException {
        FileUnpacker unpacker = pack.isLoose() ? new LooseFileUnpacker(this.getAbsoluteInstallSource(), cancellable, this.handler, queue, this.platform, this.librarian) : (file.isPack200Jar() ? new Pack200FileUnpacker(cancellable, this.handler, this.resources, this.getPack200Unpacker(), queue, this.platform, this.librarian) : new DefaultFileUnpacker(cancellable, this.handler, queue, this.platform, this.librarian));
        return unpacker;
    }

    protected void postUnpack(FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) throws Exception {
        AutomatedInstallData installData = this.getInstallData();
        AbstractUIProgressHandler handler = this.getHandler();
        if (queue != null) {
            queue.execute();
            installData.setRebootNecessary(queue.isRebootNecessary());
        }
        if (this.isInterrupted()) {
            return;
        }
        this.parseFiles(parsables);
        if (this.isInterrupted()) {
            return;
        }
        if (!this.executeFiles(executables) || this.isInterrupted()) {
            return;
        }
        this.performUpdateChecks(updateChecks);
        if (this.isInterrupted()) {
            return;
        }
        this.listeners.afterPacks(installData, handler);
        if (this.isInterrupted()) {
            return;
        }
        this.writeInstallationInformation();
        handler.stopAction();
    }

    protected void cleanup() {
        this.state = State.READY;
    }

    protected AutomatedInstallData getInstallData() {
        return this.installData;
    }

    protected UninstallData getUninstallData() {
        return this.uninstallData;
    }

    protected Resources getResources() {
        return this.resources;
    }

    protected VariableSubstitutor getVariableSubstitutor() {
        return this.variableSubstitutor;
    }

    protected AbstractUIProgressHandler getHandler() {
        return this.handler;
    }

    protected Platform getPlatform() {
        return this.platform;
    }

    protected Librarian getLibrarian() {
        return this.librarian;
    }

    protected boolean shouldUnpack(Pack pack) {
        boolean result = true;
        if (pack.hasCondition()) {
            result = this.rules.isConditionTrue(pack.getCondition());
        }
        return result;
    }

    protected void setResult(boolean result) {
        this.result = result;
    }

    protected boolean isConditionTrue(String id) {
        return this.rules.isConditionTrue(id);
    }

    protected String getStepName(Pack pack) {
        String result = pack.getName();
        if (pack.isHidden()) {
            result = "";
        } else if (pack.getLangPackId() != null && this.installData.getMessages() != null) {
            String id = this.installData.getMessages().get(pack.getLangPackId(), new Object[0]);
            if (!pack.getLangPackId().equals(id)) {
                result = id;
            }
        }
        return result;
    }

    protected InputStream getPackStream(String name, boolean uninstall) throws Exception {
        InputStream in;
        String webDirURL = this.installData.getInfo().getWebDirURL();
        name = "-" + name;
        if (webDirURL == null) {
            in = this.resources.getInputStream("packs/pack" + name);
        } else {
            String tempFile;
            String baseName = this.installData.getInfo().getInstallerBase();
            String packURL = webDirURL + "/" + baseName + ".pack" + name + ".jar";
            String tempFolder = IoHelper.translatePath(this.installData.getInfo().getUninstallerPath() + tempSubPath, this.installData.getVariables());
            try {
                tempFile = WebRepositoryAccessor.getCachedUrl(packURL, tempFolder);
                this.uninstallData.addFile(tempFile, uninstall);
            }
            catch (Exception e) {
                if ("Cancelled".equals(e.getMessage())) {
                    throw new InstallerException("Installation cancelled", e);
                }
                throw new InstallerException("Installation failed", e);
            }
            URL url = new URL("jar:" + tempFile + "!/packs/pack" + name);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(url.toString() + " not available", new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.installData.getInfo().getPackDecoderClassName() != null) {
            BufferedInputStream buffer;
            Object[] params;
            Class[] paramsClasses;
            Class<?> decoder = Class.forName(this.installData.getInfo().getPackDecoderClassName());
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses = new Class[]{Class.forName("java.io.InputStream")});
            Object instance = constructor.newInstance(params = new Object[]{buffer = new BufferedInputStream(in)});
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.installData.getInfo().getPackDecoderClassName() + "' must be derived from " + InputStream.class.toString());
            }
            in = (InputStream)instance;
        }
        return in;
    }

    protected boolean createDirectory(File dir, PackFile file) throws Exception {
        boolean ok = true;
        if (!dir.exists()) {
            if (!this.listeners.isFileListener()) {
                if (!dir.mkdirs()) {
                    this.handler.emitError("Error creating directories", "Could not create directory\n" + dir.getPath());
                    this.handler.stopAction();
                    this.result = false;
                }
            } else {
                File parent = dir.getParentFile();
                if (parent != null) {
                    ok = this.createDirectory(parent, file);
                }
                if (ok) {
                    this.listeners.beforeDir(dir, file);
                    ok = dir.mkdir();
                    if (!ok) {
                        this.handler.emitError("Error creating directories", "Could not create directory\n" + dir);
                        this.handler.stopAction();
                    } else {
                        this.listeners.afterDir(dir, file);
                    }
                }
            }
        } else {
            ok = true;
        }
        return ok;
    }

    private void parseFiles(List<ParsableFile> files) throws Exception {
        if (!files.isEmpty()) {
            ScriptParser parser = new ScriptParser(this.getVariableSubstitutor());
            for (ParsableFile file : files) {
                parser.parse(file);
                if (!this.isInterrupted()) continue;
                return;
            }
        }
    }

    private boolean executeFiles(List<ExecutableFile> executables) {
        FileExecutor executor;
        boolean result = true;
        if (!executables.isEmpty() && (executor = new FileExecutor(executables)).executeFiles(0, this.handler) != 0) {
            result = false;
            this.setResult(false);
        }
        return result;
    }

    protected synchronized boolean isInterrupted() {
        boolean result = false;
        if (this.state == State.INTERRUPT) {
            this.setResult(false);
            this.state = State.INTERRUPTED;
            result = true;
            this.notifyAll();
        } else if (this.state == State.INTERRUPTED) {
            result = true;
        }
        return result;
    }

    protected void performUpdateChecks(List<UpdateCheck> checks) {
        if (checks != null && !checks.isEmpty()) {
            File absoluteInstallPath = new File(this.installData.getInstallPath()).getAbsoluteFile();
            FileSet fileset = new FileSet();
            ArrayList<File> filesToDelete = new ArrayList<File>();
            ArrayList<File> dirsToDelete = new ArrayList<File>();
            try {
                fileset.setDir(absoluteInstallPath);
                for (UpdateCheck check : checks) {
                    if (check.includesList != null) {
                        for (String include : check.includesList) {
                            fileset.createInclude().setName(this.variableSubstitutor.substitute(include));
                        }
                    }
                    if (check.excludesList == null) continue;
                    for (String exclude : check.excludesList) {
                        fileset.createExclude().setName(this.variableSubstitutor.substitute(exclude));
                    }
                }
                DirectoryScanner scanner = fileset.getDirectoryScanner();
                scanner.scan();
                String[] srcFiles = scanner.getIncludedFiles();
                String[] srcDirs = scanner.getIncludedDirectories();
                TreeSet<File> installedFiles = new TreeSet<File>();
                for (String name : this.uninstallData.getInstalledFilesList()) {
                    File file = new File(name);
                    if (!file.isAbsolute()) {
                        file = new File(absoluteInstallPath, name);
                    }
                    installedFiles.add(file);
                }
                for (String srcFile : srcFiles) {
                    File newFile = new File(scanner.getBasedir(), srcFile);
                    if (installedFiles.contains(newFile)) continue;
                    filesToDelete.add(newFile);
                }
                for (String srcDir : srcDirs) {
                    File newDir = new File(scanner.getBasedir(), srcDir);
                    if (installedFiles.contains(newDir)) continue;
                    dirsToDelete.add(newDir);
                }
            }
            catch (Exception e) {
                this.handler.emitError("Error while performing update checks", e.getMessage());
            }
            for (File f : filesToDelete) {
                if (f.delete()) continue;
                logger.warning("Failed to delete: " + f);
            }
            for (File d : dirsToDelete) {
                if (d.delete()) continue;
                logger.warning("Failed to delete: " + d);
            }
        }
    }

    protected void writeInstallationInformation() throws IOException, ClassNotFoundException {
        if (!this.installData.getInfo().isWriteInstallationInformation()) {
            logger.fine("Skip writing installation information");
            return;
        }
        logger.fine("Writing installation information");
        String installDir = this.installData.getInstallPath();
        ArrayList<Pack> installedPacks = new ArrayList<Pack>(this.installData.getSelectedPacks());
        File installationInfo = new File(installDir + File.separator + ".installationinformation");
        if (!installationInfo.exists()) {
            logger.fine("Creating info file" + installationInfo.getAbsolutePath());
            File dir = new File(this.installData.getInstallPath());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Failed to create directory: " + dir);
            }
            if (!installationInfo.createNewFile()) {
                throw new IOException("Failed to create file: " + installationInfo);
            }
        } else {
            logger.fine("Previous installation information found");
            FileInputStream fin = new FileInputStream(installationInfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            List packs = (List)oin.readObject();
            for (Pack pack : packs) {
                installedPacks.add(pack);
            }
            oin.close();
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(installationInfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedPacks);
        oout.writeObject(this.installData.getVariables().getProperties());
        logger.fine("Writing installation information finished");
        oout.close();
        fout.close();
    }

    protected File getAbsoluteInstallSource() throws IOException, InstallerException {
        if (this.absoluteInstallSource == null) {
            URI uri;
            try {
                uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (URISyntaxException exception) {
                throw new InstallerException(exception);
            }
            if (!"file".equals(uri.getScheme())) {
                throw new InstallerException("Unexpected scheme in JAR file URI: " + uri);
            }
            this.absoluteInstallSource = new File(uri.getSchemeSpecificPart()).getAbsoluteFile();
            if (this.absoluteInstallSource.getName().endsWith(".jar")) {
                this.absoluteInstallSource = this.absoluteInstallSource.getParentFile();
            }
        }
        return this.absoluteInstallSource;
    }

    protected void skip(InputStream stream, long bytes) throws IOException {
        long skipped = stream.skip(bytes);
        if (skipped != bytes) {
            throw new IOException("Expected to skip: " + bytes + " in stream but skipped: " + skipped);
        }
    }

    protected boolean isOverwriteFile(PackFile pf, File file) {
        boolean result = false;
        if (pf.override() != OverrideType.OVERRIDE_FALSE) {
            if (pf.override() == OverrideType.OVERRIDE_TRUE) {
                result = true;
            } else if (pf.override() == OverrideType.OVERRIDE_UPDATE) {
                result = file.lastModified() < pf.lastModified();
            } else {
                Messages messages;
                int answer;
                int def_choice = -1;
                if (pf.override() == OverrideType.OVERRIDE_ASK_FALSE) {
                    def_choice = 49;
                }
                if (pf.override() == OverrideType.OVERRIDE_ASK_TRUE) {
                    def_choice = 47;
                }
                result = (answer = this.handler.askQuestion((messages = this.installData.getMessages()).get("InstallPanel.overwrite.title", new Object[0]) + " - " + file.getName(), messages.get("InstallPanel.overwrite.question", new Object[0]) + file.getAbsolutePath(), 37, def_choice)) == 47;
            }
        }
        return result;
    }

    protected void handleOverrideRename(PackFile pf, File file) {
        if (file.exists() && pf.overrideRenameTo() != null) {
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*");
            mapper.setTo(pf.overrideRenameTo());
            mapper.setCaseSensitive(true);
            String[] newFileNameArr = mapper.mapFileName(file.getName());
            if (newFileNameArr != null) {
                String newFileName = newFileNameArr[0];
                File newPathFile = new File(file.getParent(), newFileName);
                if (newPathFile.exists() && !newPathFile.delete()) {
                    logger.warning("Failed to delete: " + newPathFile);
                }
                if (!file.renameTo(newPathFile)) {
                    this.handler.emitError("Error renaming file", "The file " + file + " could not be renamed to " + newPathFile);
                }
            } else {
                this.handler.emitError("Error renaming file", "File name " + file.getName() + " cannot be mapped using the expression \"" + pf.overrideRenameTo() + "\"");
            }
        }
    }

    protected void readParsableFiles(ObjectInputStream stream, List<ParsableFile> parsables) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            ParsableFile file = (ParsableFile)stream.readObject();
            if (file.hasCondition() && !this.isConditionTrue(file.getCondition())) continue;
            file.path = IoHelper.translatePath(file.path, this.installData.getVariables());
            parsables.add(file);
        }
    }

    protected void readExecutableFiles(ObjectInputStream stream, List<ExecutableFile> executables) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            ExecutableFile file = (ExecutableFile)stream.readObject();
            if (file.hasCondition() && !this.isConditionTrue(file.getCondition())) continue;
            Variables variables = this.installData.getVariables();
            file.path = IoHelper.translatePath(file.path, variables);
            if (null != file.argList && !file.argList.isEmpty()) {
                for (int j = 0; j < file.argList.size(); ++j) {
                    String arg = file.argList.get(j);
                    arg = IoHelper.translatePath(arg, variables);
                    file.argList.set(j, arg);
                }
            }
            executables.add(file);
            if (file.executionStage != 2) continue;
            this.uninstallData.addExecutable(file);
        }
    }

    protected void readUpdateChecks(ObjectInputStream stream, List<UpdateCheck> updateChecks) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            UpdateCheck check = (UpdateCheck)stream.readObject();
            updateChecks.add(check);
        }
    }

    private Pack200.Unpacker getPack200Unpacker() {
        if (this.unpacker == null) {
            this.unpacker = Pack200.newUnpacker();
        }
        return this.unpacker;
    }

    private synchronized boolean shouldInterrupt() {
        return this.state == State.INTERRUPT || this.state == State.INTERRUPTED;
    }

    private static enum State {
        READY,
        UNPACKING,
        INTERRUPT,
        INTERRUPTED;

    }
}

