/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.finish;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.AutomatedInstallScriptFilter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    private UninstallDataWriter uninstallDataWriter;
    private final Log log;

    public FinishPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, parent, installData, new GridBagLayout(), resources);
        this.uninstallDataWriter = uninstallDataWriter;
        this.log = log;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        Insets inset = new Insets(10, 20, 2, 2);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 10, inset, 0, 0);
        if (this.installData.isInstallSuccess()) {
            JLabel jLabel = LabelFactory.create(this.getString("FinishPanel.success"), (Icon)this.parent.getIcons().get("preferences"), 10);
            jLabel.setName(GuiId.FINISH_PANEL_LABEL.id);
            this.add((Component)jLabel, constraints);
            ++constraints.gridy;
            if (this.uninstallDataWriter.isUninstallRequired()) {
                String path = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.add((Component)LabelFactory.create(this.getString("FinishPanel.uninst.info"), (Icon)this.parent.getIcons().get("preferences"), 10), constraints);
                ++constraints.gridy;
                this.add((Component)LabelFactory.create(path, (Icon)this.parent.getIcons().get("empty"), 10), constraints);
                ++constraints.gridy;
            }
            this.autoButton = ButtonFactory.createButton(this.getString("FinishPanel.auto"), (Icon)this.parent.getIcons().get("edit"), this.installData.buttonsHColor);
            this.autoButton.setName(GuiId.FINISH_PANEL_AUTO_BUTTON.id);
            this.autoButton.setToolTipText(this.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener(this);
            this.add((Component)this.autoButton, constraints);
            ++constraints.gridy;
        } else {
            this.add((Component)LabelFactory.create(this.getString("FinishPanel.fail"), (Icon)this.parent.getIcons().get("stop"), 10), constraints);
        }
        this.getLayoutHelper().completeLayout();
        this.log.informUser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setName(GuiId.FINISH_PANEL_FILE_CHOOSER.id);
        fileChooser.setCurrentDirectory(new File(this.installData.getInstallPath()));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(new AutomatedInstallScriptFilter(this.installData.getMessages()));
        try {
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                this.parent.writeXMLTree(this.installData.getXmlData(), outBuff);
                outBuff.flush();
                outBuff.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(this, err.toString(), this.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String destination) {
        destination = this.installData.getVariables().replace(destination);
        return destination.replace('/', File.separatorChar);
    }
}

