/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.userinput.FileInputField;
import com.izforge.izpack.panels.userinput.validator.ValidatorContainer;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public class DirInputField
extends FileInputField {
    private static final long serialVersionUID = 8494549823214831160L;
    private static final transient Logger logger = Logger.getLogger(DirInputField.class.getName());
    private final boolean mustExist;
    private final boolean canCreate;

    public DirInputField(IzPanel parent, GUIInstallData installDataGUI, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, boolean mustExist, boolean canCreate) {
        super(parent, installDataGUI, directory, set, size, validatorConfig, null, null);
        this.mustExist = mustExist;
        this.canCreate = canCreate;
    }

    @Override
    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(1);
    }

    @Override
    protected boolean _validate(File dir) {
        System.err.println(dir.getAbsolutePath() + " - isDir: " + dir.isDirectory() + " - mustExist: " + this.mustExist + " - canCreate: " + this.canCreate);
        if (dir.isDirectory()) {
            return true;
        }
        if (this.mustExist) {
            return false;
        }
        if (this.canCreate) {
            return this.verifyCreateOK(dir);
        }
        return true;
    }

    @Override
    protected void showMessage(int k) {
        if (k == 0) {
            this.showMessage("dir.notdirectory");
        } else if (k == 1) {
            this.showMessage("dir.nodirectory");
        }
    }

    private boolean verifyCreateOK(File path) {
        if (!path.exists() && !this.parent.emitNotificationFeedback(this.parent.getI18nStringForClass("createdir", "TargetPanel") + "\n" + path.getAbsolutePath())) {
            return false;
        }
        if (!DirInputField.isWriteable(path)) {
            this.parent.emitError(this.parentFrame.getMessages().get("installer.error", new Object[0]), this.parent.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        return path.mkdirs();
    }

    private static boolean isWriteable(File path) {
        File existParent = IoHelper.existingParent(path);
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }
}

