/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

public class Platform {
    private final Name name;
    private final String symbolicName;
    private final Arch arch;
    private final String version;

    public Platform(Name name) {
        this(name, (String)null);
    }

    public Platform(Name name, String version) {
        this(name, null, version);
    }

    public Platform(Name name, String symbolicName, String version) {
        this(name, symbolicName, version, null);
    }

    public Platform(Name name, Arch arch) {
        this(name, null, arch);
    }

    public Platform(Name name, String symbolicName, Arch arch) {
        this(name, symbolicName, null, arch);
    }

    public Platform(Name name, String symbolicName, String version, Arch arch) {
        if (symbolicName != null && (symbolicName.indexOf(32) > 0 || symbolicName.indexOf(44) > 0)) {
            throw new IllegalArgumentException("Argument 'symbolicName' should not contain spaces or commas");
        }
        this.name = name;
        this.symbolicName = symbolicName;
        this.version = version;
        this.arch = arch != null ? arch : Arch.UNKNOWN;
    }

    public Platform(Platform platform, Arch arch) {
        this(platform.name, platform.symbolicName, platform.version, arch);
    }

    public Name getName() {
        return this.name;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public Arch getArch() {
        return this.arch;
    }

    public boolean isA(Platform platform) {
        boolean result = false;
        if (this.isA(platform.name) && this.hasSymbolicName(platform.symbolicName) && this.hasArch(platform.arch) && this.hasVersion(platform.version)) {
            result = true;
        }
        return result;
    }

    public boolean isA(Name name) {
        return this.isA(this.name, name);
    }

    public boolean isA(Arch arch) {
        return this.arch == arch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Platform) {
            Platform p = (Platform)other;
            if (this.name == p.name && this.arch == p.arch && (this.version == null && p.version == null || this.version != null && this.version.equals(p.version))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.name.hashCode() ^ this.arch.hashCode();
        if (this.version != null) {
            hash ^= this.version.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.name.toString().toLowerCase() + ",version=" + this.version + ",arch=" + this.arch.toString().toLowerCase() + ",symbolicName=" + this.symbolicName;
    }

    private boolean isA(Name current, Name name) {
        if (name == current) {
            return true;
        }
        for (Name parent : current.getParents()) {
            if (!this.isA(parent, name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSymbolicName(String other) {
        return other == null || this.symbolicName != null && this.symbolicName.equals(other);
    }

    private boolean hasArch(Arch other) {
        return this.arch == other || other == Arch.UNKNOWN;
    }

    private boolean hasVersion(String other) {
        return other == null || this.version != null && this.version.equals(other);
    }

    public static enum Arch {
        X86,
        X64,
        PPC,
        SPARC,
        UNKNOWN;

    }

    public static enum Name {
        UNIX,
        LINUX(UNIX),
        AIX(UNIX),
        DEBIAN_LINUX(LINUX),
        FEDORA_LINUX(LINUX),
        FREEBSD(UNIX),
        HP_UX(UNIX),
        MAC,
        MAC_OSX(MAC, UNIX),
        MANDRAKE_LINUX(LINUX),
        MANDRIVA_LINUX(LINUX),
        OS_2,
        RED_HAT_LINUX(LINUX),
        SUNOS(UNIX),
        SUSE_LINUX(LINUX),
        UBUNTU_LINUX(LINUX),
        WINDOWS,
        UNKNOWN;

        private final Name[] parents;

        private Name() {
            this.parents = new Name[0];
        }

        private Name(Name ... parents) {
            this.parents = parents;
        }

        public Name[] getParents() {
            return this.parents;
        }
    }
}

