/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Platforms {
    public static Platform AIX = new Platform(Platform.Name.AIX);
    public static Platform DEBIAN_LINUX = new Platform(Platform.Name.DEBIAN_LINUX);
    public static Platform FEDORA_LINUX = new Platform(Platform.Name.FEDORA_LINUX);
    public static Platform FREEBSD = new Platform(Platform.Name.FREEBSD);
    public static Platform HP_UX = new Platform(Platform.Name.HP_UX);
    public static Platform LINUX = new Platform(Platform.Name.LINUX);
    public static Platform MAC = new Platform(Platform.Name.MAC);
    public static Platform MAC_OSX = new Platform(Platform.Name.MAC_OSX);
    public static Platform MANDRAKE_LINUX = new Platform(Platform.Name.MANDRAKE_LINUX);
    public static Platform MANDRIVA_LINUX = new Platform(Platform.Name.MANDRIVA_LINUX);
    public static Platform OS_2 = new Platform(Platform.Name.OS_2);
    public static Platform RED_HAT_LINUX = new Platform(Platform.Name.RED_HAT_LINUX);
    public static Platform SUNOS = new Platform(Platform.Name.SUNOS);
    public static Platform SUNOS_X86 = new Platform(Platform.Name.SUNOS, "SUNOS_X86", Platform.Arch.X86);
    public static Platform SUNOS_SPARC = new Platform(Platform.Name.SUNOS, "SUNOS_SPARC", Platform.Arch.SPARC);
    public static Platform SUSE_LINUX = new Platform(Platform.Name.SUSE_LINUX);
    public static Platform UNIX = new Platform(Platform.Name.UNIX);
    public static Platform UBUNTU_LINUX = new Platform(Platform.Name.UBUNTU_LINUX);
    public static Platform WINDOWS = new Platform(Platform.Name.WINDOWS);
    public static Platform WINDOWS_XP = new Platform(Platform.Name.WINDOWS, "WINDOWS_XP", "5.1");
    public static Platform WINDOWS_2003 = new Platform(Platform.Name.WINDOWS, "WINDOWS_2003", "5.2");
    public static Platform WINDOWS_VISTA = new Platform(Platform.Name.WINDOWS, "WINDOWS_VISTA", "6.0");
    public static Platform WINDOWS_7 = new Platform(Platform.Name.WINDOWS, "WINDOWS_7", "6.1");
    public static Platform[] PLATFORMS = new Platform[]{AIX, DEBIAN_LINUX, FEDORA_LINUX, FREEBSD, HP_UX, LINUX, MAC, MAC_OSX, MANDRAKE_LINUX, MANDRIVA_LINUX, OS_2, RED_HAT_LINUX, SUNOS, SUNOS_X86, SUNOS_SPARC, SUSE_LINUX, UBUNTU_LINUX, UNIX, WINDOWS, WINDOWS_XP, WINDOWS_2003, WINDOWS_VISTA, WINDOWS_7};
    private static final Logger log = Logger.getLogger(Platforms.class.getName());

    public Platform getCurrentPlatform() {
        return this.getCurrentPlatform(System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));
    }

    public Platform getCurrentPlatform(String name, String arch) {
        return this.getCurrentPlatform(name, arch, null);
    }

    public Platform getCurrentPlatform(String name, String arch, String version) {
        Platform.Name pname = this.getCurrentName(name);
        Platform.Arch parch = this.getArch(arch);
        Platform match = this.findMatch(name, pname, parch, version);
        Platform result = this.getPlatform(match, parch, version);
        return result;
    }

    public Platform getPlatform(String name, String arch) {
        return this.getPlatform(name, arch, null);
    }

    public Platform getPlatform(String name, String arch, String version) {
        Platform.Name pname = this.getName(name);
        Platform.Arch parch = this.getArch(arch);
        Platform match = this.findMatch(name, pname, parch, version);
        Platform result = this.getPlatform(match, parch, version);
        return result;
    }

    protected Platform getPlatform(Platform match, Platform.Arch arch, String version) {
        Platform result;
        if (match != null) {
            if (arch == Platform.Arch.UNKNOWN) {
                arch = match.getArch();
            }
            if (version == null) {
                version = match.getVersion();
            }
            result = new Platform(match.getName(), match.getSymbolicName(), version, arch);
        } else {
            result = new Platform(Platform.Name.UNKNOWN, null, version, arch);
        }
        return result;
    }

    protected Platform findMatch(String name, Platform.Name pname, Platform.Arch arch, String version) {
        Platform best = null;
        int bestMatches = 0;
        for (Platform platform : PLATFORMS) {
            if ((pname != Platform.Name.UNKNOWN || !this.equals(name, platform.getSymbolicName(), true)) && (pname == Platform.Name.UNKNOWN || pname != platform.getName())) continue;
            int currentMatches = 0;
            boolean archMatch = arch == platform.getArch();
            boolean optArchMatch = platform.getArch() == Platform.Arch.UNKNOWN;
            boolean versionMatch = version != null && this.equals(version, platform.getVersion());
            boolean optVersionMatch = platform.getVersion() == null;
            boolean symbolicMatch = this.equals(name, platform.getSymbolicName(), true);
            if (archMatch) {
                currentMatches += 2;
            } else if (optArchMatch) {
                ++currentMatches;
            }
            if (symbolicMatch) {
                currentMatches += 2;
            }
            if (versionMatch) {
                currentMatches += 2;
            } else if (optVersionMatch) {
                ++currentMatches;
            }
            if (currentMatches <= bestMatches) continue;
            best = platform;
            if (currentMatches == 6) break;
            bestMatches = currentMatches;
        }
        return best;
    }

    protected Platform.Name getName(String name) {
        for (Platform platform : PLATFORMS) {
            String platformName = platform.getName().name();
            String symbolicName = platform.getSymbolicName();
            if (!platformName.equalsIgnoreCase(name) && (symbolicName == null || !symbolicName.equalsIgnoreCase(name))) continue;
            return platform.getName();
        }
        return Platform.Name.UNKNOWN;
    }

    protected Platform.Name getCurrentName(String name) {
        Platform.Name result;
        if (StringTool.startsWithIgnoreCase(name, "FreeBSD")) {
            result = Platform.Name.FREEBSD;
        } else if (StringTool.startsWithIgnoreCase(name, "Linux")) {
            result = this.getLinuxName();
        } else if (StringTool.startsWithIgnoreCase(name, "HP-UX")) {
            result = Platform.Name.HP_UX;
        } else if (StringTool.startsWithIgnoreCase(name, "AIX")) {
            result = Platform.Name.AIX;
        } else if (StringTool.startsWithIgnoreCase(name, "SunOS") || StringTool.startsWithIgnoreCase(name, "Solaris")) {
            result = Platform.Name.SUNOS;
        } else if (StringTool.startsWith(name, "OS/2")) {
            result = Platform.Name.OS_2;
        } else if (StringTool.startsWithIgnoreCase(name, "mac os x")) {
            result = Platform.Name.MAC_OSX;
        } else if (StringTool.startsWith(name, "Mac")) {
            result = Platform.Name.MAC;
        } else if (StringTool.startsWith(name, "Windows")) {
            result = Platform.Name.WINDOWS;
        } else {
            try {
                result = Platform.Name.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                result = Platform.Name.UNKNOWN;
            }
        }
        return result;
    }

    protected Platform.Name getLinuxName() {
        List<String> text;
        Platform.Name result = Platform.Name.LINUX;
        String path = this.getReleasePath();
        if (path != null && (text = this.getText(path)) != null) {
            if (this.search(text, "RedHat") || this.search(text, "Red Hat")) {
                result = Platform.Name.RED_HAT_LINUX;
            } else if (this.search(text, "Fedora")) {
                result = Platform.Name.FEDORA_LINUX;
            } else if (this.search(text, "Mandrake")) {
                result = Platform.Name.MANDRAKE_LINUX;
            } else if (this.search(text, "Mandriva")) {
                result = Platform.Name.MANDRIVA_LINUX;
            } else if (this.search(text, "SuSE", true)) {
                result = Platform.Name.SUSE_LINUX;
            }
        }
        if (result == Platform.Name.LINUX) {
            text = this.getText("/proc/version");
            if (text != null) {
                if (this.search(text, "Debian")) {
                    result = Platform.Name.DEBIAN_LINUX;
                } else if (this.search(text, "Ubuntu")) {
                    result = Platform.Name.UBUNTU_LINUX;
                }
            }
            if (result == Platform.Name.LINUX && this.exists("/etc/debian_version")) {
                result = Platform.Name.DEBIAN_LINUX;
            }
        }
        return result;
    }

    protected List<String> getText(String path) {
        List<String> text;
        block2: {
            text = null;
            try {
                text = FileUtil.getFileContent(path);
            }
            catch (IOException ignore) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Failed to read " + path, ignore);
            }
        }
        return text;
    }

    protected Platform.Arch getArch(String arch) {
        Platform.Arch result = null;
        if (arch != null) {
            try {
                result = Platform.Arch.valueOf(arch.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = StringTool.startsWithIgnoreCase(arch, "x86") || StringTool.startsWithIgnoreCase(arch, "i386") ? Platform.Arch.X86 : (StringTool.startsWithIgnoreCase(arch, "x64") || StringTool.startsWithIgnoreCase(arch, "amd64") ? Platform.Arch.X64 : (StringTool.startsWithIgnoreCase(arch, "ppc") ? Platform.Arch.PPC : (StringTool.startsWithIgnoreCase(arch, "sparc") ? Platform.Arch.SPARC : Platform.Arch.UNKNOWN)));
        }
        return result;
    }

    protected String getReleasePath() {
        String result = null;
        File[] etcList = new File("/etc").listFiles();
        if (etcList != null) {
            for (File etcEntry : etcList) {
                if (!etcEntry.isFile() || !etcEntry.getName().endsWith("-release")) continue;
                result = etcEntry.toString();
                break;
            }
        }
        return result;
    }

    protected boolean exists(String path) {
        return new File(path).exists();
    }

    private boolean search(List<String> text, String str) {
        return this.search(text, str, false);
    }

    private boolean search(List<String> text, String str, boolean caseInsensitive) {
        boolean result = false;
        if (caseInsensitive) {
            str = str.toLowerCase();
        }
        for (String line : text) {
            if (caseInsensitive) {
                line = line.toLowerCase();
            }
            if (!line.contains(str)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean equals(String a, String b) {
        return this.equals(a, b, false);
    }

    private boolean equals(String a, String b, boolean ignoreCase) {
        boolean result = false;
        if (a == null && b == null) {
            result = true;
        } else if (a != null) {
            result = ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
        }
        return result;
    }
}

