/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrivilegedRunner {
    private final Platform platform;
    private boolean vetoed;
    private static final Logger logger = Logger.getLogger(PrivilegedRunner.class.getName());

    public PrivilegedRunner(Platform platform) {
        this(platform, false);
    }

    public PrivilegedRunner(Platform platform, boolean vetoed) {
        this.platform = platform;
        this.vetoed = vetoed;
    }

    public boolean isVetoed() {
        return this.vetoed;
    }

    public boolean isPlatformSupported() {
        return this.platform.isA(Platform.Name.UNIX) || this.platform.isA(Platform.Name.WINDOWS);
    }

    public boolean isElevationNeeded() {
        return this.isElevationNeeded(null);
    }

    public boolean isElevationNeeded(String path) {
        boolean result = false;
        if (!this.vetoed) {
            if (this.platform.isA(Platform.Name.WINDOWS)) {
                if (path == null || path.trim().length() == 0) {
                    path = this.getProgramFiles();
                }
                result = !PrivilegedRunner.isPrivilegedMode() && !this.canWrite(path);
            } else {
                result = path != null ? !this.canWrite(path) : !System.getProperty("user.name").equals("root");
            }
        }
        return result;
    }

    public int relaunchWithElevatedRights() throws IOException, InterruptedException {
        String javaCommand = this.getJavaCommand();
        String installer = this.getInstallerJar();
        ProcessBuilder builder = new ProcessBuilder(this.getElevator(javaCommand, installer));
        builder.environment().put("izpack.mode", "privileged");
        return builder.start().waitFor();
    }

    public static boolean isPrivilegedMode() {
        return "privileged".equals(System.getenv("izpack.mode")) || "privileged".equals(System.getProperty("izpack.mode"));
    }

    protected List<String> getElevator(String javaCommand, String installer) throws IOException {
        ArrayList<String> elevator = new ArrayList<String>();
        if (this.platform.isA(Platform.Name.MAC_OSX)) {
            elevator.add(this.extractMacElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (this.platform.isA(Platform.Name.UNIX)) {
            elevator.add("xterm");
            elevator.add("-title");
            elevator.add("Installer");
            elevator.add("-e");
            elevator.add("sudo");
            elevator.add(javaCommand);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (this.platform.isA(Platform.Name.WINDOWS)) {
            elevator.add("wscript");
            elevator.add(this.extractVistaElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.add("-Dizpack.mode=privileged");
            elevator.add("-jar");
            elevator.add(installer);
        }
        return elevator;
    }

    protected File extractVistaElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer.js";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/util/windows/elevate.js");
        this.copyStream(out, in);
        in.close();
        out.close();
        elevator.deleteOnExit();
        return elevator;
    }

    protected File extractMacElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/util/mac/run-with-privileges-on-osx");
        this.copyStream(out, in);
        in.close();
        out.close();
        if (!elevator.setExecutable(true)) {
            throw new IOException("Failed to set execute permission on " + path);
        }
        elevator.deleteOnExit();
        return elevator;
    }

    private void copyStream(OutputStream out, InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private String getInstallerJar() {
        try {
            URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uri.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uri);
            }
            return new File(uri.getSchemeSpecificPart()).getCanonicalPath();
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    private String getJavaCommand() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + this.getJavaExecutable();
    }

    private String getJavaExecutable() {
        if (OsVersion.IS_WINDOWS) {
            return "javaw.exe";
        }
        return "java";
    }

    private boolean canWrite(String path) {
        File file = new File(path);
        boolean canWrite = file.canWrite();
        if (canWrite) {
            try {
                File test = File.createTempFile(".izpackwritecheck", null, file);
                if (!test.delete()) {
                    test.deleteOnExit();
                }
            }
            catch (IOException exception) {
                canWrite = false;
            }
        }
        return canWrite;
    }

    private String getProgramFiles() {
        String path = System.getenv("ProgramFiles");
        if (path == null) {
            path = "C:\\Program Files";
        }
        return path;
    }
}

