/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemporaryDirectory
implements CleanupClient {
    private static final Logger logger = Logger.getLogger(TemporaryDirectory.class.getName());
    private File tempdir;
    private final AutomatedInstallData installData;
    private final Info.TempDir tempDirDescription;
    private boolean deleteOnExit = false;
    private final Housekeeper housekeeper;

    public TemporaryDirectory(Info.TempDir tempDirDescription, AutomatedInstallData installData, Housekeeper housekeeper) {
        if (null == tempDirDescription) {
            throw new IllegalArgumentException("Unable to create a temporary directory, the temp directory description may not be null.");
        }
        if (null == installData) {
            throw new IllegalArgumentException("Unable to create a temporary directory, the install data may not be null.");
        }
        this.installData = installData;
        this.tempDirDescription = tempDirDescription;
        this.housekeeper = housekeeper;
    }

    public void create() throws IOException {
        try {
            this.tempdir = File.createTempFile(this.tempDirDescription.getPrefix(), this.tempDirDescription.getSuffix());
            this.tempdir.delete();
            this.tempdir.mkdir();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to create temporary directory for installation: " + e.getMessage(), e);
            throw e;
        }
        this.installData.setVariable(this.tempDirDescription.getVariableName(), this.tempdir.getAbsolutePath());
        this.housekeeper.registerForCleanup(this);
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    @Override
    public void cleanUp() {
        if (null != this.tempdir) {
            if (this.deleteOnExit) {
                if (!FileUtils.deleteRecursively(this.tempdir)) {
                    logger.warning("Failed to properly clean up files in " + this.tempdir.getAbsolutePath() + " manual clean up may be required.");
                }
            } else {
                logger.warning("Temporary directory has not been cleaned up. Files have been left in: " + this.tempdir.getAbsolutePath());
            }
        } else {
            logger.warning("Temporary directory registered for cleanup but there is no such directory");
        }
    }
}

