/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.util.config.ConfigurableTask;
import com.izforge.izpack.util.config.base.BasicProfile;
import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.Configurable;
import com.izforge.izpack.util.config.base.Ini;
import com.izforge.izpack.util.config.base.OptionMap;
import com.izforge.izpack.util.config.base.Options;
import com.izforge.izpack.util.config.base.Profile;
import com.izforge.izpack.util.config.base.Reg;
import com.izforge.izpack.util.config.base.Registry;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class SingleConfigurableTask
implements ConfigurableTask {
    private static final Logger logger = Logger.getLogger(SingleConfigurableTask.class.getName());
    private boolean patchPreserveEntries = true;
    private boolean patchPreserveValues = true;
    private boolean patchResolveVariables = false;
    protected boolean createConfigurable = true;
    private boolean escape = Config.getGlobal().isEscape();
    private boolean escapeNewLine = Config.getGlobal().isEscapeNewline();
    private boolean headerComment = false;
    private boolean emptyLines = true;
    private boolean autoNumbering = true;
    private String operator = Config.getGlobal().getOperator();
    protected Configurable configurable;
    protected Configurable fromConfigurable;
    private Vector<Entry> entries = new Vector();

    public void setPatchPreserveEntries(boolean preserveEntries) {
        this.patchPreserveEntries = preserveEntries;
    }

    public void setPatchPreserveValues(boolean preserveValues) {
        this.patchPreserveValues = preserveValues;
    }

    public void setPatchResolveVariables(boolean resolve) {
        this.patchResolveVariables = resolve;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setEscapeNewLine(boolean escapeNewLine) {
        this.escapeNewLine = escapeNewLine;
    }

    public void setHeaderComment(boolean headerComment) {
        this.headerComment = headerComment;
    }

    public void setEmptyLines(boolean emptyLines) {
        this.emptyLines = emptyLines;
    }

    public void setAutoNumbering(boolean autoNumbering) {
        this.autoNumbering = autoNumbering;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setCreate(boolean create) {
        this.createConfigurable = create;
    }

    @Override
    public void execute() throws Exception {
        Config.getGlobal().setHeaderComment(this.headerComment);
        Config.getGlobal().setEmptyLines(this.emptyLines);
        Config.getGlobal().setAutoNumbering(this.autoNumbering);
        Config.getGlobal().setEscape(this.escape);
        Config.getGlobal().setEscapeNewline(this.escapeNewLine);
        Config.getGlobal().setOperator(this.operator);
        this.checkAttributes();
        this.readConfigurable();
        this.readSourceConfigurable();
        this.patchConfigurable();
        this.executeNestedEntries();
        this.writeConfigurable();
    }

    private String getValueFromOptionMap(OptionMap map, String key, int index) {
        return this.patchResolveVariables ? map.fetch((Object)key, index) : (String)map.get((Object)key, index);
    }

    private void keepOptions(String key, String fromValue, String lookupValue, Entry.LookupType lookupType) {
        int found = 0;
        block3: for (int i = 0; i < ((Options)this.configurable).length(key); ++i) {
            if (lookupValue != null) {
                String origValue = this.getValueFromOptionMap((OptionMap)((Object)this.configurable), key, i);
                if (origValue == null) continue;
                switch (lookupType) {
                    case REGEXP: {
                        if (!origValue.matches(lookupValue)) continue block3;
                        logger.fine("Preserve option file entry \"" + key + "\"");
                        ((Options)this.configurable).put(key, fromValue, i);
                        ++found;
                        break;
                    }
                    default: {
                        if (!origValue.equals(lookupValue)) continue block3;
                        ((Options)this.configurable).put(key, fromValue, i);
                        ++found;
                    }
                }
                continue;
            }
            ((Options)this.configurable).put(key, fromValue, i);
            ++found;
        }
        logger.fine("Patched " + found + " option file entries for key \"" + key + "\" found in original: " + fromValue);
        if (found == 0) {
            logger.fine("Add option file entry for \"" + key + "\": " + fromValue);
            ((Options)this.configurable).add(key, fromValue);
        }
    }

    private void deleteOptions(String key, String lookupValue, Entry.LookupType lookupType) {
        block3: for (int i = 0; i < ((Options)this.configurable).length(key); ++i) {
            if (lookupValue == null) {
                String origValue = this.getValueFromOptionMap((OptionMap)((Object)this.configurable), key, i);
                if (origValue == null) continue;
                switch (lookupType) {
                    case REGEXP: {
                        if (!origValue.matches(lookupValue)) continue block3;
                        logger.fine("Remove option key \"" + key + "\"");
                        ((Options)this.configurable).remove((Object)key, i);
                        --i;
                        break;
                    }
                    default: {
                        if (!origValue.equals(lookupValue)) continue block3;
                        logger.fine("Remove option key \"" + key + "\"");
                        ((Options)this.configurable).remove((Object)key, i);
                        --i;
                    }
                }
                continue;
            }
            logger.fine("Remove option key \"" + key + "\"");
            ((Options)this.configurable).remove(key);
            --i;
        }
    }

    private void deleteConfigurableEntry(String section, String key, String lookupValue, Entry.LookupType lookupType) throws Exception {
        if (this.configurable instanceof Options) {
            this.deleteOptions(key, lookupValue, lookupType);
        } else if (this.configurable instanceof Ini) {
            ((Ini)this.configurable).remove((Object)section, key);
        } else if (this.configurable instanceof Reg) {
            ((Reg)this.configurable).remove((Object)section, key);
        } else {
            throw new Exception("Unknown configurable type class: " + this.configurable.getClass().getName());
        }
    }

    private void keepConfigurableValue(String section, String key, String lookupValue, Entry.LookupType lookupType) throws Exception {
        if (this.fromConfigurable != null) {
            if (this.configurable instanceof Options) {
                block3: for (int i = 0; i < ((Options)this.fromConfigurable).length(key); ++i) {
                    String fromValue = this.getValueFromOptionMap((OptionMap)((Object)this.fromConfigurable), key, i);
                    if (fromValue == null) continue;
                    if (lookupValue != null) {
                        switch (lookupType) {
                            case REGEXP: {
                                if (!fromValue.matches(lookupValue)) continue block3;
                                this.keepOptions(key, fromValue, lookupValue, lookupType);
                                break;
                            }
                            default: {
                                if (fromValue.equals(lookupValue)) continue block3;
                                this.keepOptions(key, fromValue, lookupValue, lookupType);
                                break;
                            }
                        }
                        continue;
                    }
                    this.keepOptions(key, fromValue, lookupValue, lookupType);
                }
            } else if (this.configurable instanceof Ini) {
                Profile.Section fromSection = (Profile.Section)((Ini)this.fromConfigurable).get(section);
                Profile.Section toSection = (Profile.Section)((Ini)this.configurable).get(section);
                if (fromSection != null) {
                    if (toSection == null) {
                        logger.fine("Adding new INI section [" + section + "]");
                        toSection = ((Ini)this.configurable).add(section);
                    }
                    if (toSection != null) {
                        String fromValue;
                        String string = fromValue = this.patchResolveVariables ? fromSection.fetch(key) : (String)fromSection.get(key);
                        if (!toSection.containsKey(key)) {
                            logger.fine("Preserve INI file entry \"" + key + "\" in section [" + section + "]: " + fromValue);
                            toSection.add(key, fromValue);
                        } else {
                            logger.fine("Preserve INI file entry value for key \"" + key + "\" in section [" + section + "]: " + fromValue);
                            toSection.put(key, fromValue);
                        }
                    }
                }
            } else if (this.configurable instanceof Reg) {
                Registry.Key fromRegKey = ((Reg)this.fromConfigurable).get(section);
                Registry.Key toRegKey = ((Reg)this.configurable).get(section);
                if (fromRegKey != null) {
                    if (toRegKey == null) {
                        logger.fine("Adding new registry root key " + section);
                        toRegKey = ((Reg)this.configurable).add(section);
                    }
                    if (toRegKey != null) {
                        String fromValue;
                        String string = fromValue = this.patchResolveVariables ? fromRegKey.fetch(key) : (String)fromRegKey.get(key);
                        if (!toRegKey.containsKey(key)) {
                            logger.fine("Preserve registry value " + key + " under root key " + section + ": " + fromValue);
                            toRegKey.add(key, fromValue);
                        } else {
                            logger.fine("Preserve registry data for value " + key + " in root key " + section + ": " + fromValue);
                            toRegKey.put(key, fromValue);
                        }
                    }
                }
            } else {
                throw new Exception("Unknown configurable type class: " + this.configurable.getClass().getName());
            }
        }
    }

    private void patchConfigurable() throws Exception {
        if (this.fromConfigurable != null) {
            if (this.configurable instanceof Options) {
                Set toKeySet = ((Options)this.configurable).keySet();
                Set fromKeySet = ((Options)this.fromConfigurable).keySet();
                for (String key : fromKeySet) {
                    String fromValue;
                    String string = fromValue = this.patchResolveVariables ? ((Options)this.fromConfigurable).fetch(key) : (String)((Options)this.fromConfigurable).get(key);
                    if (this.patchPreserveEntries && !toKeySet.contains(key)) {
                        logger.fine("Preserve option file entry \"" + key + "\"");
                        ((Options)this.configurable).add(key, fromValue);
                        continue;
                    }
                    if (!this.patchPreserveValues || !((Options)this.configurable).keySet().contains(key)) continue;
                    logger.fine("Preserve option value for key \"" + key + "\": \"" + fromValue + "\"");
                    ((Options)this.configurable).put(key, fromValue);
                }
            } else if (this.configurable instanceof Ini) {
                Set sectionKeySet = ((Ini)this.configurable).keySet();
                Set fromSectionKeySet = ((Ini)this.fromConfigurable).keySet();
                for (String fromSectionKey : fromSectionKeySet) {
                    if (!sectionKeySet.contains(fromSectionKey)) continue;
                    Profile.Section fromSection = (Profile.Section)((Ini)this.fromConfigurable).get(fromSectionKey);
                    Profile.Section toSection = (Profile.Section)((Ini)this.configurable).get(fromSectionKey);
                    Set fromKeySet = fromSection.keySet();
                    Set toKeySet = null;
                    if (toSection != null) {
                        toKeySet = toSection.keySet();
                    }
                    for (String fromKey : fromKeySet) {
                        String fromValue;
                        if (toSection == null) {
                            logger.fine("Adding new INI section [" + fromSectionKey + "]");
                            toSection = ((Ini)this.configurable).add(fromSectionKey);
                        }
                        String string = fromValue = this.patchResolveVariables ? fromSection.fetch(fromKey) : (String)fromSection.get(fromKey);
                        if (this.patchPreserveEntries && !toKeySet.contains(fromKey)) {
                            logger.fine("Preserve INI file entry \"" + fromKey + "\" in section [" + fromSectionKey + "]: " + fromValue);
                            toSection.add(fromKey, fromValue);
                            continue;
                        }
                        if (!this.patchPreserveValues || !toKeySet.contains(fromKey)) continue;
                        logger.fine("Preserve INI file entry value for key \"" + fromKey + "\" in section [" + fromSectionKey + "]: " + fromValue);
                        toSection.put(fromKey, fromValue);
                    }
                }
            } else if (this.configurable instanceof Reg) {
                Set rootKeySet = ((Reg)this.configurable).keySet();
                Set fromRootKeySet = ((Reg)this.fromConfigurable).keySet();
                for (String fromRootKey : fromRootKeySet) {
                    if (!rootKeySet.contains(fromRootKey)) continue;
                    Registry.Key fromRegKey = ((Reg)this.fromConfigurable).get(fromRootKey);
                    Registry.Key toRegKey = ((Reg)this.configurable).get(fromRootKey);
                    Set fromKeySet = fromRegKey.keySet();
                    Set toKeySet = null;
                    if (toRegKey != null) {
                        toKeySet = toRegKey.keySet();
                    }
                    for (String fromKey : fromKeySet) {
                        String fromValue;
                        if (toRegKey == null) {
                            logger.fine("Adding new registry root key " + fromRootKey);
                            toRegKey = ((Reg)this.configurable).add(fromRootKey);
                        }
                        String string = fromValue = this.patchResolveVariables ? fromRegKey.fetch(fromKey) : (String)fromRegKey.get(fromKey);
                        if (this.patchPreserveEntries && !toKeySet.contains(fromKey)) {
                            logger.fine("Preserve registry value " + fromKey + " under root key " + fromRootKey + ": " + fromValue);
                            toRegKey.add(fromKey, fromValue);
                            continue;
                        }
                        if (!this.patchPreserveValues || !toKeySet.contains(fromKey)) continue;
                        logger.fine("Preserve registry data for value " + fromKey + " in root key " + fromRootKey + ": " + fromValue);
                        toRegKey.put(fromKey, fromValue);
                    }
                }
            } else {
                throw new Exception("Unknown configurable type class: " + this.configurable.getClass().getName());
            }
        }
    }

    private void executeNestedEntries() throws Exception {
        block4: for (Entry entry : this.entries) {
            switch (entry.getOperation()) {
                case REMOVE: {
                    this.deleteConfigurableEntry(entry.getSection(), entry.getKey(), entry.getValue(), entry.getLookupType());
                    continue block4;
                }
                case KEEP: {
                    this.keepConfigurableValue(entry.getSection(), entry.getKey(), entry.getValue(), entry.getLookupType());
                    continue block4;
                }
            }
            entry.executeOn(this.configurable);
        }
    }

    protected abstract void checkAttributes() throws Exception;

    protected abstract void readSourceConfigurable() throws Exception;

    protected abstract void readConfigurable() throws Exception;

    protected abstract void writeConfigurable() throws Exception;

    public void readFromXML(IXMLElement parent) {
        for (IXMLElement el : parent.getChildrenNamed("entry")) {
            this.entries.addElement(this.createEntryFromXML(el));
        }
    }

    protected Entry createEntryFromXML(IXMLElement parent) {
        Entry e = new Entry();
        String attrib = parent.getAttribute("dataType");
        if (attrib != null) {
            e.setType(Entry.Type.getFromAttribute(attrib));
        }
        if ((attrib = parent.getAttribute("lookupType")) != null) {
            e.setLookupType(Entry.LookupType.getFromAttribute(attrib));
        }
        if ((attrib = parent.getAttribute("operation")) != null) {
            e.setOperation(Entry.Operation.getFromAttribute(attrib));
        }
        if ((attrib = parent.getAttribute("unit")) != null) {
            e.setUnit(Unit.getFromAttribute(attrib));
        }
        e.setDefault(parent.getAttribute("default"));
        e.setPattern(parent.getAttribute("pattern"));
        this.filterEntryFromXML(parent, e);
        return e;
    }

    protected abstract Entry filterEntryFromXML(IXMLElement var1, Entry var2);

    public static enum Unit {
        MILLISECOND("millisecond"),
        SECOND("second"),
        MINUTE("minute"),
        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year");

        private static Map<String, Unit> lookup;
        private static Hashtable<Unit, Integer> calendarFields;
        private String attribute;

        private Unit(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static Unit getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        public int getCalendarField() {
            return calendarFields.get((Object)this);
        }

        static {
            lookup = new HashMap<String, Unit>();
            for (Unit unit : EnumSet.allOf(Unit.class)) {
                lookup.put(unit.getAttribute(), unit);
            }
            calendarFields = new Hashtable();
            calendarFields.put(MILLISECOND, new Integer(14));
            calendarFields.put(SECOND, new Integer(13));
            calendarFields.put(MINUTE, new Integer(12));
            calendarFields.put(HOUR, new Integer(11));
            calendarFields.put(DAY, new Integer(5));
            calendarFields.put(WEEK, new Integer(3));
            calendarFields.put(MONTH, new Integer(2));
            calendarFields.put(YEAR, new Integer(1));
        }
    }

    public static class Entry {
        private static final int DEFAULT_INT_VALUE = 0;
        private static final String DEFAULT_DATE_VALUE = "now";
        private static final String DEFAULT_STRING_VALUE = "";
        protected String section = null;
        protected String key = null;
        protected String value = null;
        private boolean resolveVariables = false;
        private LookupType lookupType = LookupType.PLAIN;
        private Type type = Type.STRING;
        private Operation operation = Operation.SET;
        private String defaultValue = null;
        private String pattern = null;
        private Unit unit = Unit.DAY;

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String value) {
            this.key = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setResolveVariables(boolean resolve) {
            this.resolveVariables = resolve;
        }

        public String getValue() {
            return this.value;
        }

        public LookupType getLookupType() {
            return this.lookupType;
        }

        public Type getType() {
            return this.type;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setLookupType(LookupType lookupType) {
            this.lookupType = lookupType;
        }

        public void setDefault(String value) {
            this.defaultValue = value;
        }

        public void setPattern(String value) {
            this.pattern = value;
        }

        public void setUnit(Unit unit) {
            this.unit = unit;
        }

        private void executeOnOptions(Options configurable) throws Exception {
            List values = configurable.getAll(this.key);
            String newValue = null;
            boolean contains = false;
            if (values != null) {
                block3: for (int i = 0; i < values.toArray().length; ++i) {
                    String origValue = this.getValueFromOptions(configurable, i);
                    newValue = this.execute(origValue);
                    if (origValue == null || this.value == null) continue;
                    switch (this.lookupType) {
                        case REGEXP: {
                            if (!origValue.matches(this.value)) continue block3;
                            logger.fine("Set option value for key \"" + this.key + "\": \"" + newValue + "\"");
                            configurable.put(this.key, newValue, i);
                            contains = true;
                            continue block3;
                        }
                        default: {
                            if (!origValue.equals(this.value)) continue block3;
                            logger.fine("Set option value for key \"" + this.key + "\": \"" + newValue + "\"");
                            configurable.put(this.key, newValue, i);
                            contains = true;
                        }
                    }
                }
            }
            if (!contains) {
                logger.fine("Set option value for key \"" + this.key + "\": \"" + newValue + "\"");
                configurable.put(this.key, newValue);
            }
        }

        private void executeOnProfile(BasicProfile profile) throws Exception {
            String oldValue = this.getValueFromProfile(profile);
            profile.put(this.section, this.key, this.execute(oldValue));
        }

        private String getValueFromOptions(OptionMap map, int index) {
            return this.resolveVariables ? map.fetch((Object)this.key, index) : (String)map.get((Object)this.key, index);
        }

        private String getValueFromProfile(BasicProfile profile) {
            return this.resolveVariables ? profile.fetch(this.section, this.key) : profile.get((Object)this.section, this.key);
        }

        private String execute(String oldValue) throws Exception {
            String newValue = null;
            switch (this.type) {
                case INTEGER: {
                    newValue = this.executeInteger(oldValue);
                    break;
                }
                case DATE: {
                    newValue = this.executeDate(oldValue);
                    break;
                }
                case STRING: {
                    newValue = this.executeString(oldValue);
                    break;
                }
                default: {
                    throw new Exception("Unknown operation type: " + (Object)((Object)this.type));
                }
            }
            if (newValue == null) {
                newValue = DEFAULT_STRING_VALUE;
            }
            return newValue;
        }

        protected void executeOn(Configurable configurable) throws Exception {
            this.checkParameters();
            if (configurable instanceof Options) {
                this.executeOnOptions((Options)configurable);
            } else if (configurable instanceof Ini) {
                this.executeOnProfile((BasicProfile)((Object)configurable));
            } else if (configurable instanceof Reg) {
                this.executeOnProfile((BasicProfile)((Object)configurable));
            } else {
                throw new Exception("Unknown configurable type class: " + configurable.getClass().getName());
            }
        }

        private String executeDate(String oldValue) throws Exception {
            Calendar currentValue = Calendar.getInstance();
            if (this.pattern == null) {
                this.pattern = "yyyy/MM/dd HH:mm";
            }
            SimpleDateFormat fmt = new SimpleDateFormat(this.pattern);
            String currentStringValue = this.getCurrentValue(oldValue);
            if (currentStringValue == null) {
                currentStringValue = DEFAULT_DATE_VALUE;
            }
            if (DEFAULT_DATE_VALUE.equals(currentStringValue)) {
                currentValue.setTime(new Date());
            } else {
                try {
                    currentValue.setTime(fmt.parse(currentStringValue));
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (this.operation != Operation.SET) {
                int offset = 0;
                try {
                    offset = Integer.parseInt(this.value);
                    if (this.operation == Operation.DECREMENT) {
                        offset = -1 * offset;
                    }
                }
                catch (NumberFormatException e) {
                    throw new Exception("Value not an integer on " + this.key);
                }
                currentValue.add(this.unit.getCalendarField(), offset);
            }
            return fmt.format(currentValue.getTime());
        }

        private String executeInteger(String oldValue) throws Exception {
            int currentValue = 0;
            int newValue = 0;
            DecimalFormat fmt = this.pattern != null ? new DecimalFormat(this.pattern) : new DecimalFormat();
            try {
                String curval = this.getCurrentValue(oldValue);
                currentValue = curval != null ? fmt.parse(curval).intValue() : 0;
            }
            catch (NumberFormatException nfe) {
            }
            catch (ParseException pe) {
                // empty catch block
            }
            if (this.operation == Operation.SET) {
                newValue = currentValue;
            } else {
                int operationValue = 1;
                if (this.value != null) {
                    try {
                        operationValue = fmt.parse(this.value).intValue();
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                }
                if (this.operation == Operation.INCREMENT) {
                    newValue = currentValue + operationValue;
                } else if (this.operation == Operation.DECREMENT) {
                    newValue = currentValue - operationValue;
                }
            }
            return fmt.format(newValue);
        }

        private String executeString(String oldValue) throws Exception {
            String newValue = DEFAULT_STRING_VALUE;
            String currentValue = this.getCurrentValue(oldValue);
            if (currentValue == null) {
                currentValue = DEFAULT_STRING_VALUE;
            }
            if (this.operation == Operation.SET) {
                newValue = currentValue;
            } else if (this.operation == Operation.INCREMENT) {
                newValue = currentValue + this.value;
            }
            return newValue;
        }

        private void checkParameters() throws Exception {
            if (this.type == Type.STRING && this.operation == Operation.DECREMENT) {
                throw new Exception("- is not supported for string properties (key: " + this.key + ")");
            }
            if (this.value == null && this.defaultValue == null) {
                throw new Exception("\"value\" and/or \"default\" attribute must be specified (key: " + this.key + ")");
            }
            if (this.key == null) {
                throw new Exception("key is mandatory");
            }
            if (this.type == Type.STRING && this.pattern != null) {
                throw new Exception("pattern is not supported for string properties (key: " + this.key + ")");
            }
        }

        private String getCurrentValue(String oldValue) {
            String ret = null;
            if (this.operation == Operation.SET) {
                if (this.value != null && this.defaultValue == null) {
                    ret = this.value;
                }
                if (this.value == null && this.defaultValue != null && oldValue != null) {
                    ret = oldValue;
                }
                if (this.value == null && this.defaultValue != null && oldValue == null) {
                    ret = this.defaultValue;
                }
                if (this.value != null && this.defaultValue != null && oldValue != null) {
                    ret = this.value;
                }
                if (this.value != null && this.defaultValue != null && oldValue == null) {
                    ret = this.defaultValue;
                }
            } else {
                ret = oldValue == null ? this.defaultValue : oldValue;
            }
            return ret;
        }

        public static enum LookupType {
            PLAIN("plain"),
            REGEXP("regexp");

            private static Map<String, LookupType> lookup;
            private String attribute;

            private LookupType(String attribute) {
                this.attribute = attribute;
            }

            public String getAttribute() {
                return this.attribute;
            }

            public static LookupType getFromAttribute(String attribute) {
                if (attribute != null && lookup.containsKey(attribute)) {
                    return lookup.get(attribute);
                }
                return null;
            }

            static {
                lookup = new HashMap<String, LookupType>();
                for (LookupType type : EnumSet.allOf(LookupType.class)) {
                    lookup.put(type.getAttribute(), type);
                }
            }
        }

        public static enum Type {
            INTEGER("int"),
            DATE("date"),
            STRING("string");

            private static Map<String, Type> lookup;
            private String attribute;

            private Type(String attribute) {
                this.attribute = attribute;
            }

            public String getAttribute() {
                return this.attribute;
            }

            public static Type getFromAttribute(String attribute) {
                if (attribute != null && lookup.containsKey(attribute)) {
                    return lookup.get(attribute);
                }
                return null;
            }

            static {
                lookup = new HashMap<String, Type>();
                for (Type type : EnumSet.allOf(Type.class)) {
                    lookup.put(type.getAttribute(), type);
                }
            }
        }

        public static enum Operation {
            INCREMENT("+"),
            DECREMENT("-"),
            SET("="),
            REMOVE("remove"),
            KEEP("keep");

            private static Map<String, Operation> lookup;
            private String attribute;

            private Operation(String attribute) {
                this.attribute = attribute;
            }

            public String getAttribute() {
                return this.attribute;
            }

            public static Operation getFromAttribute(String attribute) {
                if (attribute != null && lookup.containsKey(attribute)) {
                    return lookup.get(attribute);
                }
                return null;
            }

            static {
                lookup = new HashMap<String, Operation>();
                for (Operation operation : EnumSet.allOf(Operation.class)) {
                    lookup.put(operation.getAttribute(), operation);
                }
            }
        }
    }
}

