/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.util.config.ConfigFileTask;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import com.izforge.izpack.util.config.base.Ini;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SingleIniFileTask
extends ConfigFileTask {
    private static final Logger logger = Logger.getLogger(SingleIniFileTask.class.getName());

    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.oldFile != null) {
            try {
                if (!this.oldFile.exists()) {
                    logger.warning("INI file " + this.oldFile.getAbsolutePath() + " to patch from could not be found, no patches will be applied");
                    return;
                }
                logger.fine("Loading INI file: " + this.oldFile.getAbsolutePath());
                this.fromConfigurable = new Ini(this.oldFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.newFile != null && this.newFile.exists()) {
            try {
                logger.fine("Loading original configuration file: " + this.newFile.getAbsolutePath());
                this.configurable = new Ini(this.newFile);
            }
            catch (IOException ioe) {
                throw new Exception("Error opening original configuration file: " + ioe.toString());
            }
        } else if (this.toFile != null && this.toFile.exists()) {
            try {
                logger.fine("Loading target configuration file: " + this.toFile.getAbsolutePath());
                this.configurable = new Ini(this.toFile);
            }
            catch (IOException ioe) {
                throw new Exception("Error opening target configuration file: " + ioe.toString());
            }
        } else {
            this.configurable = new Ini();
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        try {
            if (!this.toFile.exists()) {
                if (this.createConfigurable) {
                    File parent = this.toFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    logger.fine("Creating empty INI file: " + this.toFile.getAbsolutePath());
                    this.toFile.createNewFile();
                } else {
                    logger.warning("INI file " + this.toFile.getAbsolutePath() + " did not exist and is not allowed to be created");
                    return;
                }
            }
            Ini ini = (Ini)this.configurable;
            ini.setFile(this.toFile);
            ini.setComment(this.getComment());
            ini.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
        if (this.cleanup && this.oldFile.exists() && !this.oldFile.delete()) {
            logger.warning("File " + this.oldFile + " could not be cleant up");
        }
    }

    @Override
    protected SingleConfigurableTask.Entry filterEntryFromXML(IXMLElement parent, SingleConfigurableTask.Entry entry) {
        entry.setSection(parent.getAttribute("section"));
        entry.setKey(parent.getAttribute("key"));
        entry.setValue(parent.getAttribute("value"));
        return entry;
    }
}

