/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.IdentityMapper;
import com.izforge.izpack.util.file.types.Mapper;
import com.izforge.izpack.util.file.types.selectors.BaseSelector;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class PresentSelector
extends BaseSelector {
    private File targetdir = null;
    private Mapper mapperElement = null;
    private FileNameMapper map = null;
    private boolean destmustexist = true;

    public String toString() {
        StringBuffer buf = new StringBuffer("{presentselector targetdir: ");
        if (this.targetdir == null) {
            buf.append("NOT YET SET");
        } else {
            buf.append(this.targetdir.getName());
        }
        buf.append(" present: ");
        if (this.destmustexist) {
            buf.append("both");
        } else {
            buf.append("srconly");
        }
        if (this.map != null) {
            buf.append(this.map.toString());
        } else if (this.mapperElement != null) {
            buf.append(this.mapperElement.toString());
        }
        buf.append("}");
        return buf.toString();
    }

    public void setTargetdir(File targetdir) {
        this.targetdir = targetdir;
    }

    public Mapper createMapper() throws Exception {
        if (this.mapperElement != null) {
            throw new Exception("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper();
        return this.mapperElement;
    }

    public void setPresent(FilePresence fp) {
        if (fp.equals((Object)FilePresence.SRCONLY)) {
            this.destmustexist = false;
        }
    }

    @Override
    public void verifySettings() throws Exception {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        String[] destfiles = this.map.mapFileName(filename);
        if (destfiles == null) {
            return false;
        }
        if (destfiles.length != 1 || destfiles[0] == null) {
            throw new Exception("Invalid destination file results for " + this.targetdir + " with filename " + filename);
        }
        String destname = destfiles[0];
        File destfile = new File(this.targetdir, destname);
        return destfile.exists() == this.destmustexist;
    }

    public static enum FilePresence {
        SRCONLY("srconly"),
        BOTH("both");

        private static Map<String, FilePresence> lookup;
        private String attribute;

        private FilePresence(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static FilePresence getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, FilePresence>();
            for (FilePresence mapperType : EnumSet.allOf(FilePresence.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
        }
    }
}

