/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class SizeSelector
extends BaseExtendSelector {
    private long size = -1L;
    private long multiplier = 1L;
    private long sizelimit = -1L;
    private SizeComparisons cmp = SizeComparisons.EQUAL;
    public static final String SIZE_KEY = "value";
    public static final String UNITS_KEY = "units";
    public static final String WHEN_KEY = "when";

    public String toString() {
        StringBuffer buf = new StringBuffer("{sizeselector value: ");
        buf.append(this.sizelimit);
        buf.append("compare: ");
        buf.append(this.cmp.getAttribute());
        buf.append("}");
        return buf.toString();
    }

    public void setValue(long size) {
        this.size = size;
        if (this.multiplier != 0L && size > -1L) {
            this.sizelimit = size * this.multiplier;
        }
    }

    public void setUnits(ByteUnits units) {
        this.multiplier = 0L;
        switch (units) {
            case K: 
            case k: 
            case kilo: 
            case KILO: {
                this.multiplier = 1000L;
                break;
            }
            case Ki: 
            case KI: 
            case ki: 
            case kibi: 
            case KIBI: {
                this.multiplier = 1024L;
                break;
            }
            case M: 
            case m: 
            case mega: 
            case MEGA: {
                this.multiplier = 1000000L;
                break;
            }
            case Mi: 
            case MI: 
            case mi: 
            case mebi: 
            case MEBI: {
                this.multiplier = 0x100000L;
                break;
            }
            case G: 
            case g: 
            case giga: 
            case GIGA: {
                this.multiplier = 1000000000L;
                break;
            }
            case Gi: 
            case GI: 
            case gi: 
            case gibi: 
            case GIBI: {
                this.multiplier = 0x40000000L;
                break;
            }
            case T: 
            case t: 
            case tera: 
            case TERA: {
                this.multiplier = 1000000000000L;
                break;
            }
            case Ti: 
            case TI: 
            case ti: 
            case tebi: 
            case TEBI: {
                this.multiplier = 0x10000000000L;
                break;
            }
        }
        if (this.multiplier > 0L && this.size > -1L) {
            this.sizelimit = this.size * this.multiplier;
        }
    }

    public void setWhen(SizeComparisons scmp) {
        this.cmp = scmp;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramname = parameter.getName();
                if (SIZE_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setValue(new Long(parameter.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid size setting " + parameter.getValue());
                    }
                    continue;
                }
                if (UNITS_KEY.equalsIgnoreCase(paramname)) {
                    ByteUnits units = ByteUnits.getFromAttribute(parameter.getValue());
                    if (units != null) {
                        this.setUnits(units);
                        continue;
                    }
                    this.setError("Invalid units setting " + parameter.getValue());
                    continue;
                }
                if (WHEN_KEY.equalsIgnoreCase(paramname)) {
                    SizeComparisons cmp = SizeComparisons.getFromAttribute(parameter.getValue());
                    if (cmp != null) {
                        this.setWhen(cmp);
                        continue;
                    }
                    this.setError("Invalid when setting " + parameter.getValue());
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.size < 0L) {
            this.setError("The value attribute is required, and must be positive");
        } else if (this.multiplier < 1L) {
            this.setError("Invalid Units supplied, must be K,Ki,M,Mi,G,Gi,T,or Ti");
        } else if (this.sizelimit < 0L) {
            this.setError("Internal error: Code is not setting sizelimit correctly");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (file.isDirectory()) {
            return true;
        }
        switch (this.cmp) {
            case LESS: {
                return file.length() < this.sizelimit;
            }
            case MORE: {
                return file.length() > this.sizelimit;
            }
        }
        return file.length() == this.sizelimit;
    }

    public static enum SizeComparisons {
        LESS("less"),
        MORE("more"),
        EQUAL("equal");

        private static Map<String, SizeComparisons> lookup;
        private String attribute;

        private SizeComparisons(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static SizeComparisons getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, SizeComparisons>();
            for (SizeComparisons mapperType : EnumSet.allOf(SizeComparisons.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
        }
    }

    public static enum ByteUnits {
        K("K"),
        k("k"),
        kilo("kilo"),
        KILO("KILO"),
        Ki("Ki"),
        KI("KI"),
        ki("ki"),
        kibi("kibi"),
        KIBI("KIBI"),
        M("M"),
        m("m"),
        mega("mega"),
        MEGA("MEGA"),
        Mi("Mi"),
        MI("MI"),
        mi("mi"),
        mebi("mebi"),
        MEBI("MEBI"),
        G("G"),
        g("g"),
        giga("giga"),
        GIGA("GIGA"),
        Gi("Gi"),
        GI("GI"),
        gi("gi"),
        gibi("gibi"),
        GIBI("GIBI"),
        T("T"),
        t("t"),
        tera("tera"),
        TERA("TERA"),
        Ti("Ti"),
        TI("TI"),
        ti("ti"),
        tebi("tebi"),
        TEBI("TEBI");

        private static Map<String, ByteUnits> lookup;
        private String attribute;

        private ByteUnits(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ByteUnits getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ByteUnits>();
            for (ByteUnits mapperType : EnumSet.allOf(ByteUnits.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
        }
    }
}

