/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.helper;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SpecHelper {
    public static final String YES = "yes";
    public static final String NO = "no";
    private String specFilename;
    private IXMLElement spec;
    private boolean _haveSpec;
    private final Resources resources;
    private static final String PACK_KEY = "pack";
    private static final String PACK_NAME = "name";

    public SpecHelper(Resources resources) {
        this.resources = resources;
    }

    public void readSpec(String specFileName) throws Exception {
        this.readSpec(specFileName, null);
    }

    public void readSpec(String specFileName, VariableSubstitutor substitutor) throws Exception {
        InputStream input = null;
        try {
            input = this.getResource(specFileName);
        }
        catch (Exception exception) {
            this._haveSpec = false;
            return;
        }
        if (input == null) {
            this._haveSpec = false;
            return;
        }
        this.readSpec(input, substitutor);
        input.close();
        this.specFilename = specFileName;
    }

    public void readSpec(InputStream input) throws Exception {
        this.readSpec(input, null);
    }

    public void readSpec(InputStream input, VariableSubstitutor substitutor) throws Exception {
        if (substitutor != null) {
            input = this.substituteVariables(input, substitutor);
        }
        XMLParser parser = new XMLParser();
        this.spec = parser.parse(input);
        this._haveSpec = true;
    }

    public InputStream getResource(String res) {
        try {
            return this.resources.getInputStream(res);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IXMLElement getPackForName(String packDestName) {
        List<IXMLElement> packs = this.getSpec().getChildrenNamed(PACK_KEY);
        if (packs == null) {
            return null;
        }
        for (IXMLElement pack : packs) {
            String packName = pack.getAttribute(PACK_NAME);
            if (!packName.equals(packDestName)) continue;
            return pack;
        }
        return null;
    }

    public void parseError(IXMLElement parent, String message) throws InstallerException {
        throw new InstallerException(this.specFilename + ":" + parent.getLineNr() + ": " + message);
    }

    public boolean haveSpec() {
        return this._haveSpec;
    }

    public IXMLElement getSpec() {
        return this.spec;
    }

    public void setSpec(IXMLElement element) {
        this.spec = element;
    }

    public List<IXMLElement> getAllSubChildren(IXMLElement root, String[] childdef) {
        return this.getSubChildren(root, childdef, 0);
    }

    private List<IXMLElement> getSubChildren(IXMLElement root, String[] childdef, int depth) {
        List<IXMLElement> children;
        ArrayList<IXMLElement> retval = null;
        List<IXMLElement> retval2 = null;
        List<IXMLElement> list = children = root != null ? root.getChildrenNamed(childdef[depth]) : null;
        if (children == null) {
            return null;
        }
        if (depth < childdef.length - 1) {
            for (IXMLElement child : children) {
                retval2 = this.getSubChildren(child, childdef, depth + 1);
                if (retval2 == null) continue;
                if (retval == null) {
                    retval = new ArrayList<IXMLElement>();
                }
                retval.addAll(retval2);
            }
        } else {
            return children;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream substituteVariables(InputStream input, VariableSubstitutor substitutor) throws Exception {
        File tempFile = File.createTempFile("izpacksubs", "");
        FileOutputStream fos = null;
        tempFile.deleteOnExit();
        try {
            fos = new FileOutputStream(tempFile);
            substitutor.substitute(input, fos, null, "UTF-8");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return new FileInputStream(tempFile);
    }

    public boolean isAttributeYes(IXMLElement element, String attribute, boolean defaultValue) {
        String value = element.getAttribute(attribute, defaultValue ? YES : NO);
        if (value.equalsIgnoreCase(YES)) {
            return true;
        }
        if (value.equalsIgnoreCase(NO)) {
            return false;
        }
        return defaultValue;
    }

    public String getRequiredAttribute(IXMLElement element, String attrName) throws InstallerException {
        String attr = element.getAttribute(attrName);
        if (attr == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attrName + "'.");
        }
        return attr;
    }
}

