/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.factory;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.MatchException;
import com.izforge.izpack.util.xmlmerge.Operation;
import com.izforge.izpack.util.xmlmerge.OperationFactory;
import java.util.HashMap;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;

public class XPathOperationFactory
implements OperationFactory {
    Map<String, Operation> m_map = new HashMap<String, Operation>();
    Operation m_defaultOperation;

    public void setOperationMap(Map<String, Operation> map) {
        this.m_map = map;
    }

    public void setDefaultOperation(Operation operation) {
        this.m_defaultOperation = operation;
    }

    @Override
    public Operation getOperation(Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        for (String xPath : this.m_map.keySet()) {
            if (!this.matches(originalElement, xPath) && !this.matches(patchElement, xPath)) continue;
            return this.m_map.get(xPath);
        }
        return this.m_defaultOperation;
    }

    private boolean matches(Element element, String xPathString) throws AbstractXmlMergeException {
        if (element == null) {
            return false;
        }
        try {
            JDOMXPath xPath = new JDOMXPath(xPathString);
            boolean result = xPath.selectNodes((Object)element.getParent()).contains(element);
            return result;
        }
        catch (JaxenException e) {
            throw new MatchException(element, (Throwable)e);
        }
    }
}

