/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.merge;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.DocumentException;
import com.izforge.izpack.util.xmlmerge.Mapper;
import com.izforge.izpack.util.xmlmerge.Matcher;
import com.izforge.izpack.util.xmlmerge.MergeAction;
import com.izforge.izpack.util.xmlmerge.ParseException;
import com.izforge.izpack.util.xmlmerge.XmlMerge;
import com.izforge.izpack.util.xmlmerge.action.FullMergeAction;
import com.izforge.izpack.util.xmlmerge.factory.StaticOperationFactory;
import com.izforge.izpack.util.xmlmerge.mapper.IdentityMapper;
import com.izforge.izpack.util.xmlmerge.matcher.AttributeMatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DefaultXmlMerge
implements XmlMerge {
    private MergeAction m_rootMergeAction = new FullMergeAction();
    private Matcher m_rootMatcher = new AttributeMatcher();

    public DefaultXmlMerge() {
        this.m_rootMergeAction.setActionFactory(new StaticOperationFactory(new FullMergeAction()));
        this.m_rootMergeAction.setMapperFactory(new StaticOperationFactory(new IdentityMapper()));
        this.m_rootMergeAction.setMatcherFactory(new StaticOperationFactory(new AttributeMatcher()));
    }

    @Override
    public void setRootMapper(Mapper rootMapper) {
    }

    @Override
    public void setRootMergeAction(MergeAction rootMergeAction) {
        this.m_rootMergeAction = rootMergeAction;
    }

    @Override
    public String merge(String[] sources) throws AbstractXmlMergeException {
        InputStream[] inputStreams = new InputStream[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            inputStreams[i] = new ByteArrayInputStream(sources[i].getBytes());
        }
        InputStream merged = this.merge(inputStreams);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = merged.read(buffer)) != -1) {
                result.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result.toString();
    }

    @Override
    public org.w3c.dom.Document merge(org.w3c.dom.Document[] sources) throws AbstractXmlMergeException {
        DOMBuilder domb = new DOMBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            docs[i] = domb.build(sources[i]);
        }
        Document result = this.doMerge(docs);
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(result);
        }
        catch (JDOMException e) {
            throw new DocumentException(result, (Throwable)e);
        }
    }

    @Override
    public InputStream merge(InputStream[] sources) throws AbstractXmlMergeException {
        SAXBuilder sxb = new SAXBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                docs[i] = sxb.build(sources[i]);
                continue;
            }
            catch (JDOMException e) {
                throw new ParseException(e);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ParseException(ioe);
            }
        }
        Document result = this.doMerge(docs);
        Format prettyFormatter = Format.getPrettyFormat();
        prettyFormatter.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter sortie = new XMLOutputter(prettyFormatter);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            sortie.output(result, (OutputStream)buffer);
        }
        catch (IOException ex) {
            throw new DocumentException(result, (Throwable)ex);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    @Override
    public void merge(File[] sources, File target) throws AbstractXmlMergeException {
        SAXBuilder sxb = new SAXBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                docs[i] = sxb.build(sources[i]);
                continue;
            }
            catch (JDOMException e) {
                throw new ParseException(e);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ParseException(ioe);
            }
        }
        Document result = this.doMerge(docs);
        Format prettyFormatter = Format.getPrettyFormat();
        prettyFormatter.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter sortie = new XMLOutputter(prettyFormatter);
        try {
            sortie.output(result, (OutputStream)new FileOutputStream(target));
        }
        catch (IOException ex) {
            throw new DocumentException(result, (Throwable)ex);
        }
    }

    private Document doMerge(Document[] docs) throws AbstractXmlMergeException {
        Document originalDoc = docs[0];
        for (int i = 1; i < docs.length; ++i) {
            if (!this.m_rootMatcher.matches(originalDoc.getRootElement(), docs[i].getRootElement())) {
                throw new IllegalArgumentException("Root elements do not match.");
            }
            Document output = new Document();
            if (originalDoc.getDocType() != null) {
                output.setDocType((DocType)originalDoc.getDocType().clone());
            }
            output.setRootElement(new Element("root"));
            this.m_rootMergeAction.perform(originalDoc.getRootElement(), docs[i].getRootElement(), output.getRootElement());
            Element root = (Element)output.getRootElement().getChildren().get(0);
            root.detach();
            originalDoc.setRootElement(root);
        }
        return originalDoc;
    }
}

