/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.handler;

import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.handler.Prompt;

public abstract class PromptUIHandler
implements AbstractUIHandler {
    private final Prompt prompt;

    public PromptUIHandler(Prompt prompt) {
        this.prompt = prompt;
    }

    @Override
    public boolean emitWarning(String title, String message) {
        return this.prompt.confirm(Prompt.Type.WARNING, title, message, Prompt.Options.OK_CANCEL, Prompt.Option.OK) == Prompt.Option.OK;
    }

    @Override
    public void emitError(String title, String message) {
        this.prompt.message(Prompt.Type.ERROR, title, message);
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        this.emitError(title, message);
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        int choice;
        if (choices == 37) {
            Prompt.Option defaultValue;
            switch (default_choice) {
                case 47: {
                    defaultValue = Prompt.Option.YES;
                    break;
                }
                case 49: {
                    defaultValue = Prompt.Option.NO;
                    break;
                }
                default: {
                    defaultValue = null;
                }
            }
            Prompt.Option selected = this.prompt.confirm(Prompt.Type.QUESTION, question, Prompt.Options.YES_NO, defaultValue);
            choice = selected == Prompt.Option.OK ? 47 : 49;
        } else {
            Prompt.Option defaultValue;
            switch (default_choice) {
                case 47: {
                    defaultValue = Prompt.Option.YES;
                    break;
                }
                case 49: {
                    defaultValue = Prompt.Option.NO;
                    break;
                }
                case 45: {
                    defaultValue = Prompt.Option.CANCEL;
                    break;
                }
                default: {
                    defaultValue = null;
                }
            }
            Prompt.Option selected = this.prompt.confirm(Prompt.Type.QUESTION, question, Prompt.Options.YES_NO_CANCEL, defaultValue);
            choice = selected == Prompt.Option.YES ? 47 : (selected == Prompt.Option.NO ? 49 : 45);
        }
        return choice;
    }
}

